/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitWayAction
extends JosmAction {
    private Way selectedWay;
    private List<Node> selectedNodes;

    public SplitWayAction() {
        super(I18n.tr("Split Way"), "splitway", I18n.tr("Split a way at the selected node."), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way")), 80, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HashSet<Node> hashSet;
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        if (!this.checkSelection(collection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The current selection cannot be used for splitting."), I18n.tr("Warning"), 2);
            return;
        }
        this.selectedWay = null;
        this.selectedNodes = null;
        AbstractVisitor abstractVisitor = new AbstractVisitor(){

            public void visit(Node node) {
                if (SplitWayAction.this.selectedNodes == null) {
                    SplitWayAction.this.selectedNodes = new LinkedList();
                }
                SplitWayAction.this.selectedNodes.add(node);
            }

            public void visit(Way way) {
                SplitWayAction.this.selectedWay = way;
            }

            public void visit(Relation relation) {
            }
        };
        for (OsmPrimitive iterator : collection) {
            iterator.visit(abstractVisitor);
        }
        if (this.selectedWay == null && this.selectedNodes != null) {
            hashSet = new HashMap();
            for (Node node : this.selectedNodes) {
                block2: for (Way way : OsmPrimitive.getFilteredList(node.getReferrers(), Way.class)) {
                    int n;
                    if (!way.isUsable() || (n = way.getNodesCount() - 1) <= 0) continue;
                    boolean bl = way.isClosed();
                    int n2 = 0;
                    for (Node node2 : way.getNodes()) {
                        if ((bl || n2 > 0 && n2 < n) && node.equals(node2)) {
                            Integer n3 = (Integer)hashSet.get(way);
                            hashSet.put(way, n3 == null ? 1 : n3 + 1);
                            continue block2;
                        }
                        ++n2;
                    }
                }
            }
            if (hashSet.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", this.selectedNodes.size()), I18n.tr("Warning"), 2);
                return;
            }
            for (Map.Entry entry : hashSet.entrySet()) {
                if (!((Integer)entry.getValue()).equals(this.selectedNodes.size())) continue;
                if (this.selectedWay != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", this.selectedNodes.size()), I18n.tr("Warning"), 2);
                    return;
                }
                this.selectedWay = (Way)entry.getKey();
            }
            if (this.selectedWay == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected nodes do not share the same way."), I18n.tr("Warning"), 2);
                return;
            }
        } else if (this.selectedWay != null && this.selectedNodes != null) {
            hashSet = new HashSet<Node>(this.selectedNodes);
            for (Node node : this.selectedWay.getNodes()) {
                hashSet.remove(node);
            }
            if (!hashSet.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected way does not contain the selected node.", "The selected way does not contain all the selected nodes.", this.selectedNodes.size()), I18n.tr("Warning"), 2);
                return;
            }
        }
        this.splitWay();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> collection) {
        boolean bl = false;
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Way && !bl) {
                bl = true;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl2;
    }

    private void splitWay() {
        Object object;
        HashSet<Node> hashSet = new HashSet<Node>(this.selectedNodes);
        LinkedList<List<Node>> linkedList = new LinkedList<List<Node>>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        linkedList.add(arrayList);
        Iterator<Node> iterator = this.selectedWay.getNodes().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = arrayList.isEmpty() || !iterator.hasNext();
            arrayList.add(object);
            if (!hashSet.contains(object) || bl) continue;
            arrayList = new ArrayList();
            arrayList.add(object);
            linkedList.add(arrayList);
        }
        object = (List)linkedList.get(linkedList.size() - 1);
        if (linkedList.size() >= 2 && ((List)linkedList.get(0)).get(0) == object.get(object.size() - 1) && !hashSet.contains(((List)linkedList.get(0)).get(0))) {
            if (linkedList.size() == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
                return;
            }
            object.remove(object.size() - 1);
            object.addAll((Collection)linkedList.get(0));
            linkedList.remove(linkedList.size() - 1);
            linkedList.set(0, (List<Node>)object);
        }
        if (linkedList.size() < 2) {
            if (((List)linkedList.get(0)).get(0) == ((List)linkedList.get(0)).get(((List)linkedList.get(0)).size() - 1)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)"), I18n.tr("Warning"), 2);
            }
            return;
        }
        SplitWayResult splitWayResult = SplitWayAction.splitWay(this.selectedWay, linkedList);
        Main.main.undoRedo.add(splitWayResult.getCommand());
        this.getCurrentDataSet().setSelected(splitWayResult.getNewSelection());
    }

    /*
     * WARNING - void declaration
     */
    public static SplitWayResult splitWay(Way way, List<List<Node>> list) {
        Comparable<Boolean> comparable;
        ArrayList<Command> arrayList = new ArrayList<Command>(list.size());
        ArrayList<Comparable<Boolean>> arrayList2 = new ArrayList<Comparable<Boolean>>(list.size());
        Iterator<List<Node>> iterator = list.iterator();
        Way way2 = new Way(way);
        way2.setNodes(iterator.next());
        arrayList.add(new ChangeCommand(way, way2));
        arrayList2.add(way);
        ArrayList<Comparable<Boolean>> arrayList3 = new ArrayList<Comparable<Boolean>>();
        while (iterator.hasNext()) {
            comparable = new Way();
            ((OsmPrimitive)comparable).setKeys(way.getKeys());
            arrayList3.add(comparable);
            ((Way)comparable).setNodes(iterator.next());
            arrayList.add(new AddCommand((OsmPrimitive)comparable));
            arrayList2.add(comparable);
        }
        comparable = false;
        Boolean bl = false;
        for (Relation relation : OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class)) {
            if (!relation.isUsable()) continue;
            Relation relation2 = null;
            String string = relation.get("type");
            if (string == null) {
                string = "";
            }
            int n = 0;
            List<RelationMember> list2 = relation.getMembers();
            for (RelationMember relationMember : list2) {
                if (relationMember.isWay() && relationMember.getMember() == way) {
                    Object object2;
                    Object object4;
                    boolean bl2 = true;
                    if ("restriction".equals(string)) {
                        object4 = relationMember.getRole();
                        if ("from".equals(object4) || "to".equals(object4)) {
                            void var21_27;
                            OsmPrimitive osmPrimitive = null;
                            for (RelationMember relationMember2 : relation.getMembers()) {
                                if (!"via".equals(relationMember2.getRole())) continue;
                                osmPrimitive = relationMember2.getMember();
                            }
                            object2 = new ArrayList();
                            if (osmPrimitive != null) {
                                if (osmPrimitive instanceof Node) {
                                    object2.add((Node)osmPrimitive);
                                } else if (osmPrimitive instanceof Way) {
                                    object2.add(((Way)osmPrimitive).lastNode());
                                    object2.add(((Way)osmPrimitive).firstNode());
                                }
                            }
                            Object var21_26 = null;
                            Object object = object2.iterator();
                            while (object.hasNext()) {
                                Node node = (Node)object.next();
                                if (!way2.isFirstLastNode(node)) continue;
                                Way way3 = way;
                            }
                            if (var21_27 == null) {
                                void var21_29;
                                for (Way way4 : arrayList3) {
                                    Iterator iterator2 = object2.iterator();
                                    while (iterator2.hasNext()) {
                                        Node node = (Node)iterator2.next();
                                        if (!way4.isFirstLastNode(node)) continue;
                                        Way way5 = way4;
                                    }
                                }
                                if (var21_29 != null) {
                                    if (relation2 == null) {
                                        relation2 = new Relation(relation);
                                    }
                                    relation2.addMember(new RelationMember((String)object4, (OsmPrimitive)var21_29));
                                    relation2.removeMembersFor(way);
                                    bl2 = false;
                                }
                            } else {
                                bl2 = false;
                            }
                        } else if (!"via".equals(object4)) {
                            bl = true;
                        }
                    } else if (!"route".equals(string) && !"multipolygon".equals(string)) {
                        bl = true;
                    }
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                    }
                    if (bl2) {
                        if (relationMember.hasRole() && !"multipolygon".equals(string)) {
                            comparable = true;
                        }
                        object4 = null;
                        int n2 = 1;
                        while (n - n2 >= 0 || n + n2 < list2.size()) {
                            if (n - n2 >= 0 && list2.get(n - n2).isWay()) {
                                object2 = list2.get(n - n2).getWay();
                                if (((Way)object2).lastNode() == way.firstNode() || ((Way)object2).firstNode() == way.firstNode()) {
                                    object4 = false;
                                    break;
                                }
                                if (((Way)object2).firstNode() != way.lastNode() && ((Way)object2).lastNode() != way.lastNode()) break;
                                object4 = true;
                                break;
                            }
                            if (n + n2 < list2.size() && list2.get(n + n2).isWay()) {
                                object2 = list2.get(n + n2).getWay();
                                if (((Way)object2).lastNode() == way.firstNode() || ((Way)object2).firstNode() == way.firstNode()) {
                                    object4 = true;
                                    break;
                                }
                                if (((Way)object2).firstNode() != way.lastNode() && ((Way)object2).lastNode() != way.lastNode()) break;
                                object4 = false;
                                break;
                            }
                            ++n2;
                        }
                        int n3 = n;
                        for (Object object : arrayList3) {
                            RelationMember relationMember3 = new RelationMember(relationMember.getRole(), (OsmPrimitive)object);
                            ++n3;
                            if (object4 != null && ((Boolean)object4).booleanValue()) {
                                relation2.addMember(n, relationMember3);
                                continue;
                            }
                            relation2.addMember(n3, relationMember3);
                        }
                        n = n3;
                    }
                }
                ++n;
            }
            if (relation2 == null) continue;
            arrayList.add(new ChangeCommand(relation, relation2));
        }
        if (((Boolean)comparable).booleanValue()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        } else if (bl.booleanValue()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        }
        return new SplitWayResult(new SequenceCommand(I18n.tr("Split way {0} into {1} parts", way.getDisplayName(DefaultNameFormatter.getInstance()), list.size()), arrayList), arrayList2);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.checkSelection(collection));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitWayResult {
        private final Command command;
        private final List<? extends PrimitiveId> newSelection;

        public SplitWayResult(Command command, List<? extends PrimitiveId> list) {
            this.command = command;
            this.newSelection = list;
        }

        public Command getCommand() {
            return this.command;
        }

        public List<? extends PrimitiveId> getNewSelection() {
            return this.newSelection;
        }
    }
}

