/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombineWayAction
extends JosmAction {
    public CombineWayAction() {
        super(I18n.tr("Combine Way"), "combineway", I18n.tr("Combine several ways into one."), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way")), 67, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/CombineWay"));
    }

    protected boolean confirmChangeDirectionOfWays() {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change directions?"), new String[]{I18n.tr("Reverse and Combine"), I18n.tr("Cancel")});
        extendedDialog.setButtonIcons(new String[]{"wayflip.png", "cancel.png"});
        extendedDialog.setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?"));
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    protected void warnCombiningImpossible() {
        String string = I18n.tr("Could not combine ways (They could not be merged into a single string of nodes)");
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Information"), 1);
    }

    protected Way getTargetWay(Collection<Way> collection) {
        Way way = collection.iterator().next();
        Iterator<Way> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Way way2;
            way = way2 = iterator.next();
            if (way2.isNew()) continue;
            break;
        }
        return way;
    }

    protected Set<Relation> getParentRelations(Collection<Way> collection) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (Way way : collection) {
            hashSet.addAll(OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class));
        }
        return hashSet;
    }

    public void combineWays(Collection<Way> collection) {
        Object object;
        Iterable<Tag> iterable;
        Iterable<Tag> iterable2;
        List<Way> list;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        collection.remove(null);
        collection = new HashSet<Way>(collection);
        NodeGraph nodeGraph = NodeGraph.createUndirectedGraphFromNodeWays(collection);
        List<Node> list2 = nodeGraph.buildSpanningPath();
        if (list2 == null) {
            this.warnCombiningImpossible();
            return;
        }
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        List<Way> list3 = new LinkedList<Way>();
        List<Way> list4 = new LinkedList<Way>();
        for (Way object32 : collection) {
            if (list2.indexOf(object32.getNode(0)) + 1 == list2.lastIndexOf(object32.getNode(1))) {
                list4.add(object32);
                continue;
            }
            list3.add(object32);
        }
        if (list4.isEmpty()) {
            Collections.reverse(list2);
            list4 = list3;
            list3 = null;
        }
        if (list3 != null && !list3.isEmpty()) {
            if (!this.confirmChangeDirectionOfWays()) {
                return;
            }
            list4 = ReverseWayTagCorrector.irreversibleWays(list4);
            if ((list3 = ReverseWayTagCorrector.irreversibleWays(list3)).size() > list4.size()) {
                Collections.reverse(list2);
                list = list4;
                list4 = list3;
                list3 = list;
            }
            if (!list3.isEmpty() && Main.pref.getBoolean("tag-correction.reverse-way", true)) {
                list = new ArrayList<Way>(collection);
                list.removeAll(list3);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                iterable2 = new ArrayList();
                iterable = null;
                for (Way way : list3) {
                    object = new Way(way);
                    iterable2.add((Way)object);
                    try {
                        iterable = reverseWayTagCorrector.execute(way, (Way)object);
                    }
                    catch (UserCancelException userCancelException) {
                        return;
                    }
                }
                if (iterable != null && !iterable.isEmpty()) {
                    for (Command command : iterable) {
                        command.executeCommand();
                    }
                }
                tagCollection = TagCollection.unionOfAllPrimitives(iterable2);
                tagCollection.add(TagCollection.unionOfAllPrimitives(list));
            }
        }
        list = this.getTargetWay(collection);
        Way way = new Way((Way)((Object)list));
        way.setNodes(list2);
        iterable2 = new TagCollection(tagCollection);
        TagConflictResolutionUtil.combineTigerTags((TagCollection)iterable2);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing((TagCollection)iterable2, collection);
        iterable = new TagCollection((TagCollection)iterable2);
        TagConflictResolutionUtil.completeTagCollectionForEditing(iterable);
        Iterator iterator = CombinePrimitiveResolverDialog.getInstance();
        ((CombinePrimitiveResolverDialog)((Object)iterator)).getTagConflictResolverModel().populate((TagCollection)iterable, ((TagCollection)iterable2).getKeysWithMultipleValues());
        ((CombinePrimitiveResolverDialog)((Object)iterator)).setTargetPrimitive((OsmPrimitive)((Object)list));
        Set<Relation> set = this.getParentRelations(collection);
        ((CombinePrimitiveResolverDialog)((Object)iterator)).getRelationMemberConflictResolverModel().populate(set, collection);
        ((CombinePrimitiveResolverDialog)((Object)iterator)).prepareDefaultDecisions();
        if (!((TagCollection)iterable2).isApplicableToPrimitive() || !set.isEmpty()) {
            ((CombinePrimitiveResolverDialog)((Object)iterator)).setVisible(true);
            if (((CombinePrimitiveResolverDialog)((Object)iterator)).isCancelled()) {
                return;
            }
        }
        object = new LinkedList();
        LinkedList<Way> linkedList = new LinkedList<Way>(collection);
        linkedList.remove(list);
        ((LinkedList)object).add(new DeleteCommand(linkedList));
        ((LinkedList)object).add(new ChangeCommand((OsmPrimitive)((Object)list), way));
        ((LinkedList)object).addAll(((CombinePrimitiveResolverDialog)((Object)iterator)).buildResolutionCommands());
        final SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Combine {0} ways", collection.size()), (Collection<Command>)object);
        List<Way> list5 = list;
        Runnable runnable = new Runnable((Way)((Object)list5)){
            final /* synthetic */ Way val$selectedWay;
            {
                this.val$selectedWay = way;
            }

            public void run() {
                Main.main.undoRedo.add(sequenceCommand);
                CombineWayAction.this.getCurrentDataSet().setSelected(this.val$selectedWay);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        LinkedHashSet<Way> linkedHashSet = OsmPrimitive.getFilteredSet(collection, Way.class);
        if (linkedHashSet.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two ways to combine."), I18n.tr("Information"), 1);
            return;
        }
        this.combineWays(linkedHashSet);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        this.updateEnabledState(collection);
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        this.setEnabled(n >= 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeGraph {
        private Set<NodePair> edges = new HashSet<NodePair>();
        private int numUndirectedEges = 0;
        private HashMap<Node, List<NodePair>> successors;
        private HashMap<Node, List<NodePair>> predecessors;

        public static List<NodePair> buildNodePairs(Way way, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                arrayList.add(new NodePair(pair));
                if (bl) continue;
                arrayList.add(new NodePair(pair).swap());
            }
            return arrayList;
        }

        public static List<NodePair> buildNodePairs(List<Way> list, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Way way : list) {
                arrayList.addAll(NodeGraph.buildNodePairs(way, bl));
            }
            return arrayList;
        }

        public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> list) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (NodePair nodePair : list) {
                if (arrayList.contains(nodePair) || arrayList.contains(nodePair.swap())) continue;
                arrayList.add(nodePair);
            }
            return arrayList;
        }

        public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
            }
            return nodeGraph;
        }

        public static NodeGraph createDirectedGraphFromWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, true));
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
                nodeGraph.add(nodePair.swap());
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, false));
            }
            return nodeGraph;
        }

        protected void rememberSuccessor(NodePair nodePair) {
            if (this.successors.containsKey(nodePair.getA())) {
                if (!this.successors.get(nodePair.getA()).contains(nodePair)) {
                    this.successors.get(nodePair.getA()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.successors.put(nodePair.getA(), arrayList);
            }
        }

        protected void rememberPredecessors(NodePair nodePair) {
            if (this.predecessors.containsKey(nodePair.getB())) {
                if (!this.predecessors.get(nodePair.getB()).contains(nodePair)) {
                    this.predecessors.get(nodePair.getB()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.predecessors.put(nodePair.getB(), arrayList);
            }
        }

        protected boolean isTerminalNode(Node node) {
            if (this.successors.get(node) == null) {
                return false;
            }
            if (this.successors.get(node).size() != 1) {
                return false;
            }
            if (this.predecessors.get(node) == null) {
                return true;
            }
            if (this.predecessors.get(node).size() == 1) {
                NodePair nodePair = this.successors.get(node).iterator().next();
                NodePair nodePair2 = this.predecessors.get(node).iterator().next();
                return nodePair.equals(nodePair2.swap());
            }
            return false;
        }

        protected void prepare() {
            HashSet<NodePair> hashSet = new HashSet<NodePair>();
            this.successors = new HashMap();
            this.predecessors = new HashMap();
            for (NodePair nodePair : this.edges) {
                if (!hashSet.contains(nodePair) && !hashSet.contains(nodePair.swap())) {
                    hashSet.add(nodePair);
                }
                this.rememberSuccessor(nodePair);
                this.rememberPredecessors(nodePair);
            }
            this.numUndirectedEges = hashSet.size();
        }

        public void add(NodePair nodePair) {
            if (!this.edges.contains(nodePair)) {
                this.edges.add(nodePair);
            }
        }

        public void add(List<NodePair> list) {
            for (NodePair nodePair : list) {
                this.add(nodePair);
            }
        }

        protected Node getStartNode() {
            Set<Node> set = this.getNodes();
            for (Node node : set) {
                if (this.successors.get(node) == null || this.successors.get(node).size() != 1) continue;
                return node;
            }
            return null;
        }

        protected Set<Node> getTerminalNodes() {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Node node : this.getNodes()) {
                if (!this.isTerminalNode(node)) continue;
                hashSet.add(node);
            }
            return hashSet;
        }

        protected Set<Node> getNodes(Stack<NodePair> stack) {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (NodePair nodePair : stack) {
                hashSet.add(nodePair.getA());
                hashSet.add(nodePair.getB());
            }
            return hashSet;
        }

        protected List<NodePair> getOutboundPairs(NodePair nodePair) {
            return this.getOutboundPairs(nodePair.getB());
        }

        protected List<NodePair> getOutboundPairs(Node node) {
            List<NodePair> list = this.successors.get(node);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        protected Set<Node> getNodes() {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (NodePair nodePair : this.edges) {
                hashSet.add(nodePair.getA());
                hashSet.add(nodePair.getB());
            }
            return hashSet;
        }

        protected boolean isSpanningWay(Stack<NodePair> stack) {
            return this.numUndirectedEges == stack.size();
        }

        protected List<Node> buildPathFromNodePairs(Stack<NodePair> stack) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (NodePair nodePair : stack) {
                linkedList.add(nodePair.getA());
            }
            linkedList.add(stack.peek().getB());
            return linkedList;
        }

        protected List<Node> buildSpanningPath(Node node) {
            if (node == null) {
                return null;
            }
            Stack<NodePair> stack = new Stack<NodePair>();
            Stack<NodePair> stack2 = new Stack<NodePair>();
            stack2.addAll(this.getOutboundPairs(node));
            while (!stack2.isEmpty()) {
                NodePair nodePair = (NodePair)stack2.pop();
                if (stack.contains(nodePair) || stack.contains(nodePair.swap())) continue;
                while (!stack.isEmpty() && !((NodePair)stack.peek()).isPredecessorOf(nodePair)) {
                    stack.pop();
                }
                stack.push(nodePair);
                if (this.isSpanningWay(stack)) {
                    return this.buildPathFromNodePairs(stack);
                }
                stack2.addAll(this.getOutboundPairs(stack.peek()));
            }
            return null;
        }

        public List<Node> buildSpanningPath() {
            this.prepare();
            Set<Node> set = this.getTerminalNodes();
            set = set.isEmpty() ? this.getNodes() : set;
            for (Node node : set) {
                List<Node> list = this.buildSpanningPath(node);
                if (list == null) continue;
                return list;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodePair {
        private Node a;
        private Node b;

        public NodePair(Node node, Node node2) {
            this.a = node;
            this.b = node2;
        }

        public NodePair(Pair<Node, Node> pair) {
            this.a = (Node)pair.a;
            this.b = (Node)pair.b;
        }

        public NodePair(NodePair nodePair) {
            this.a = nodePair.a;
            this.b = nodePair.b;
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public boolean isAdjacentToA(NodePair nodePair) {
            return nodePair.getA() == this.a || nodePair.getB() == this.a;
        }

        public boolean isAdjacentToB(NodePair nodePair) {
            return nodePair.getA() == this.b || nodePair.getB() == this.b;
        }

        public boolean isSuccessorOf(NodePair nodePair) {
            return nodePair.getB() == this.a;
        }

        public boolean isPredecessorOf(NodePair nodePair) {
            return this.b == nodePair.getA();
        }

        public NodePair swap() {
            return new NodePair(this.b, this.a);
        }

        public String toString() {
            return "[" + this.a.getId() + "," + this.b.getId() + "]";
        }

        public boolean contains(Node node) {
            return this.a == node || this.b == node;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.a == null ? 0 : this.a.hashCode());
            n = 31 * n + (this.b == null ? 0 : this.b.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NodePair nodePair = (NodePair)object;
            if (this.a == null ? nodePair.a != null : !this.a.equals(nodePair.a)) {
                return false;
            }
            return !(this.b == null ? nodePair.b != null : !this.b.equals(nodePair.b));
        }
    }
}

