/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import org.openstreetmap.josm.gui.MainApplication;
import org.xnap.commons.i18n.I18nFactory;

public class I18n {
    private static final String TR_BASE = "org.openstreetmap.josm.i18n.Translation_";
    public static org.xnap.commons.i18n.I18n i18n;

    public static final String tr(String string, Object ... objectArray) {
        if (i18n == null) {
            return MessageFormat.format(I18n.filter(string), objectArray);
        }
        return I18n.filter(i18n.tr(string, objectArray));
    }

    public static final String tr(String string) {
        if (i18n == null) {
            return I18n.filter(string);
        }
        return I18n.filter(i18n.tr(string));
    }

    public static final String trc(String string, String string2) {
        if (i18n == null) {
            return string2;
        }
        return i18n.trc(string, string2);
    }

    public static final String marktr(String string) {
        return string;
    }

    public static final String marktrc(String string, String string2) {
        return string2;
    }

    public static final String trn(String string, String string2, long l, Object ... objectArray) {
        if (i18n == null) {
            return l == 1L ? I18n.tr(string, objectArray) : I18n.tr(string2, objectArray);
        }
        return I18n.filter(i18n.trn(string, string2, l, objectArray));
    }

    public static final String trn(String string, String string2, long l) {
        if (i18n == null) {
            return l == 1L ? I18n.tr(string) : I18n.tr(string2);
        }
        return I18n.filter(i18n.trn(string, string2, l));
    }

    public static final String trnc(String string, String string2, String string3, long l, Object ... objectArray) {
        if (i18n == null) {
            return l == 1L ? I18n.tr(string2, objectArray) : I18n.tr(string3, objectArray);
        }
        return i18n.trnc(string, string2, string3, l, objectArray);
    }

    public static final String trnc(String string, String string2, String string3, long l) {
        if (i18n == null) {
            return l == 1L ? I18n.tr(string2) : I18n.tr(string3);
        }
        return i18n.trnc(string, string2, string3, l);
    }

    public static final String filter(String string) {
        int n;
        if (string.startsWith("_:") && (n = string.indexOf("\n")) >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static final Locale[] getAvailableTranslations() {
        Vector<Locale> vector = new Vector<Locale>();
        LinkedList<String> linkedList = new LinkedList<String>();
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            String string = localeArray[i].toString();
            String string2 = TR_BASE + string;
            try {
                Class.forName(string2);
                vector.add(localeArray[i]);
                linkedList.add(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            if (!linkedList.contains("nb")) {
                vector.add(new Locale("nb"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!linkedList.contains("gl")) {
                vector.add(new Locale("gl"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        localeArray = new Locale[vector.size()];
        localeArray = vector.toArray(localeArray);
        Arrays.sort(localeArray, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale, Locale locale2) {
                return locale.toString().compareTo(locale2.toString());
            }
        });
        return localeArray;
    }

    public static void init() {
        try {
            i18n = I18nFactory.getI18n(MainApplication.class);
        }
        catch (MissingResourceException missingResourceException) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    public static void set(String string) {
        if (string != null) {
            int n;
            Locale locale = Locale.getDefault();
            if (string.equals("he")) {
                string = "iw_IL";
            }
            Locale locale2 = (n = string.indexOf(95)) > 0 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string);
            try {
                Locale.setDefault(locale2);
                i18n = I18nFactory.getI18n(MainApplication.class);
            }
            catch (MissingResourceException missingResourceException) {
                if (!locale2.getLanguage().equals("en")) {
                    System.out.println(I18n.tr("Unable to find translation for the locale {0}. Reverting to {1}.", locale2.getDisplayName(), locale.getDisplayName()));
                    Locale.setDefault(locale);
                }
                i18n = null;
            }
        }
    }
}

