/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class ProgressInputStream
extends InputStream {
    private final InputStream in;
    private int readSoFar = 0;
    private int lastDialogUpdate = 0;
    private boolean sizeKnown;
    private final URLConnection connection;
    private final ProgressMonitor progressMonitor;

    public ProgressInputStream(URLConnection uRLConnection, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.connection = uRLConnection;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.progressMonitor = progressMonitor;
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server..."), 1);
        progressMonitor.indeterminateSubTask(null);
        try {
            this.in = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            progressMonitor.finishTask();
            if (uRLConnection.getHeaderField("Error") != null) {
                throw new OsmTransferException(I18n.tr(uRLConnection.getHeaderField("Error")));
            }
            throw new OsmTransferException(iOException);
        }
        this.updateSize();
        if (!this.sizeKnown) {
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data..."));
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.progressMonitor.finishTask();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.advanceTicker(n3);
        } else {
            this.progressMonitor.finishTask();
        }
        return n3;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.advanceTicker(1);
        } else {
            this.progressMonitor.finishTask();
        }
        return n;
    }

    private void advanceTicker(int n) {
        this.readSoFar += n;
        this.updateSize();
        if (this.readSoFar / 1024 != this.lastDialogUpdate) {
            ++this.lastDialogUpdate;
            if (this.sizeKnown) {
                this.progressMonitor.setExtraText(this.readSoFar / 1024 + " KB");
                this.progressMonitor.setTicks(this.readSoFar);
            } else {
                this.progressMonitor.setExtraText("??? KB");
            }
        }
    }

    private void updateSize() {
        if (!this.sizeKnown && this.connection.getContentLength() > 0) {
            this.sizeKnown = true;
            this.progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
            this.progressMonitor.setTicksCount(this.connection.getContentLength());
        }
    }
}

