/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter {
    private static final Logger logger = Logger.getLogger(OsmServerWriter.class.getName());
    private Collection<OsmPrimitive> processed;
    private OsmApi api = OsmApi.getOsmApi();
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - this.uploadStartTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        float f = (float)n / (float)l2;
        float f2 = n2 - n;
        int n3 = (int)(f2 / f);
        int n4 = n3 / 60000;
        int n5 = n3 / 1000 % 60;
        String string = Integer.toString(n4) + ":";
        if (n5 < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n5);
        return string;
    }

    protected void uploadChangesIndividually(Collection<OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload with one request per primitive ..."));
            progressMonitor.setTicksCount(collection.size());
            this.uploadStartTime = System.currentTimeMillis();
            for (OsmPrimitive osmPrimitive : collection) {
                int n = progressMonitor.getTicks();
                String string = this.timeLeft(n, collection.size());
                String string2 = "";
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading node ''{4}'' (id: {5})");
                        break;
                    }
                    case WAY: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading way ''{4}'' (id: {5})");
                        break;
                    }
                    case RELATION: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading relation ''{4}'' (id: {5})");
                    }
                }
                progressMonitor.subTask(I18n.tr(string2, Math.round(100.0 * (double)n / (double)collection.size()), n, collection.size(), string, osmPrimitive.getName() == null ? Long.valueOf(osmPrimitive.getId()) : osmPrimitive.getName(), osmPrimitive.getId()));
                this.makeApiRequest(osmPrimitive, progressMonitor);
                this.processed.add(osmPrimitive);
                progressMonitor.worked(1);
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesAsDiffUpload(Collection<OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in one request ..."));
            this.processed.addAll(this.api.uploadDiff(collection, progressMonitor.createSubTaskMonitor(-1, false)));
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void uploadOsm(String string, Collection<OsmPrimitive> collection, Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (changeset == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "changeset"));
        }
        this.processed = new LinkedList<OsmPrimitive>();
        progressMonitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        progressMonitor.beginTask(I18n.tr("Uploading data ..."));
        try {
            boolean bl;
            this.api.initialize(progressMonitor);
            boolean bl2 = this.api.hasSupportForDiffUploads();
            if (string == null) {
                System.out.println(I18n.tr("WARNING: no API version defined for data to upload. Falling back to version 0.6"));
                string = "0.6";
            }
            if ((bl = Main.pref.getBoolean("osm-server.atomic-upload", string.compareTo("0.6") >= 0)) && !bl2) {
                System.out.println(I18n.tr("WARNING: preference ''{0}'' or API version ''{1}'' of dataset requires to use diff uploads, but API is not able to handle them. Ignoring diff upload.", "osm-server.atomic-upload", string));
                bl = false;
            }
            if (changeset.getId() == 0L) {
                this.api.openChangeset(changeset, progressMonitor.createSubTaskMonitor(0, false));
            } else {
                this.api.updateChangeset(changeset, progressMonitor.createSubTaskMonitor(0, false));
            }
            this.api.setChangeset(changeset);
            if (bl) {
                this.uploadChangesAsDiffUpload(collection, progressMonitor.createSubTaskMonitor(0, false));
            } else {
                this.uploadChangesIndividually(collection, progressMonitor.createSubTaskMonitor(0, false));
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            this.api.setChangeset(null);
        }
    }

    void makeApiRequest(OsmPrimitive osmPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (osmPrimitive.isDeleted()) {
            this.api.deletePrimitive(osmPrimitive, progressMonitor);
        } else if (osmPrimitive.getId() == 0L) {
            this.api.createPrimitive(osmPrimitive, progressMonitor);
        } else {
            this.api.modifyPrimitive(osmPrimitive, progressMonitor);
        }
    }

    public void cancel() {
        if (this.api != null) {
            this.api.cancel();
        }
    }

    public Collection<OsmPrimitive> getProcessedPrimitives() {
        return this.processed;
    }
}

