/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangesetParser;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerChangesetReader
extends OsmServerReader {
    public OsmServerChangesetReader() {
        this.setDoAuthenticate(false);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Changeset> queryChangesets(ChangesetQuery changesetQuery, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (changesetQuery == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "query"));
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            List<Changeset> list;
            progressMonitor.beginTask(I18n.tr("Reading changesets..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("changesets?").append(changesetQuery.getQueryString());
            InputStream inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                List<Changeset> list2 = null;
                return list2;
            }
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading changesets ..."));
            List<Changeset> list3 = list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
            return list3;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Changeset readChangeset(long l, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Reading changeset {0} ...", l));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("changeset/").append(l);
            InputStream inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                Changeset changeset = null;
                return changeset;
            }
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading changeset {0} ...", l));
            List<Changeset> list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
            if (list == null || list.isEmpty()) {
                Changeset changeset = null;
                return changeset;
            }
            Changeset changeset = list.get(0);
            return changeset;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Changeset downloadChangeset(long l, ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }
}

