/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerBackreferenceReader
extends OsmServerReader {
    private long id;
    private OsmPrimitiveType primitiveType;
    private boolean readFull;

    public OsmServerBackreferenceReader(OsmPrimitive osmPrimitive) throws IllegalArgumentException {
        if (osmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitive"));
        }
        if (osmPrimitive.getId() == 0L) {
            throw new IllegalArgumentException(I18n.tr("ID parameter ''{0}'' > 0 expected. Got ''{1}''.", "primitive", osmPrimitive.getId()));
        }
        this.id = osmPrimitive.getId();
        this.primitiveType = OsmPrimitiveType.from(osmPrimitive);
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(long l, OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        if (osmPrimitiveType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        this.id = l;
        this.primitiveType = osmPrimitiveType;
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(OsmPrimitive osmPrimitive, boolean bl) {
        this(osmPrimitive);
        this.readFull = bl;
    }

    public OsmServerBackreferenceReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) throws IllegalArgumentException {
        this(l, osmPrimitiveType);
        this.readFull = false;
    }

    public boolean isReadFull() {
        return this.readFull;
    }

    public void setReadFull(boolean bl) {
        this.readFull = bl;
    }

    protected DataSet getReferringWays(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream inputStream = null;
        progressMonitor.beginTask(null, 2);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/ways");
            inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            progressMonitor.subTask(I18n.tr("Downloading referring ways ..."));
            DataSet dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, true));
            return dataSet;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                this.activeConnection = null;
            }
        }
    }

    protected DataSet getReferringRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream inputStream = null;
        progressMonitor.beginTask(null, 2);
        try {
            progressMonitor.subTask(I18n.tr("Contacting OSM Server..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/relations");
            inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            progressMonitor.subTask(I18n.tr("Downloading referring relations ..."));
            DataSet dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, true));
            return dataSet;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                this.activeConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet readIncompletePrimitives(DataSet dataSet, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            ArrayList<Relation> arrayList;
            Object object;
            Object object2;
            ArrayList<Way> arrayList2 = new ArrayList<Way>(dataSet.ways);
            if (this.isReadFull() || this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                for (Way object3 : arrayList2) {
                    if (object3.getId() <= 0L || !object3.incomplete) continue;
                    OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(object3.getId(), OsmPrimitiveType.from(object3), true);
                    object2 = osmServerObjectReader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    object = new MergeVisitor(dataSet, (DataSet)object2);
                    ((MergeVisitor)object).merge();
                }
            }
            if (this.isReadFull()) {
                arrayList = new ArrayList<Relation>(dataSet.relations);
                for (Relation relation : arrayList) {
                    if (relation.getId() <= 0L || !relation.incomplete) continue;
                    object2 = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.from(relation), true);
                    object = ((OsmServerObjectReader)object2).parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    MergeVisitor mergeVisitor = new MergeVisitor(dataSet, (DataSet)object);
                    mergeVisitor.merge();
                }
            }
            arrayList = dataSet;
            return arrayList;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 3);
        try {
            MergeVisitor mergeVisitor;
            DataSet dataSet;
            DataSet dataSet2 = new DataSet();
            if (this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                dataSet = this.getReferringWays(progressMonitor.createSubTaskMonitor(1, false));
                mergeVisitor = new MergeVisitor(dataSet2, dataSet);
                mergeVisitor.merge();
                dataSet2 = mergeVisitor.getMyDataSet();
            }
            dataSet = this.getReferringRelations(progressMonitor.createSubTaskMonitor(1, false));
            mergeVisitor = new MergeVisitor(dataSet2, dataSet);
            mergeVisitor.merge();
            dataSet2 = mergeVisitor.getMyDataSet();
            this.readIncompletePrimitives(dataSet2, progressMonitor.createSubTaskMonitor(1, false));
            DataSet dataSet3 = dataSet2;
            return dataSet3;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

