/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmChangesetParser {
    private static final Logger logger = Logger.getLogger(OsmChangesetParser.class.getName());
    private List<Changeset> changesets = new LinkedList<Changeset>();

    private OsmChangesetParser() {
    }

    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public static List<Changeset> parse(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        OsmChangesetParser osmChangesetParser = new OsmChangesetParser();
        try {
            progressMonitor.beginTask(I18n.tr("Parsing list of changesets...", 1));
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmChangesetParser osmChangesetParser2 = osmChangesetParser;
            osmChangesetParser2.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmChangesetParser2.new Parser());
            List<Changeset> list = osmChangesetParser.getChangesets();
            return list;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalDataException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalDataException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            throw new IllegalDataException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private Changeset current = null;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws OsmDataParsingException {
            throw new OsmDataParsingException(string).rememberLocation(this.locator);
        }

        protected void parseChangesetAttributes(Changeset changeset, Attributes attributes) throws OsmDataParsingException {
            String string = attributes.getValue("id");
            if (string == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "id"));
            }
            long l = 0L;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "id", string));
            }
            if (l <= 0L) {
                this.throwException(I18n.tr("Illegal nummeric value for attribute ''{0}''. Got ''{1}''.", "id", l));
            }
            this.current.setId(l);
            String string2 = attributes.getValue("user");
            String string3 = attributes.getValue("uid");
            this.current.setUser(this.createUser(string3, string2));
            string = attributes.getValue("created_at");
            if (string == null) {
                this.current.setCreatedAt(null);
            } else {
                this.current.setCreatedAt(DateUtils.fromString(string));
            }
            string = attributes.getValue("closed_at");
            if (string == null) {
                this.current.setClosedAt(null);
            } else {
                this.current.setClosedAt(DateUtils.fromString(string));
            }
            string = attributes.getValue("open");
            if (string == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "open"));
            } else if (string.equals("true")) {
                this.current.setOpen(true);
            } else if (string.equals("false")) {
                this.current.setOpen(false);
            } else {
                this.throwException(I18n.tr("Illegal boolean value for attribute ''{0}''. Got ''{1}''.", "open", string));
            }
            String string4 = attributes.getValue("min_lon");
            String string5 = attributes.getValue("min_lat");
            String string6 = attributes.getValue("max_lon");
            String string7 = attributes.getValue("max_lat");
            if (string4 != null && string5 != null && string6 != null && string7 != null) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lon", string4));
                }
                double d2 = 0.0;
                try {
                    d2 = Double.parseDouble(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lat", string5));
                }
                this.current.setMin(new LatLon(d2, d));
                double d3 = 0.0;
                try {
                    d3 = Double.parseDouble(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lon", string6));
                }
                double d4 = 0.0;
                try {
                    d4 = Double.parseDouble(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lat", string7));
                }
                this.current.setMax(new LatLon(d3, d4));
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("osm")) {
                String string4;
                if (attributes == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                }
                if ((string4 = attributes.getValue("version")) == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                }
                if (!string4.equals("0.6")) {
                    this.throwException(I18n.tr("Unsupported version: {0}", string4));
                }
            } else if (string3.equals("changeset")) {
                this.current = new Changeset();
                this.parseChangesetAttributes(this.current, attributes);
            } else if (string3.equals("tag")) {
                String string5 = attributes.getValue("k");
                String string6 = attributes.getValue("v");
                this.current.put(string5, string6);
            } else {
                this.throwException(I18n.tr("Undefined element ''{0}'' found in input stream. Aborting.", string3));
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("changeset")) {
                OsmChangesetParser.this.changesets.add(this.current);
            }
        }

        protected User createUser(String string, String string2) throws OsmDataParsingException {
            if (string == null) {
                if (string2 == null) {
                    return null;
                }
                return User.createLocalUser(string2);
            }
            try {
                long l = Long.parseLong(string);
                return User.createOsmUser(l, string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''uid''. Got ''{0}''.", string));
                return null;
            }
        }
    }
}

