/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionCache {
    private static final Logger logger = Logger.getLogger(AutoCompletionCache.class.getName());
    private static HashMap<OsmDataLayer, AutoCompletionCache> caches = new HashMap();
    private HashMap<String, Set<String>> tagCache = new HashMap();
    private Set<String> roleCache = new HashSet<String>();
    private OsmDataLayer layer;

    public static AutoCompletionCache getCacheForLayer(OsmDataLayer osmDataLayer) {
        AutoCompletionCache autoCompletionCache = caches.get(osmDataLayer);
        if (autoCompletionCache == null) {
            autoCompletionCache = new AutoCompletionCache(osmDataLayer);
            caches.put(osmDataLayer, autoCompletionCache);
        }
        return autoCompletionCache;
    }

    public AutoCompletionCache(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public AutoCompletionCache() {
        this(null);
    }

    protected void cacheKey(String string) {
        if (this.tagCache.containsKey(string)) {
            return;
        }
        this.tagCache.put(string, new HashSet());
    }

    protected void cacheValue(String string, String string2) {
        this.cacheKey(string);
        this.tagCache.get(string).add(string2);
    }

    protected void cachePrimitive(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            String string2 = osmPrimitive.get(string);
            this.cacheValue(string, string2);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.hasRole() || this.roleCache.contains(relationMember.getRole())) continue;
            this.roleCache.add(relationMember.getRole());
        }
    }

    public void initFromDataSet() {
        this.tagCache = new HashMap();
        if (this.layer == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.layer.data.allNonDeletedPrimitives();
        for (OsmPrimitive osmPrimitive : collection) {
            this.cachePrimitive(osmPrimitive);
        }
        for (Relation relation : this.layer.data.relations) {
            if (relation.incomplete || relation.isDeleted()) continue;
            this.cacheRelationMemberRoles(relation);
        }
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.tagCache.keySet());
    }

    public List<String> getValues(String string) {
        if (!this.tagCache.containsKey(string)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>((Collection)this.tagCache.get(string));
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.roleCache);
    }

    public void populateWithMemberRoles(AutoCompletionList autoCompletionList) {
        autoCompletionList.clear();
        autoCompletionList.add(this.roleCache, AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithTagValues(AutoCompletionList autoCompletionList, String string, boolean bl) {
        if (!bl) {
            autoCompletionList.clear();
        }
        autoCompletionList.add(this.getValues(string), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithKeys(AutoCompletionList autoCompletionList, boolean bl) {
        if (!bl) {
            autoCompletionList.clear();
        }
        autoCompletionList.add(this.tagCache.keySet(), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    static {
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer instanceof OsmDataLayer) {
                    caches.remove(layer);
                }
            }
        });
    }
}

