/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class StyleSources
extends JPanel {
    private JList sourcesList = new JList(new DefaultListModel());
    private JList sourcesDefaults = new JList(new DefaultListModel());
    private JList iconsList = null;
    private String pref;
    private String iconpref;

    /*
     * WARNING - void declaration
     */
    public StyleSources(String string, String string2, final String string3, boolean bl, final String string4) {
        this.sourcesDefaults.setCellRenderer(new MyCellRenderer());
        this.getDefaults(string3);
        this.pref = string;
        this.iconpref = string2;
        Collection<String> collection = Main.pref.getCollection(string, null);
        if (collection != null) {
            for (String object22 : collection) {
                ((DefaultListModel)this.sourcesList.getModel()).addElement(object22);
            }
        }
        Object object3 = null;
        Object var8_9 = null;
        JButton jButton = null;
        if (string2 != null) {
            this.iconsList = new JList(new DefaultListModel());
            collection = Main.pref.getCollection(string2, null);
            if (collection != null) {
                for (String string5 : collection) {
                    ((DefaultListModel)this.iconsList.getModel()).addElement(string5);
                }
            }
            object3 = new JButton(I18n.tr("Add"));
            ((AbstractButton)object3).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(Main.parent, I18n.tr("Icon paths"), I18n.tr("Icon paths"), 3);
                    if (string != null) {
                        ((DefaultListModel)StyleSources.this.iconsList.getModel()).addElement(string);
                    }
                }
            });
            JButton jButton2 = new JButton(I18n.tr("Edit"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (StyleSources.this.sourcesList.getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit."), I18n.tr("Warning"), 2);
                    } else {
                        String string = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("Icon paths"), I18n.tr("Icon paths"), 3, null, null, StyleSources.this.iconsList.getSelectedValue());
                        if (string != null) {
                            ((DefaultListModel)StyleSources.this.iconsList.getModel()).setElementAt(string, StyleSources.this.iconsList.getSelectedIndex());
                        }
                    }
                }
            });
            jButton = new JButton(I18n.tr("Delete"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (StyleSources.this.iconsList.getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete."), I18n.tr("Warning"), 2);
                    } else {
                        ((DefaultListModel)StyleSources.this.iconsList.getModel()).remove(StyleSources.this.iconsList.getSelectedIndex());
                    }
                }
            });
        }
        JButton jButton3 = new JButton(I18n.tr("Add"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main.parent, string4, string4, 3);
                if (string != null) {
                    ((DefaultListModel)StyleSources.this.sourcesList.getModel()).addElement(string);
                }
            }
        });
        JButton jButton4 = new JButton(I18n.tr("Edit"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StyleSources.this.sourcesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit."), I18n.tr("Warning"), 2);
                } else {
                    String string = (String)JOptionPane.showInputDialog(Main.parent, string4, string4, 3, null, null, StyleSources.this.sourcesList.getSelectedValue());
                    if (string != null) {
                        ((DefaultListModel)StyleSources.this.sourcesList.getModel()).setElementAt(string, StyleSources.this.sourcesList.getSelectedIndex());
                    }
                }
            }
        });
        JButton jButton5 = new JButton(I18n.tr("Delete"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StyleSources.this.sourcesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete."), I18n.tr("Warning"), 2);
                } else {
                    ((DefaultListModel)StyleSources.this.sourcesList.getModel()).remove(StyleSources.this.sourcesList.getSelectedIndex());
                }
            }
        });
        JButton jButton6 = new JButton(I18n.tr("Copy defaults"));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StyleSources.this.sourcesDefaults.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to copy."), I18n.tr("Warning"), 2);
                } else {
                    ((DefaultListModel)StyleSources.this.sourcesList.getModel()).addElement(((SourceInfo)((StyleSources)StyleSources.this).sourcesDefaults.getSelectedValue()).url);
                }
            }
        });
        JButton jButton7 = new JButton(I18n.tr("Update"));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MirroredInputStream.cleanup(string3);
                StyleSources.this.getDefaults(string3);
                int n = StyleSources.this.sourcesList.getModel().getSize();
                if (n > 0) {
                    ArrayList arrayList = new ArrayList();
                    for (int i = 0; i < n; ++i) {
                        MirroredInputStream.cleanup((String)StyleSources.this.sourcesList.getModel().getElementAt(i));
                    }
                }
            }
        });
        this.sourcesList.setToolTipText(I18n.tr("The XML source (URL or filename) for {0} definition files.", string4));
        jButton3.setToolTipText(I18n.tr("Add a new XML source to the list."));
        jButton5.setToolTipText(I18n.tr("Delete the selected source from the list."));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(string4), GBC.eol().insets(5, 5, 5, 0));
        this.add((Component)new JScrollPane(this.sourcesList), GBC.eol().insets(5, 0, 5, 0).fill(1));
        this.add((Component)new JLabel(I18n.tr("Defaults (See tooltip for detailed information)")), GBC.eol().insets(5, 5, 5, 0));
        this.add((Component)new JScrollPane(this.sourcesDefaults), GBC.eol().insets(5, 0, 5, 0).fill(1));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
        jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
        jPanel.add((Component)jButton4, GBC.std().insets(5, 5, 5, 0));
        jPanel.add((Component)jButton5, GBC.std().insets(0, 5, 5, 0));
        jPanel.add((Component)jButton6, GBC.std().insets(0, 5, 5, 0));
        jPanel.add((Component)jButton7, GBC.std().insets(0, 5, 0, 0));
        if (this.iconsList != null) {
            void var8_11;
            this.add((Component)new JLabel(I18n.tr("Icon paths")), GBC.eol().insets(5, -5, 5, 0));
            this.add((Component)new JScrollPane(this.iconsList), GBC.eol().insets(5, 0, 5, 0).fill(1));
            jPanel = new JPanel(new GridBagLayout());
            this.add((Component)jPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
            jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            jPanel.add((Component)object3, GBC.std().insets(0, 5, 0, 0));
            jPanel.add((Component)var8_11, GBC.std().insets(5, 5, 5, 0));
            jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        }
    }

    public boolean finish() {
        int n;
        ArrayList<String> arrayList;
        boolean bl = false;
        int n2 = this.sourcesList.getModel().getSize();
        if (n2 > 0) {
            arrayList = new ArrayList<String>();
            for (n = 0; n < n2; ++n) {
                arrayList.add((String)this.sourcesList.getModel().getElementAt(n));
            }
            if (Main.pref.putCollection(this.pref, arrayList)) {
                bl = true;
            }
        } else if (Main.pref.putCollection(this.pref, null)) {
            bl = true;
        }
        if (this.iconsList != null) {
            n2 = this.iconsList.getModel().getSize();
            if (n2 > 0) {
                arrayList = new ArrayList();
                for (n = 0; n < n2; ++n) {
                    arrayList.add((String)this.iconsList.getModel().getElementAt(n));
                }
                if (Main.pref.putCollection(this.iconpref, arrayList)) {
                    bl = true;
                }
            } else if (Main.pref.putCollection(this.iconpref, null)) {
                bl = true;
            }
        }
        return bl;
    }

    public void getDefaults(String string) {
        ((DefaultListModel)this.sourcesDefaults.getModel()).removeAllElements();
        String string2 = LanguageInfo.getLanguageCodeXML();
        try {
            String string3;
            InputStreamReader inputStreamReader;
            MirroredInputStream mirroredInputStream = new MirroredInputStream(string);
            try {
                inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(mirroredInputStream);
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            SourceInfo sourceInfo = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                Matcher matcher;
                if (string3.startsWith("\t")) {
                    matcher = Pattern.compile("^\t([^:]+): *(.+)$").matcher(string3);
                    matcher.matches();
                    try {
                        if (sourceInfo == null) continue;
                        String string4 = matcher.group(1);
                        String string5 = matcher.group(2);
                        if ("author".equals(string4) && sourceInfo.author == null) {
                            sourceInfo.author = string5;
                            continue;
                        }
                        if ("version".equals(string4)) {
                            sourceInfo.version = string5;
                            continue;
                        }
                        if ("link".equals(string4) && sourceInfo.link == null) {
                            sourceInfo.link = string5;
                            continue;
                        }
                        if ("description".equals(string4) && sourceInfo.description == null) {
                            sourceInfo.description = string5;
                            continue;
                        }
                        if ("shortdescription".equals(string4) && sourceInfo.shortdescription == null) {
                            sourceInfo.shortdescription = string5;
                            continue;
                        }
                        if ((string2 + "author").equals(string4)) {
                            sourceInfo.author = string5;
                            continue;
                        }
                        if ((string2 + "link").equals(string4)) {
                            sourceInfo.link = string5;
                            continue;
                        }
                        if ((string2 + "description").equals(string4)) {
                            sourceInfo.description = string5;
                            continue;
                        }
                        if (!(string2 + "shortdescription").equals(string4)) continue;
                        sourceInfo.shortdescription = string5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                    continue;
                }
                sourceInfo = null;
                matcher = Pattern.compile("^(.+);(.+)$").matcher(string3);
                matcher.matches();
                try {
                    sourceInfo = new SourceInfo(matcher.group(1), matcher.group(2));
                    ((DefaultListModel)this.sourcesDefaults.getModel()).addElement(sourceInfo);
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            this.setToolTipText(((SourceInfo)object).getTooltip());
            return this;
        }
    }

    public class SourceInfo {
        String version;
        String name;
        String url;
        String author;
        String link;
        String description;
        String shortdescription;

        public SourceInfo(String string, String string2) {
            this.name = string;
            this.url = string2;
            this.shortdescription = null;
            this.description = null;
            this.link = null;
            this.author = null;
            this.version = null;
        }

        public String getName() {
            return this.shortdescription == null ? this.name : this.shortdescription;
        }

        public String getTooltip() {
            String string = I18n.tr("Short Description: {0}", this.getName()) + "<br>" + I18n.tr("URL: {0}", this.url);
            if (this.author != null) {
                string = string + "<br>" + I18n.tr("Author: {0}", this.author);
            }
            if (this.link != null) {
                string = string + "<br>" + I18n.tr("Webpage: {0}", this.link);
            }
            if (this.description != null) {
                string = string + "<br>" + I18n.tr("Description: {0}", this.description);
            }
            if (this.version != null) {
                string = string + "<br>" + I18n.tr("Version: {0}", this.version);
            }
            return "<html>" + string + "</html>";
        }

        public String toString() {
            return this.getName() + " (" + this.url + ")";
        }
    }
}

