/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PluginPreference
implements PreferenceSetting {
    private JPanel plugin;
    private JPanel pluginPanel = new NoHorizontalScrollPanel(new GridBagLayout());
    private PreferenceDialog gui;
    private JScrollPane pluginPane;
    private PluginSelection selection = new PluginSelection();
    private JTextField txtFilter;

    public void addGui(PreferenceDialog preferenceDialog) {
        this.gui = preferenceDialog;
        this.plugin = preferenceDialog.createPreferenceTab("plugin", I18n.tr("Plugins"), I18n.tr("Configure available plugins."), false);
        this.txtFilter = new JTextField();
        JLabel jLabel = new JLabel(I18n.tr("Search: "));
        jLabel.setLabelFor(this.txtFilter);
        this.plugin.add(jLabel);
        this.plugin.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            private void action() {
                PluginPreference.this.selection.drawPanel(PluginPreference.this.pluginPanel);
            }
        });
        this.plugin.add(GBC.glue(0, 10), GBC.eol());
        this.pluginPane = new JScrollPane(this.pluginPanel, 20, 30);
        this.pluginPane.setBorder(null);
        this.plugin.add((Component)this.pluginPane, GBC.eol().fill(1));
        this.plugin.add(GBC.glue(0, 10), GBC.eol());
        JButton jButton = new JButton(I18n.tr("Download List"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreference.this.selection.updateDescription(PluginPreference.this.pluginPanel);
            }
        });
        this.plugin.add((Component)jButton, GBC.std().insets(0, 0, 10, 0));
        JButton jButton2 = new JButton(I18n.tr("Update"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreference.this.selection.update(PluginPreference.this.pluginPanel);
            }
        });
        this.plugin.add((Component)jButton2, GBC.std().insets(0, 0, 10, 0));
        JButton jButton3 = new JButton(I18n.tr("Configure Sites..."));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreference.this.configureSites();
            }
        });
        this.plugin.add((Component)jButton3, GBC.std());
        this.selection.passTxtFilter(this.txtFilter);
        this.selection.loadPlugins();
        this.selection.drawPanel(this.pluginPanel);
    }

    private void configureSites() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Add JOSM Plugin description URL.")), GBC.eol());
        final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String object2 : PluginDownloader.getSites()) {
            defaultListModel.addElement(object2);
        }
        final JList jList = new JList(defaultListModel);
        jPanel.add((Component)new JScrollPane(jList), GBC.std().fill());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JButton(new AbstractAction(I18n.tr("Add")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(PluginPreference.this.gui, I18n.tr("Add JOSM Plugin description URL."), I18n.tr("Enter URL"), 3);
                if (string != null) {
                    defaultListModel.addElement(string);
                }
            }
        }), GBC.eol().fill(2));
        jPanel2.add((Component)new JButton(new AbstractAction(I18n.tr("Edit")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jList.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(PluginPreference.this.gui, I18n.tr("Please select an entry."), I18n.tr("Warning"), 2);
                    return;
                }
                String string = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("Edit JOSM Plugin description URL."), I18n.tr("JOSM Plugin description URL"), 3, null, null, jList.getSelectedValue());
                defaultListModel.setElementAt(string, jList.getSelectedIndex());
            }
        }), GBC.eol().fill(2));
        jPanel2.add((Component)new JButton(new AbstractAction(I18n.tr("Delete")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jList.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(PluginPreference.this.gui, I18n.tr("Please select an entry."), I18n.tr("Warning"), 2);
                    return;
                }
                defaultListModel.removeElement(jList.getSelectedValue());
            }
        }), GBC.eol().fill(2));
        jPanel.add((Component)jPanel2, GBC.eol());
        int n = JOptionPane.showConfirmDialog(this.gui, jPanel, I18n.tr("Configure Plugin Sites"), 2, -1);
        if (n != 0) {
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            linkedList.add((String)defaultListModel.getElementAt(i));
        }
        PluginDownloader.setSites(linkedList);
    }

    public boolean ok() {
        return this.selection.finish();
    }

    private static class NoHorizontalScrollPanel
    extends JPanel
    implements Scrollable {
        public NoHorizontalScrollPanel(GridBagLayout gridBagLayout) {
            super(gridBagLayout);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 30;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new PluginPreference();
        }
    }
}

