/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.Rule;
import org.openstreetmap.josm.tools.ColorHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ElemStyleHandler
extends DefaultHandler {
    boolean inDoc;
    boolean inRule;
    boolean inCondition;
    boolean inElemStyle;
    boolean inLine;
    boolean inLineMod;
    boolean inIcon;
    boolean inArea;
    boolean inScaleMax;
    boolean inScaleMin;
    boolean hadLine;
    boolean hadLineMod;
    boolean hadIcon;
    boolean hadArea;
    ElemStyles styles;
    String styleName;
    RuleElem rule = new RuleElem();

    public ElemStyleHandler(String string) {
        this.styleName = string;
        this.inArea = false;
        this.inIcon = false;
        this.inLine = false;
        this.inElemStyle = false;
        this.inCondition = false;
        this.inRule = false;
        this.inDoc = false;
        this.rule.init();
        this.styles = MapPaintStyles.getStyles();
    }

    Color convertColor(String string) {
        int n = string.indexOf("#");
        Color color = n < 0 ? Main.pref.getColor("mappaint." + this.styleName + "." + string, Color.red) : (n == 0 ? ColorHelper.html2color(string) : Main.pref.getColor("mappaint." + this.styleName + "." + string.substring(0, n), ColorHelper.html2color(string.substring(n))));
        return color;
    }

    public void startDocument() {
        this.inDoc = true;
    }

    public void endDocument() {
        this.inDoc = false;
    }

    private void error(String string) {
        System.out.println(this.styleName + " (" + this.rule.rule.key + "=" + this.rule.rule.value + "): " + string);
    }

    private void startElementLine(String string, Attributes attributes, LineElemStyle lineElemStyle) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String[] stringArray;
            if (attributes.getQName(i).equals("width")) {
                stringArray = attributes.getValue(i);
                if (stringArray.startsWith("+")) {
                    lineElemStyle.width = Integer.parseInt(stringArray.substring(1));
                    lineElemStyle.widthMode = LineElemStyle.WidthMode.OFFSET;
                    continue;
                }
                if (stringArray.startsWith("-")) {
                    lineElemStyle.width = Integer.parseInt((String)stringArray);
                    lineElemStyle.widthMode = LineElemStyle.WidthMode.OFFSET;
                    continue;
                }
                if (stringArray.endsWith("%")) {
                    lineElemStyle.width = Integer.parseInt(stringArray.substring(0, stringArray.length() - 1));
                    lineElemStyle.widthMode = LineElemStyle.WidthMode.PERCENT;
                    continue;
                }
                lineElemStyle.width = Integer.parseInt((String)stringArray);
                continue;
            }
            if (attributes.getQName(i).equals("colour")) {
                lineElemStyle.color = this.convertColor(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("realwidth")) {
                lineElemStyle.realWidth = Integer.parseInt(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("dashed")) {
                int n;
                try {
                    stringArray = attributes.getValue(i).split(",");
                    lineElemStyle.dashed = new float[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        lineElemStyle.dashed[n] = Integer.parseInt(stringArray[n]);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    n = Boolean.parseBoolean(attributes.getValue(i));
                    if (n == 0) continue;
                    lineElemStyle.dashed = new float[]{9.0f};
                    continue;
                }
            }
            if (attributes.getQName(i).equals("dashedcolour")) {
                lineElemStyle.dashedColor = this.convertColor(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("priority")) {
                lineElemStyle.priority = Integer.parseInt(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("mode")) {
                lineElemStyle.over = !attributes.getValue(i).equals("under");
                continue;
            }
            this.error("The element \"" + string + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.inDoc) {
            if (string3.equals("rule")) {
                this.inRule = true;
            } else if (string3.equals("rules")) {
                if (this.styleName == null) {
                    String string4 = attributes.getValue("name");
                    if (string4 == null) {
                        string4 = "standard";
                    }
                    this.styleName = string4;
                }
            } else if (string3.equals("scale_max")) {
                this.inScaleMax = true;
            } else if (string3.equals("scale_min")) {
                this.inScaleMin = true;
            } else if (string3.equals("condition") && this.inRule) {
                this.inCondition = true;
                Rule rule = this.rule.rule;
                if (rule.key != null) {
                    if (this.rule.rules == null) {
                        this.rule.rules = new LinkedList<Rule>();
                    }
                    this.rule.rules.add(new Rule(this.rule.rule));
                    rule = new Rule();
                    this.rule.rules.add(rule);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("k")) {
                        rule.key = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).equals("v")) {
                        rule.value = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).equals("b")) {
                        rule.boolValue = attributes.getValue(i);
                        continue;
                    }
                    this.error("The element \"" + string3 + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
                }
                if (rule.key == null) {
                    this.error("The condition has no key!");
                }
            } else if (string3.equals("line")) {
                this.inLine = true;
                this.hadLine = true;
                this.startElementLine(string3, attributes, this.rule.line);
                if (this.rule.line.widthMode != LineElemStyle.WidthMode.ABSOLUTE) {
                    this.error("Relative widths are not possible for normal lines");
                    this.rule.line.widthMode = LineElemStyle.WidthMode.ABSOLUTE;
                }
            } else if (string3.equals("linemod")) {
                this.inLineMod = true;
                this.hadLineMod = true;
                this.startElementLine(string3, attributes, this.rule.linemod);
            } else if (string3.equals("icon")) {
                this.inIcon = true;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("src")) {
                        ImageIcon imageIcon = MapPaintStyles.getIcon(attributes.getValue(i), this.styleName);
                        this.hadIcon = imageIcon != null;
                        this.rule.icon.icon = imageIcon;
                        continue;
                    }
                    if (attributes.getQName(i).equals("annotate")) {
                        this.rule.icon.annotate = Boolean.parseBoolean(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("priority")) {
                        this.rule.icon.priority = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    this.error("The element \"" + string3 + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
                }
            } else if (string3.equals("area")) {
                this.inArea = true;
                this.hadArea = true;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("colour")) {
                        this.rule.area.color = this.convertColor(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("closed")) {
                        this.rule.area.closed = Boolean.parseBoolean(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("priority")) {
                        this.rule.area.priority = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    this.error("The element \"" + string3 + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
                }
            } else {
                this.error("The element \"" + string3 + "\" is unknown!");
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.inRule && string3.equals("rule")) {
            if (this.hadLine) {
                this.styles.add(this.styleName, this.rule.rule, this.rule.rules, new LineElemStyle(this.rule.line, this.rule.scaleMax, this.rule.scaleMin));
            }
            if (this.hadLineMod) {
                this.styles.addModifier(this.styleName, this.rule.rule, this.rule.rules, new LineElemStyle(this.rule.linemod, this.rule.scaleMax, this.rule.scaleMin));
            }
            if (this.hadIcon) {
                this.styles.add(this.styleName, this.rule.rule, this.rule.rules, new IconElemStyle(this.rule.icon, this.rule.scaleMax, this.rule.scaleMin));
            }
            if (this.hadArea) {
                this.styles.add(this.styleName, this.rule.rule, this.rule.rules, new AreaElemStyle(this.rule.area, this.rule.scaleMax, this.rule.scaleMin));
            }
            this.inRule = false;
            this.hadArea = false;
            this.hadIcon = false;
            this.hadLineMod = false;
            this.hadLine = false;
            this.rule.init();
        } else if (this.inCondition && string3.equals("condition")) {
            this.inCondition = false;
        } else if (this.inLine && string3.equals("line")) {
            this.inLine = false;
        } else if (this.inLineMod && string3.equals("linemod")) {
            this.inLineMod = false;
        } else if (this.inIcon && string3.equals("icon")) {
            this.inIcon = false;
        } else if (this.inArea && string3.equals("area")) {
            this.inArea = false;
        } else if (string3.equals("scale_max")) {
            this.inScaleMax = false;
        } else if (string3.equals("scale_min")) {
            this.inScaleMin = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.inScaleMax) {
            this.rule.scaleMax = Long.parseLong(new String(cArray, n, n2));
        } else if (this.inScaleMin) {
            this.rule.scaleMin = Long.parseLong(new String(cArray, n, n2));
        }
    }

    class RuleElem {
        Rule rule = new Rule();
        Collection<Rule> rules;
        long scaleMax;
        long scaleMin;
        LineElemStyle line = new LineElemStyle();
        LineElemStyle linemod = new LineElemStyle();
        AreaElemStyle area = new AreaElemStyle();
        IconElemStyle icon = new IconElemStyle();

        RuleElem() {
        }

        public void init() {
            this.rules = null;
            this.scaleMax = 1000000000L;
            this.scaleMin = 0L;
            this.line.init();
            this.rule.init();
            this.linemod.init();
            this.area.init();
            this.icon.init();
        }
    }
}

