/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadSelectionDialog
extends JDialog {
    private OsmPrimitiveList lstSelectedPrimitives;
    private OsmPrimitiveList lstDeletedPrimitives;
    private JSplitPane spLists;
    private boolean canceled;
    private SideButton btnContinue;

    protected JPanel buildSelectedPrimitivesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18n.tr("<html>Mark modified objects <strong>from the current selection</strong> to be uploaded to the server.</html>"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        this.lstSelectedPrimitives = new OsmPrimitiveList();
        jPanel.add((Component)new JScrollPane(this.lstSelectedPrimitives), "Center");
        return jPanel;
    }

    protected JPanel buildDeletedPrimitivesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18n.tr("<html>Mark <strong>locally deleted objects</strong> to be deleted on the server.</html>"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        this.lstDeletedPrimitives = new OsmPrimitiveList();
        jPanel.add((Component)new JScrollPane(this.lstDeletedPrimitives), "Center");
        return jPanel;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new SideButton(new CancelAction()));
        ContinueAction continueAction = new ContinueAction();
        this.btnContinue = new SideButton(continueAction);
        jPanel.add(this.btnContinue);
        this.btnContinue.setFocusable(true);
        this.lstDeletedPrimitives.getSelectionModel().addListSelectionListener(continueAction);
        this.lstSelectedPrimitives.getSelectionModel().addListSelectionListener(continueAction);
        return jPanel;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.spLists = new JSplitPane(0);
        this.spLists.setTopComponent(this.buildSelectedPrimitivesPanel());
        this.spLists.setBottomComponent(this.buildDeletedPrimitivesPanel());
        this.add((Component)this.spLists, "Center");
        this.add((Component)this.buildButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                UploadSelectionDialog.this.spLists.setDividerLocation(0.5);
                UploadSelectionDialog.this.btnContinue.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent windowEvent) {
                UploadSelectionDialog.this.setCanceled(true);
            }
        });
        this.setTitle(I18n.tr("Select objects to upload"));
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(112, 0), "help");
        actionMap.put("help", Main.main.menu.help);
        this.getRootPane().putClientProperty("help", "Dialog/UploadSelection");
    }

    public UploadSelectionDialog() {
        super(JOptionPane.getFrameForComponent(Main.parent), true);
        this.build();
    }

    public void populate(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2) {
        if (collection != null) {
            this.lstSelectedPrimitives.getOsmPrimitiveListModel().setPrimitives(new ArrayList<OsmPrimitive>(collection));
            if (!collection.isEmpty()) {
                this.lstSelectedPrimitives.getSelectionModel().setSelectionInterval(0, collection.size() - 1);
            } else {
                this.lstSelectedPrimitives.getSelectionModel().clearSelection();
            }
        } else {
            this.lstSelectedPrimitives.getOsmPrimitiveListModel().setPrimitives(null);
            this.lstSelectedPrimitives.getSelectionModel().clearSelection();
        }
        if (collection2 != null) {
            this.lstDeletedPrimitives.getOsmPrimitiveListModel().setPrimitives(new ArrayList<OsmPrimitive>(collection2));
        } else {
            this.lstDeletedPrimitives.getOsmPrimitiveListModel().setPrimitives(null);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public List<OsmPrimitive> getSelectedPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        System.out.println("selected length:" + this.lstSelectedPrimitives.getSelectedIndices().length);
        for (int i = 0; i < this.lstSelectedPrimitives.getSelectedIndices().length; ++i) {
            System.out.println("selected:" + this.lstSelectedPrimitives.getSelectedIndices()[i]);
        }
        arrayList.addAll(this.lstSelectedPrimitives.getOsmPrimitiveListModel().getPrimitives(this.lstSelectedPrimitives.getSelectedIndices()));
        arrayList.addAll(this.lstDeletedPrimitives.getOsmPrimitiveListModel().getPrimitives(this.lstDeletedPrimitives.getSelectedIndices()));
        return arrayList;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(200, 400))).apply(this);
        } else if (!bl && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    class ContinueAction
    extends AbstractAction
    implements ListSelectionListener {
        public ContinueAction() {
            this.putValue("ShortDescription", I18n.tr("Continue uploading"));
            this.putValue("Name", I18n.tr("Continue"));
            this.putValue("SmallIcon", ImageProvider.get("", "upload"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadSelectionDialog.this.setCanceled(false);
            UploadSelectionDialog.this.setVisible(false);
        }

        protected void updateEnabledState() {
            this.setEnabled(UploadSelectionDialog.this.lstSelectedPrimitives.getSelectedIndex() >= 0 || UploadSelectionDialog.this.lstDeletedPrimitives.getSelectedIndex() >= 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel uploading"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadSelectionDialog.this.setCanceled(true);
            UploadSelectionDialog.this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OsmPrimitiveListModel
    extends AbstractListModel {
        private List<OsmPrimitive> data;

        public OsmPrimitiveListModel() {
        }

        protected void sort() {
            if (this.data == null) {
                return;
            }
            Collections.sort(this.data, new Comparator<OsmPrimitive>(){
                private DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();

                @Override
                public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                    int n = OsmPrimitiveType.from(osmPrimitive).compareTo(OsmPrimitiveType.from(osmPrimitive2));
                    if (n != 0) {
                        return n;
                    }
                    return osmPrimitive.getDisplayName(this.formatter).compareTo(osmPrimitive.getDisplayName(this.formatter));
                }
            });
        }

        public OsmPrimitiveListModel(List<OsmPrimitive> list) {
            this.setPrimitives(list);
        }

        public void setPrimitives(List<OsmPrimitive> list) {
            this.data = list;
            this.sort();
            if (list != null) {
                this.fireContentsChanged(this, 0, list.size());
            } else {
                this.fireContentsChanged(this, 0, 0);
            }
        }

        @Override
        public Object getElementAt(int n) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(n);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public List<OsmPrimitive> getPrimitives(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(nArray.length);
            for (int n : nArray) {
                if (n < 0) continue;
                arrayList.add(this.data.get(n));
            }
            return arrayList;
        }
    }

    static class OsmPrimitiveList
    extends JList {
        protected void init() {
            this.setSelectionMode(2);
            this.setCellRenderer(new OsmPrimitivRenderer());
        }

        public OsmPrimitiveList() {
            super(new OsmPrimitiveListModel());
            this.init();
        }

        public OsmPrimitiveList(OsmPrimitiveListModel osmPrimitiveListModel) {
            super(osmPrimitiveListModel);
            this.init();
        }

        public OsmPrimitiveListModel getOsmPrimitiveListModel() {
            return (OsmPrimitiveListModel)this.getModel();
        }
    }
}

