/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.io.ChangesetCellRenderer;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.io.DownloadOpenChangesetsTask;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadDialog
extends JDialog {
    public static final String HISTORY_KEY = "upload.comment.history";
    private static UploadDialog uploadDialog;
    private PrimitiveList lstAdd;
    private JLabel lblAdd;
    private JScrollPane spAdd;
    private PrimitiveList lstUpdate;
    private JLabel lblUpdate;
    private JScrollPane spUpdate;
    private PrimitiveList lstDelete;
    private JLabel lblDelete;
    private JScrollPane spDelete;
    private JPanel pnlLists;
    private TagEditorPanel tagEditorPanel;
    private JTabbedPane southTabbedPane;
    private JButton btnUpload;
    private ChangesetSelectionPanel pnlChangesetSelection;
    private boolean canceled = false;

    public static UploadDialog getUploadDialog() {
        if (uploadDialog == null) {
            uploadDialog = new UploadDialog();
        }
        return uploadDialog;
    }

    protected JPanel buildListsPanel() {
        this.pnlLists = new JPanel();
        this.pnlLists.setLayout(new GridBagLayout());
        return this.pnlLists;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buildListsPanel(), gridBagConstraints);
        this.southTabbedPane = new JTabbedPane();
        this.southTabbedPane.add(new JPanel());
        this.tagEditorPanel = new TagEditorPanel();
        this.southTabbedPane.add(this.tagEditorPanel);
        this.pnlChangesetSelection = new ChangesetSelectionPanel();
        this.southTabbedPane.setComponentAt(0, this.pnlChangesetSelection);
        this.southTabbedPane.setTitleAt(0, I18n.tr("Settings"));
        this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
        this.southTabbedPane.addChangeListener(new TabbedPaneChangeLister());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.southTabbedPane, "Center");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildActionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        UploadAction uploadAction = new UploadAction();
        this.btnUpload = new SideButton(uploadAction);
        jPanel.add(this.btnUpload);
        this.btnUpload.setFocusable(true);
        InputMap inputMap = this.btnUpload.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "doUpload");
        this.btnUpload.getActionMap().put("doUpload", uploadAction);
        CancelAction cancelAction = new CancelAction();
        jPanel.add(new SideButton(cancelAction));
        this.getRootPane().registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        return jPanel;
    }

    protected void build() {
        this.setTitle(I18n.tr("Upload"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildContentPanel(), "Center");
        this.getContentPane().add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
    }

    public UploadDialog() {
        super(JOptionPane.getFrameForComponent(Main.parent), true);
        OsmPrimitivRenderer osmPrimitivRenderer = new OsmPrimitivRenderer();
        this.lstAdd = new PrimitiveList();
        this.lstAdd.setCellRenderer(osmPrimitivRenderer);
        this.lstAdd.setVisibleRowCount(Math.min(this.lstAdd.getModel().getSize(), 10));
        this.spAdd = new JScrollPane(this.lstAdd);
        this.lblAdd = new JLabel(I18n.tr("Objects to add:"));
        this.lstUpdate = new PrimitiveList();
        this.lstUpdate.setCellRenderer(osmPrimitivRenderer);
        this.lstUpdate.setVisibleRowCount(Math.min(this.lstUpdate.getModel().getSize(), 10));
        this.spUpdate = new JScrollPane(this.lstUpdate);
        this.lblUpdate = new JLabel(I18n.tr("Objects to modify:"));
        this.lstDelete = new PrimitiveList();
        this.lstDelete.setCellRenderer(osmPrimitivRenderer);
        this.lstDelete.setVisibleRowCount(Math.min(this.lstDelete.getModel().getSize(), 10));
        this.spDelete = new JScrollPane(this.lstDelete);
        this.lblDelete = new JLabel(I18n.tr("Objects to delete:"));
        this.build();
    }

    public void setUploadedPrimitives(List<OsmPrimitive> list, List<OsmPrimitive> list2, List<OsmPrimitive> list3) {
        this.lstAdd.getPrimitiveListModel().setPrimitives(list);
        this.lstUpdate.getPrimitiveListModel().setPrimitives(list2);
        this.lstDelete.getPrimitiveListModel().setPrimitives(list3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 10;
        this.pnlLists.removeAll();
        int n = -1;
        if (!list.isEmpty()) {
            ++n;
            gridBagConstraints.gridy = n++;
            this.lblAdd.setText(I18n.trn("{0} object to add:", "{0} objects to add:", list.size(), list.size()));
            this.pnlLists.add((Component)this.lblAdd, gridBagConstraints);
            gridBagConstraints2.gridy = n;
            this.pnlLists.add((Component)this.spAdd, gridBagConstraints2);
        }
        if (!list2.isEmpty()) {
            ++n;
            gridBagConstraints.gridy = n++;
            this.lblUpdate.setText(I18n.trn("{0} object to modifiy:", "{0} objects to modify:", list2.size(), list2.size()));
            this.pnlLists.add((Component)this.lblUpdate, gridBagConstraints);
            gridBagConstraints2.gridy = n;
            this.pnlLists.add((Component)this.spUpdate, gridBagConstraints2);
        }
        if (!list3.isEmpty()) {
            ++n;
            gridBagConstraints.gridy = n++;
            this.lblDelete.setText(I18n.trn("{0} object to delete:", "{0} objects to delete:", list3.size(), list3.size()));
            this.pnlLists.add((Component)this.lblDelete, gridBagConstraints);
            gridBagConstraints2.gridy = n;
            this.pnlLists.add((Component)this.spDelete, gridBagConstraints2);
        }
    }

    public void rememberUserInput() {
        this.pnlChangesetSelection.rememberUserInput();
    }

    public void startUserInput() {
        this.tagEditorPanel.initAutoCompletion(Main.main.getEditLayer());
        this.pnlChangesetSelection.startUserInput();
    }

    public Changeset getChangeset() {
        Changeset changeset = this.pnlChangesetSelection.getChangeset();
        this.tagEditorPanel.getModel().applyToPrimitive(changeset);
        changeset.put("comment", this.getUploadComment());
        return changeset;
    }

    public void setOrUpdateChangeset(Changeset changeset) {
        this.pnlChangesetSelection.setOrUpdateChangeset(changeset);
    }

    public boolean isDoCloseAfterUpload() {
        return this.pnlChangesetSelection.isCloseAfterUpload();
    }

    protected String getDefaultCreatedBy() {
        Object object = System.getProperties().get("http.agent");
        return object == null ? "JOSM" : object.toString();
    }

    protected String getUploadComment() {
        switch (this.southTabbedPane.getSelectedIndex()) {
            case 0: {
                return this.pnlChangesetSelection.getUploadComment();
            }
            case 1: {
                TagModel tagModel = this.tagEditorPanel.getModel().get("comment");
                return tagModel == null ? "" : tagModel.getValue();
            }
        }
        return "";
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 600))).apply(this);
        } else if (!bl && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OpenChangesetModel
    extends DefaultComboBoxModel {
        private List<Changeset> changesets = new ArrayList<Changeset>();
        private long uid;
        private Changeset selectedChangeset = null;

        protected Changeset getChangesetById(long l) {
            for (Changeset changeset : this.changesets) {
                if (changeset.getId() != l) continue;
                return changeset;
            }
            return null;
        }

        protected void internalAddOrUpdate(Changeset changeset) {
            Changeset changeset2 = this.getChangesetById(changeset.getId());
            if (changeset2 != null) {
                changeset.cloneFrom(changeset2);
            } else {
                this.changesets.add(changeset);
            }
        }

        public void addOrUpdate(Changeset changeset) {
            if (changeset.getId() <= 0L) {
                throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
            }
            this.internalAddOrUpdate(changeset);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void remove(long l) {
            Changeset changeset = this.getChangesetById(l);
            if (changeset != null) {
                this.changesets.remove(changeset);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void addOrUpdate(Collection<Changeset> collection) {
            if (collection == null) {
                this.changesets.clear();
                this.setSelectedItem(null);
            }
            for (Changeset changeset : collection) {
                this.internalAddOrUpdate(changeset);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            if (this.getSelectedItem() == null && !this.changesets.isEmpty()) {
                this.setSelectedItem(this.changesets.get(0));
            } else if (this.getSelectedItem() != null) {
                if (collection.contains(this.getSelectedItem())) {
                    this.setSelectedItem(this.getSelectedItem());
                } else {
                    this.setSelectedItem(this.changesets.get(0));
                }
            } else {
                this.setSelectedItem(null);
            }
        }

        public void setUserId(long l) {
            this.uid = l;
        }

        public long getUserId() {
            return this.uid;
        }

        public void selectFirstChangeset() {
            if (this.changesets == null || this.changesets.isEmpty()) {
                return;
            }
            this.setSelectedItem(this.changesets.get(0));
        }

        public void removeChangeset(Changeset changeset) {
            if (changeset == null) {
                return;
            }
            this.changesets.remove(changeset);
            if (this.selectedChangeset == changeset) {
                this.selectFirstChangeset();
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int n) {
            return this.changesets.get(n);
        }

        @Override
        public int getIndexOf(Object object) {
            return this.changesets.indexOf(object);
        }

        @Override
        public int getSize() {
            return this.changesets.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedChangeset;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object == null) {
                this.selectedChangeset = null;
                super.setSelectedItem(null);
                return;
            }
            if (!(object instanceof Changeset)) {
                return;
            }
            Changeset changeset = (Changeset)object;
            if (changeset.getId() == 0L || !changeset.isOpen()) {
                return;
            }
            Changeset changeset2 = this.getChangesetById(changeset.getId());
            if (changeset2 == null) {
                return;
            }
            this.selectedChangeset = changeset2;
            super.setSelectedItem(this.selectedChangeset);
        }
    }

    class ChangesetSelectionPanel
    extends JPanel
    implements ListDataListener {
        private ButtonGroup bgUseNewOrExisting;
        private JRadioButton rbUseNew;
        private JRadioButton rbExisting;
        private JComboBox cbOpenChangesets;
        private JButton btnRefresh;
        private JButton btnClose;
        private JCheckBox cbCloseAfterUpload;
        private OpenChangesetModel model;
        private HistoryComboBox cmt;
        private JCheckBox cbUseAtomicUpload;

        protected JPanel buildAtomicUploadControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 23;
            this.cbUseAtomicUpload = new JCheckBox(I18n.tr("Upload all changes in one request"));
            jPanel.add((Component)this.cbUseAtomicUpload, gridBagConstraints);
            this.cbUseAtomicUpload.setToolTipText(I18n.tr("Enable to upload all changes in one request, disable to use one request per changed primitive"));
            boolean bl = Main.pref.getBoolean("osm-server.atomic-upload", true);
            this.cbUseAtomicUpload.setSelected(bl);
            this.cbUseAtomicUpload.setEnabled(OsmApi.getOsmApi().hasSupportForDiffUploads());
            return jPanel;
        }

        protected JPanel buildUploadCommentPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("Provide a brief comment for the changes you are uploading:")), GBC.eol().insets(0, 5, 10, 3));
            this.cmt = new HistoryComboBox();
            LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(UploadDialog.HISTORY_KEY, new LinkedList<String>()));
            Collections.reverse(linkedList);
            this.cmt.setPossibleItems(linkedList);
            this.cmt.getEditor().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TagModel tagModel = UploadDialog.this.tagEditorPanel.getModel().get("comment");
                    if (tagModel == null) {
                        UploadDialog.this.tagEditorPanel.getModel().add(new TagModel("comment", ChangesetSelectionPanel.this.cmt.getText()));
                    } else {
                        tagModel.setValue(ChangesetSelectionPanel.this.cmt.getText());
                    }
                    UploadDialog.this.tagEditorPanel.getModel().fireTableDataChanged();
                }
            });
            this.cmt.getEditor().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UploadDialog.this.btnUpload.requestFocusInWindow();
                }
            });
            jPanel.add((Component)this.cmt, GBC.eol().fill(2));
            return jPanel;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.bgUseNewOrExisting = new ButtonGroup();
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 23;
            this.add((Component)this.buildAtomicUploadControlPanel(), gridBagConstraints);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 23;
            this.add((Component)this.buildUploadCommentPanel(), gridBagConstraints);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 23;
            this.rbUseNew = new JRadioButton(I18n.tr("Open a new changeset"));
            this.rbUseNew.setToolTipText(I18n.tr("Open a new changeset and use it in the next upload"));
            this.bgUseNewOrExisting.add(this.rbUseNew);
            this.add((Component)this.rbUseNew, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            this.rbExisting = new JRadioButton(I18n.tr("Use an open changeset"));
            this.rbExisting.setToolTipText(I18n.tr("Upload data to an already opened changeset"));
            this.bgUseNewOrExisting.add(this.rbExisting);
            this.add((Component)this.rbExisting, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            this.model = new OpenChangesetModel();
            this.cbOpenChangesets = new JComboBox(this.model);
            this.cbOpenChangesets.setToolTipText("Select an open changeset");
            this.cbOpenChangesets.setRenderer(new ChangesetCellRenderer());
            this.cbOpenChangesets.addItemListener(new ChangesetListItemStateListener());
            Dimension dimension = this.cbOpenChangesets.getPreferredSize();
            dimension.width = 200;
            this.cbOpenChangesets.setPreferredSize(dimension);
            dimension.width = 100;
            this.cbOpenChangesets.setMinimumSize(dimension);
            this.model.addListDataListener(this);
            this.add((Component)this.cbOpenChangesets, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.btnRefresh = new JButton(new RefreshAction());
            this.add((Component)this.btnRefresh, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            CloseChangesetAction closeChangesetAction = new CloseChangesetAction();
            this.btnClose = new JButton(closeChangesetAction);
            this.cbOpenChangesets.addItemListener(closeChangesetAction);
            this.add((Component)this.btnClose, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 4;
            this.cbCloseAfterUpload = new JCheckBox(I18n.tr("Close changeset after upload"));
            this.cbCloseAfterUpload.setToolTipText(I18n.tr("Select to close the changeset after the next upload"));
            this.add((Component)this.cbCloseAfterUpload, gridBagConstraints);
            this.cbCloseAfterUpload.setSelected(true);
            this.rbUseNew.getModel().addItemListener(new RadioButtonHandler());
            this.rbExisting.getModel().addItemListener(new RadioButtonHandler());
            this.refreshGUI();
        }

        public ChangesetSelectionPanel() {
            this.build();
        }

        public void rememberUserInput() {
            this.cmt.addCurrentItemToHistory();
            Main.pref.putCollection(UploadDialog.HISTORY_KEY, this.cmt.getHistory());
            Main.pref.put("osm-server.atomic-upload", this.cbUseAtomicUpload.isSelected());
        }

        public void startUserInput() {
            List<String> list = this.cmt.getHistory();
            if (list != null && !list.isEmpty()) {
                this.cmt.setText(list.get(0));
            }
            this.cmt.requestFocusInWindow();
            this.cmt.getEditor().getEditorComponent().requestFocusInWindow();
        }

        public void prepareDialogForNextUpload(Changeset changeset) {
            if (changeset == null || changeset.getId() == 0L) {
                this.rbUseNew.setSelected(true);
                this.cbCloseAfterUpload.setSelected(true);
            }
            if (changeset.getId() == 0L) {
                this.rbUseNew.setSelected(true);
                this.cbCloseAfterUpload.setSelected(true);
            } else if (changeset.isOpen()) {
                this.rbExisting.setSelected(true);
                this.cbCloseAfterUpload.setSelected(false);
            } else {
                this.rbUseNew.setSelected(true);
                this.cbCloseAfterUpload.setSelected(true);
            }
        }

        public String getUploadComment() {
            return this.cmt.getText();
        }

        public void setUploadComment(String string) {
            this.cmt.setText(string);
        }

        public void initEditingOfUploadComment(String string) {
            this.setUploadComment(string);
            this.cmt.getEditor().selectAll();
            this.cmt.requestFocus();
        }

        protected void refreshGUI() {
            this.rbExisting.setEnabled(this.model.getSize() > 0);
            if (this.model.getSize() == 0 && !this.rbUseNew.isSelected()) {
                this.rbUseNew.setSelected(true);
            }
            this.cbOpenChangesets.setEnabled(this.model.getSize() > 0 && this.rbExisting.isSelected());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.refreshGUI();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.refreshGUI();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.refreshGUI();
        }

        public Changeset getChangeset() {
            if (this.rbUseNew.isSelected() || this.cbOpenChangesets.getSelectedItem() == null) {
                return new Changeset();
            }
            Changeset changeset = (Changeset)this.cbOpenChangesets.getSelectedItem();
            if (changeset == null) {
                return new Changeset();
            }
            return changeset;
        }

        public void setOrUpdateChangeset(Changeset changeset) {
            if (changeset == null) {
                UploadDialog.this.tagEditorPanel.getModel().clear();
                UploadDialog.this.tagEditorPanel.getModel().add("created_by", UploadDialog.this.getDefaultCreatedBy());
                UploadDialog.this.tagEditorPanel.getModel().appendNewTag();
            } else if (changeset.getId() == 0L) {
                if (changeset.get("created_by") == null) {
                    changeset.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                }
                UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                UploadDialog.this.tagEditorPanel.getModel().appendNewTag();
            } else if (changeset.getId() > 0L && changeset.isOpen()) {
                if (changeset.get("created_by") == null) {
                    changeset.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                }
                UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                this.model.addOrUpdate(changeset);
                changeset = this.model.getChangesetById(changeset.getId());
                this.cbOpenChangesets.setSelectedItem(changeset);
            } else if (changeset.getId() > 0L && !changeset.isOpen()) {
                if (changeset.get("created_by") == null) {
                    changeset.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                }
                UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                this.model.removeChangeset(changeset);
                if (this.model.getSize() == 0) {
                    this.rbUseNew.setSelected(true);
                    this.model.setSelectedItem(null);
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
                }
            }
            this.prepareDialogForNextUpload(changeset);
        }

        public void setUseNewChangeset() {
            this.rbUseNew.setSelected(true);
        }

        public void setUseExistingChangeset() {
            this.rbExisting.setSelected(true);
            if (this.cbOpenChangesets.getSelectedItem() == null && this.model.getSize() > 0) {
                this.cbOpenChangesets.setSelectedItem(this.model.getElementAt(0));
            }
        }

        public boolean isCloseAfterUpload() {
            return this.cbCloseAfterUpload.isSelected();
        }

        class CloseChangesetAction
        extends AbstractAction
        implements ItemListener {
            public CloseChangesetAction() {
                this.putValue("Name", I18n.tr("Close"));
                this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
                this.putValue("ShortDescription", I18n.tr("Close the currently selected open changeset"));
                this.refreshEnabledState();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Changeset changeset = (Changeset)ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem();
                if (changeset == null) {
                    return;
                }
                CloseChangesetTask closeChangesetTask = new CloseChangesetTask(Collections.singletonList(changeset));
                Main.worker.submit(closeChangesetTask);
            }

            protected void refreshEnabledState() {
                this.setEnabled(ChangesetSelectionPanel.this.cbOpenChangesets.getModel().getSize() > 0 && ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem() != null);
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                this.refreshEnabledState();
            }
        }

        class RefreshAction
        extends AbstractAction {
            public RefreshAction() {
                this.putValue("ShortDescription", I18n.tr("Load the list of your open changesets from the server"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadOpenChangesetsTask downloadOpenChangesetsTask = new DownloadOpenChangesetsTask(ChangesetSelectionPanel.this.model);
                Main.worker.submit(downloadOpenChangesetsTask);
            }
        }

        class ChangesetListItemStateListener
        implements ItemListener {
            ChangesetListItemStateListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                Changeset changeset = (Changeset)ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem();
                if (changeset == null) {
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
                    changeset = new Changeset();
                    UploadDialog.this.tagEditorPanel.getModel().applyToPrimitive(changeset);
                    if (changeset.get("created_by") == null) {
                        changeset.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                    }
                    changeset.put("comment", ChangesetSelectionPanel.this.cmt.getText());
                    UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                } else {
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of changeset {0}", changeset.getId()));
                    if (changeset.get("created_by") == null) {
                        changeset.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                    }
                    UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                }
            }
        }

        class RadioButtonHandler
        implements ItemListener {
            RadioButtonHandler() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (ChangesetSelectionPanel.this.rbUseNew.isSelected()) {
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
                    Changeset changeset = new Changeset();
                    UploadDialog.this.tagEditorPanel.getModel().applyToPrimitive(changeset);
                    if (changeset.get("created_by") == null) {
                        changeset.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                    }
                    changeset.put("comment", ChangesetSelectionPanel.this.cmt.getText());
                    UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                } else {
                    Changeset changeset;
                    if (ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem() == null) {
                        ChangesetSelectionPanel.this.model.selectFirstChangeset();
                    }
                    if ((changeset = (Changeset)ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem()) != null) {
                        changeset.put("comment", ChangesetSelectionPanel.this.cmt.getText());
                        UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of changeset {0}", changeset.getId()));
                        UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(changeset);
                    }
                }
                ChangesetSelectionPanel.this.refreshGUI();
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            UploadDialog.this.setCanceled(true);
        }

        public void windowActivated(WindowEvent windowEvent) {
            UploadDialog.this.startUserInput();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PrimitiveListModel
    extends AbstractListModel {
        private List<OsmPrimitive> primitives;

        public PrimitiveListModel() {
            this.primitives = new ArrayList<OsmPrimitive>();
        }

        public PrimitiveListModel(List<OsmPrimitive> list) {
            this.setPrimitives(list);
        }

        public void setPrimitives(List<OsmPrimitive> list) {
            this.primitives = list == null ? new ArrayList<OsmPrimitive>() : list;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int n) {
            if (this.primitives == null) {
                return null;
            }
            return this.primitives.get(n);
        }

        @Override
        public int getSize() {
            if (this.primitives == null) {
                return 0;
            }
            return this.primitives.size();
        }
    }

    class PrimitiveList
    extends JList {
        public PrimitiveList() {
            super(new PrimitiveListModel());
        }

        public PrimitiveListModel getPrimitiveListModel() {
            return (PrimitiveListModel)this.getModel();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel the upload and resume editing"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadDialog.this.setCanceled(true);
            UploadDialog.this.setVisible(false);
        }
    }

    class UploadAction
    extends AbstractAction {
        public UploadAction() {
            this.putValue("Name", I18n.tr("Upload Changes"));
            this.putValue("SmallIcon", ImageProvider.get("upload"));
            this.putValue("ShortDescription", I18n.tr("Upload the changed primitives"));
        }

        protected void warnIllegalUploadComment() {
            JOptionPane.showMessageDialog(UploadDialog.this, I18n.tr("Please enter a comment for this upload changeset (min. 3 characters)"), I18n.tr("Illegal upload comment"), 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (UploadDialog.this.getUploadComment().trim().length() < 3) {
                this.warnIllegalUploadComment();
                UploadDialog.this.southTabbedPane.setSelectedIndex(0);
                UploadDialog.this.pnlChangesetSelection.initEditingOfUploadComment(UploadDialog.this.getUploadComment());
                return;
            }
            UploadDialog.this.setCanceled(false);
            UploadDialog.this.setVisible(false);
        }
    }

    class TabbedPaneChangeLister
    implements ChangeListener {
        TabbedPaneChangeLister() {
        }

        protected boolean hasCommentTag() {
            TagEditorModel tagEditorModel = UploadDialog.this.tagEditorPanel.getModel();
            return tagEditorModel.get("comment") != null;
        }

        protected TagModel getEmptyTag() {
            TagEditorModel tagEditorModel = UploadDialog.this.tagEditorPanel.getModel();
            TagModel tagModel = tagEditorModel.get("");
            if (tagModel != null) {
                return tagModel;
            }
            tagModel = new TagModel("", "");
            tagEditorModel.add(tagModel);
            return tagModel;
        }

        protected TagModel getOrCreateCommentTag() {
            TagEditorModel tagEditorModel = UploadDialog.this.tagEditorPanel.getModel();
            if (this.hasCommentTag()) {
                return tagEditorModel.get("comment");
            }
            TagModel tagModel = this.getEmptyTag();
            tagModel.setName("comment");
            return tagModel;
        }

        protected void removeCommentTag() {
            TagEditorModel tagEditorModel = UploadDialog.this.tagEditorPanel.getModel();
            tagEditorModel.delete("comment");
        }

        protected void refreshCommentTag() {
            TagModel tagModel = this.getOrCreateCommentTag();
            tagModel.setName("comment");
            tagModel.setValue(UploadDialog.this.pnlChangesetSelection.getUploadComment().trim());
            if (UploadDialog.this.pnlChangesetSelection.getUploadComment().trim().equals("")) {
                this.removeCommentTag();
            }
            UploadDialog.this.tagEditorPanel.getModel().fireTableDataChanged();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (UploadDialog.this.southTabbedPane.getSelectedIndex() == 0) {
                TagModel tagModel = UploadDialog.this.tagEditorPanel.getModel().get("comment");
                UploadDialog.this.pnlChangesetSelection.initEditingOfUploadComment(tagModel == null ? "" : tagModel.getValue());
            } else if (UploadDialog.this.southTabbedPane.getSelectedIndex() == 1) {
                this.refreshCommentTag();
            }
        }
    }
}

