/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.File;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SaveLayerInfo
implements Comparable<SaveLayerInfo> {
    private OsmDataLayer layer;
    private boolean doSaveToFile;
    private boolean doUploadToServer;
    private File file;
    private UploadOrSaveState uploadState;
    private UploadOrSaveState saveState;

    public SaveLayerInfo(OsmDataLayer osmDataLayer) {
        if (osmDataLayer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        this.layer = osmDataLayer;
        this.doSaveToFile = osmDataLayer.requiresSaveToFile();
        this.doUploadToServer = osmDataLayer.requiresUploadToServer();
        this.file = osmDataLayer.getAssociatedFile();
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public boolean isDoSaveToFile() {
        return this.doSaveToFile;
    }

    public void setDoSaveToFile(boolean bl) {
        this.doSaveToFile = bl;
    }

    public boolean isDoUploadToServer() {
        return this.doUploadToServer;
    }

    public void setDoUploadToServer(boolean bl) {
        this.doUploadToServer = bl;
    }

    public boolean isDoSaveAndUpload() {
        return this.isDoSaveToFile() && this.isDoUploadToServer();
    }

    public String getName() {
        return this.layer.getName() == null ? "" : this.layer.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public int compareTo(SaveLayerInfo saveLayerInfo) {
        if (this.isDoSaveAndUpload()) {
            if (saveLayerInfo.isDoSaveAndUpload()) {
                return this.getName().compareTo(saveLayerInfo.getName());
            }
            return -1;
        }
        if (saveLayerInfo.isDoSaveAndUpload()) {
            return 1;
        }
        if (this.isDoUploadToServer()) {
            if (saveLayerInfo.isDoUploadToServer()) {
                return this.getName().compareTo(saveLayerInfo.getName());
            }
            return -1;
        }
        if (saveLayerInfo.isDoUploadToServer()) {
            return 1;
        }
        if (this.isDoSaveToFile()) {
            if (saveLayerInfo.isDoSaveToFile()) {
                return this.getName().compareTo(saveLayerInfo.getName());
            }
            return -1;
        }
        if (saveLayerInfo.isDoSaveToFile()) {
            return 1;
        }
        return this.getName().compareTo(saveLayerInfo.getName());
    }

    public UploadOrSaveState getUploadState() {
        return this.uploadState;
    }

    public void setUploadState(UploadOrSaveState uploadOrSaveState) {
        this.uploadState = uploadOrSaveState;
    }

    public UploadOrSaveState getSaveState() {
        return this.saveState;
    }

    public void setSaveState(UploadOrSaveState uploadOrSaveState) {
        this.saveState = uploadOrSaveState;
    }

    public void resetUploadAndSaveState() {
        this.uploadState = null;
        this.saveState = null;
    }
}

