/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.io.ChangesetCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseChangesetDialog
extends JDialog {
    private JList lstOpenChangesets;
    private boolean canceled;
    private DefaultListModel model;

    protected JPanel buildTopPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18n.tr("<html>Please select the changesets you want to close</html>")), "Center");
        return jPanel;
    }

    protected JPanel buildCenterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.model = new DefaultListModel();
        this.lstOpenChangesets = new JList(this.model);
        jPanel.add((Component)new JScrollPane(this.lstOpenChangesets), "Center");
        this.lstOpenChangesets.setCellRenderer(new ChangesetCellRenderer());
        return jPanel;
    }

    protected JPanel buildSouthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        CloseAction closeAction = new CloseAction();
        this.lstOpenChangesets.addListSelectionListener(closeAction);
        jPanel.add(new SideButton(closeAction));
        jPanel.add(new SideButton(new CancelAction()));
        return jPanel;
    }

    protected void build() {
        this.setTitle(I18n.tr("Open changesets"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildTopPanel(), "North");
        this.getContentPane().add((Component)this.buildCenterPanel(), "Center");
        this.getContentPane().add((Component)this.buildSouthPanel(), "South");
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(300, 300))).apply(this);
        } else {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public CloseChangesetDialog() {
        super(JOptionPane.getFrameForComponent(Main.parent), true);
        this.build();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void setChangesets(Collection<Changeset> collection) {
        if (collection == null) {
            collection = new ArrayList<Changeset>();
        }
        this.model.removeAllElements();
        for (Changeset changeset : collection) {
            this.model.addElement(changeset);
        }
    }

    public Collection<Changeset> getSelectedChangesets() {
        Object[] objectArray = this.lstOpenChangesets.getSelectedValues();
        ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
        for (Object object : objectArray) {
            arrayList.add((Changeset)object);
        }
        return arrayList;
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel closing of changesets"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CloseChangesetDialog.this.setCanceled(true);
            CloseChangesetDialog.this.setVisible(false);
        }
    }

    class CloseAction
    extends AbstractAction
    implements ListSelectionListener {
        public CloseAction() {
            this.putValue("Name", I18n.tr("Close changesets"));
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.putValue("ShortDescription", I18n.tr("Close the selected open changesets"));
            this.refreshEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CloseChangesetDialog.this.setCanceled(false);
            CloseChangesetDialog.this.setVisible(false);
        }

        protected void refreshEnabledState() {
            this.setEnabled(CloseChangesetDialog.this.lstOpenChangesets.getSelectedValues() != null && CloseChangesetDialog.this.lstOpenChangesets.getSelectedValues().length > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabledState();
        }
    }
}

