/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HelpBrowser
extends JFrame {
    private JEditorPane help;
    private String url;
    private String languageCode = LanguageInfo.getLanguageCodeWiki();
    private String baseurl = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
    private String pathbase = Main.pref.get("help.pathbase", "/wiki/");
    private WikiReader reader = new WikiReader(this.baseurl);

    protected void build() {
        this.help = new JEditorPane();
        this.help.setEditable(false);
        this.help.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (hyperlinkEvent.getURL() == null) {
                    HelpBrowser.this.help.setText("<html>404 not found</html>");
                } else if (hyperlinkEvent.getURL().toString().endsWith("action=edit")) {
                    OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                } else {
                    HelpBrowser.this.setUrl(hyperlinkEvent.getURL().toString());
                }
            }
        });
        this.help.setContentType("text/html");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.add((Component)new JScrollPane(this.help), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add(new SideButton(new OpenInBrowserAction()));
        jPanel2.add(new SideButton(new EditAction()));
        jPanel2.add(new SideButton(new ReloadAction()));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpBrowser.this.setVisible(false);
            }
        });
        this.help.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.help.getActionMap().put("Close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.setVisible(false);
            }
        });
        this.setTitle(I18n.tr("JOSM Help Browser"));
    }

    public HelpBrowser() {
        this.build();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(800, 600))).applySafe(this);
        } else if (!bl && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        int n;
        String string2 = string;
        if (string.startsWith(this.baseurl + this.pathbase)) {
            n = this.pathbase.length() + this.baseurl.length();
            String string3 = string.substring(n);
            if (this.languageCode.length() != 0 && !string3.startsWith(this.languageCode)) {
                string3 = this.languageCode + string3;
            }
            string2 = string.substring(0, n) + string3;
        }
        n = 0;
        if (!string2.equals(this.url) && !string2.equals(string)) {
            n = this.loadHelpUrl(string, string2, true) ? 1 : 0;
        }
        if (n == 0) {
            n = this.loadHelpUrl(string, string2, false) ? 1 : 0;
        }
        if (n == 0) {
            this.help.setText(I18n.tr("Error while loading page {0}", string));
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
    }

    public void setUrlForHelpTopic(String string) {
        this.setUrl(this.baseurl + this.pathbase + string);
    }

    protected boolean loadHelpUrl(String string, String string2, boolean bl) {
        this.url = bl ? string2 : string;
        boolean bl2 = false;
        try {
            String string3 = this.reader.read(this.url);
            if (string3.length() == 0) {
                if (bl) {
                    throw new IOException();
                }
                string3 = string.equals(string2) ? "<HTML>" + I18n.tr("Help page missing. Create it in <A HREF=\"{0}\">English</A>.", string + "?action=edit") + "</HTML>" : "<HTML>" + I18n.tr("Help page missing. Create it in <A HREF=\"{0}\">English</A> or <A HREF=\"{1}\">your language</A>.", string + "?action=edit", string2 + "?action=edit") + "</HTML>";
            }
            this.help.setText(string3);
            this.help.setCaretPosition(0);
            bl2 = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl2;
    }

    class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reload the current help page"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.this.setUrl(HelpBrowser.this.url);
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the current help page"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!HelpBrowser.this.getUrl().startsWith(HelpBrowser.this.baseurl)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Can only edit help pages from JOSM Online Help"), I18n.tr("Warning"), 2);
                return;
            }
            OpenBrowser.displayUrl(HelpBrowser.this.url + "?action=edit");
        }
    }

    class OpenInBrowserAction
    extends AbstractAction {
        public OpenInBrowserAction() {
            this.putValue("Name", I18n.tr("Open in Browser"));
            this.putValue("ShortDescription", I18n.tr("Open the current help page in an external browser"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpenBrowser.displayUrl(HelpBrowser.this.getUrl());
        }
    }
}

