/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTreeModel
implements TreeModel {
    private static final Logger logger = Logger.getLogger(RelationTreeModel.class.getName());
    private Relation root;
    private CopyOnWriteArrayList<TreeModelListener> listeners;

    public RelationTreeModel() {
        this.root = null;
        this.listeners = new CopyOnWriteArrayList();
    }

    public RelationTreeModel(Relation relation) {
        this.root = relation;
        this.listeners = new CopyOnWriteArrayList();
    }

    public RelationTreeModel(List<RelationMember> list) {
        if (list == null) {
            return;
        }
        Relation relation = new Relation();
        relation.setMembers(list);
        this.root = relation;
        this.listeners = new CopyOnWriteArrayList();
    }

    protected int getNumRelationChildren(Relation relation) {
        if (relation == null) {
            return 0;
        }
        int n = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isRelation()) continue;
            ++n;
        }
        return n;
    }

    protected Relation getRelationChildByIdx(Relation relation, int n) {
        if (relation == null) {
            return null;
        }
        int n2 = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isRelation()) continue;
            if (n2 == n) {
                return relationMember.getRelation();
            }
            ++n2;
        }
        return null;
    }

    protected int getIndexForRelationChild(Relation relation, Relation relation2) {
        if (relation == null || relation2 == null) {
            return -1;
        }
        int n = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isRelation()) continue;
            if (relationMember.getMember() == relation2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void populate(Relation relation) {
        if (relation == null) {
            relation = new Relation();
        }
        this.root = relation;
        this.fireRootReplacedEvent();
    }

    public void populate(List<RelationMember> list) {
        if (list == null) {
            return;
        }
        Relation relation = new Relation();
        relation.setMembers(list);
        this.root = relation;
        this.fireRootReplacedEvent();
    }

    protected void fireRootReplacedEvent() {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.root));
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireRefreshNode(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public void refreshNode(TreePath treePath) {
        this.fireRefreshNode(treePath);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getRelationChildByIdx((Relation)object, n);
    }

    @Override
    public int getChildCount(Object object) {
        return this.getNumRelationChildren((Relation)object);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getIndexForRelationChild((Relation)object, (Relation)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        Relation relation = (Relation)object;
        if (relation.incomplete) {
            return false;
        }
        return this.getNumRelationChildren(relation) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        CopyOnWriteArrayList<TreeModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (treeModelListener != null && !this.listeners.contains(treeModelListener)) {
                this.listeners.add(treeModelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        CopyOnWriteArrayList<TreeModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (treeModelListener != null && this.listeners.contains(treeModelListener)) {
                this.listeners.remove(treeModelListener);
            }
        }
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

