/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTree;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildRelationBrowser
extends JPanel {
    private static final Logger logger = Logger.getLogger(ChildRelationBrowser.class.getName());
    private RelationTree childTree;
    private RelationTreeModel model;
    private OsmDataLayer layer;

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.childTree = new RelationTree(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.childTree);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.buildButtonPanel(), "South");
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        DownloadAllChildRelationsAction downloadAllChildRelationsAction = new DownloadAllChildRelationsAction();
        jPanel.add(new JButton(downloadAllChildRelationsAction));
        DownloadSelectedAction downloadSelectedAction = new DownloadSelectedAction();
        this.childTree.addTreeSelectionListener(downloadSelectedAction);
        jPanel.add(new JButton(downloadSelectedAction));
        EditAction editAction = new EditAction();
        this.childTree.addTreeSelectionListener(editAction);
        jPanel.add(new JButton(editAction));
        return jPanel;
    }

    public ChildRelationBrowser(OsmDataLayer osmDataLayer) throws IllegalArgumentException {
        if (osmDataLayer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        this.layer = osmDataLayer;
        this.model = new RelationTreeModel();
        this.build();
    }

    public ChildRelationBrowser(OsmDataLayer osmDataLayer, Relation relation) throws IllegalArgumentException {
        this(osmDataLayer);
        this.populate(relation);
    }

    public void populate(Relation relation) {
        this.model.populate(relation);
    }

    public void populate(List<RelationMember> list) {
        this.model.populate(list);
    }

    protected Dialog getParentDialog() {
        Container container;
        for (container = this; container != null && !(container instanceof Dialog); container = container.getParent()) {
        }
        return (Dialog)container;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadRelationSetTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private int conflictsCount;
        private Exception lastException;
        private Set<Relation> relations;

        public DownloadRelationSetTask(Dialog dialog, Set<Relation> set) {
            super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(dialog), false);
            this.relations = set;
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
            OsmApi.getOsmApi().cancel();
        }

        protected void refreshView(Relation relation) {
            for (int i = 0; i < ChildRelationBrowser.this.childTree.getRowCount(); ++i) {
                Relation relation2 = (Relation)ChildRelationBrowser.this.childTree.getPathForRow(i).getLastPathComponent();
                if (relation2 != relation) continue;
                ChildRelationBrowser.this.model.refreshNode(ChildRelationBrowser.this.childTree.getPathForRow(i));
            }
        }

        @Override
        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", this.conflictsCount), I18n.tr("Conflicts in data"), 2);
            }
        }

        protected void mergeDataSet(DataSet dataSet) {
            if (dataSet != null) {
                MergeVisitor mergeVisitor = new MergeVisitor(ChildRelationBrowser.this.getLayer().data, dataSet);
                mergeVisitor.merge();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChildRelationBrowser.this.getLayer().fireDataChange();
                    }
                });
                if (!mergeVisitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(mergeVisitor.getConflicts());
                    this.conflictsCount += mergeVisitor.getConflicts().size();
                }
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                Iterator<Relation> iterator = this.relations.iterator();
                while (iterator.hasNext() && !this.cancelled) {
                    Relation relation = iterator.next();
                    if (relation.getId() == 0L) continue;
                    this.progressMonitor.setCustomText(I18n.tr("Downloading relation {0}", relation.getDisplayName(DefaultNameFormatter.getInstance())));
                    OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = osmServerObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    this.mergeDataSet(dataSet);
                    this.refreshView(relation);
                }
            }
            catch (Exception exception) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", exception.toString()));
                    return;
                }
                this.lastException = exception;
            }
        }
    }

    class DownloadAllChildrenTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private int conflictsCount;
        private Exception lastException;
        private Relation relation;
        private Stack<Relation> relationsToDownload;
        private Set<Long> downloadedRelationIds;

        public DownloadAllChildrenTask(Dialog dialog, Relation relation) {
            super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(dialog), false);
            this.relation = relation;
            this.relationsToDownload = new Stack();
            this.downloadedRelationIds = new HashSet<Long>();
            this.relationsToDownload.push(this.relation);
        }

        protected void cancel() {
            this.cancelled = true;
            OsmApi.getOsmApi().cancel();
        }

        protected void refreshView(Relation relation) {
            for (int i = 0; i < ChildRelationBrowser.this.childTree.getRowCount(); ++i) {
                Relation relation2 = (Relation)ChildRelationBrowser.this.childTree.getPathForRow(i).getLastPathComponent();
                if (relation2 != relation) continue;
                ChildRelationBrowser.this.model.refreshNode(ChildRelationBrowser.this.childTree.getPathForRow(i));
            }
        }

        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", this.conflictsCount), I18n.tr("Conflicts in data"), 2);
            }
        }

        protected void warnBecauseOfDeletedRelation(Relation relation) {
            String string = I18n.tr("<html>The child relation<br>{0}<br>is deleted on the server. It can't be loaded", relation.getDisplayName(DefaultNameFormatter.getInstance()));
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Relation is deleted"), 2);
        }

        protected void rememberChildRelationsToDownload(Relation relation) {
            this.downloadedRelationIds.add(relation.getId());
            for (RelationMember relationMember : relation.getMembers()) {
                Relation relation2;
                if (!relationMember.isRelation() || this.downloadedRelationIds.contains(relation2 = relationMember.getRelation())) continue;
                this.relationsToDownload.push(relation2);
            }
        }

        protected void mergeDataSet(DataSet dataSet) {
            if (dataSet != null) {
                MergeVisitor mergeVisitor = new MergeVisitor(ChildRelationBrowser.this.getLayer().data, dataSet);
                mergeVisitor.merge();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChildRelationBrowser.this.getLayer().fireDataChange();
                    }
                });
                if (!mergeVisitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(mergeVisitor.getConflicts());
                    this.conflictsCount += mergeVisitor.getConflicts().size();
                }
            }
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                while (!this.relationsToDownload.isEmpty() && !this.cancelled) {
                    Relation relation = this.relationsToDownload.pop();
                    if (relation.getId() == 0L) continue;
                    this.rememberChildRelationsToDownload(relation);
                    this.progressMonitor.setCustomText(I18n.tr("Downloading relation {0}", relation.getDisplayName(DefaultNameFormatter.getInstance())));
                    OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = null;
                    try {
                        dataSet = osmServerObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    }
                    catch (OsmApiException osmApiException) {
                        if (osmApiException.getResponseCode() == 410) {
                            this.warnBecauseOfDeletedRelation(relation);
                            continue;
                        }
                        throw osmApiException;
                    }
                    this.mergeDataSet(dataSet);
                    this.refreshView(relation);
                }
            }
            catch (Exception exception) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", exception.toString()));
                    return;
                }
                this.lastException = exception;
            }
        }
    }

    class DownloadSelectedAction
    extends AbstractAction
    implements TreeSelectionListener {
        public DownloadSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Download selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.putValue("Name", I18n.tr("Download Selected Children"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            TreePath[] treePathArray = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(treePathArray != null && treePathArray.length > 0);
        }

        public void run() {
            TreePath[] treePathArray = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                return;
            }
            HashSet<Relation> hashSet = new HashSet<Relation>();
            for (int i = 0; i < treePathArray.length; ++i) {
                hashSet.add((Relation)treePathArray[i].getLastPathComponent());
            }
            Main.worker.submit(new DownloadRelationSetTask(ChildRelationBrowser.this.getParentDialog(), hashSet));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class DownloadAllChildRelationsAction
    extends AbstractAction {
        public DownloadAllChildRelationsAction() {
            this.putValue("ShortDescription", I18n.tr("Download all child relations (recursively)"));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.putValue("Name", I18n.tr("Download All Children"));
        }

        public void run() {
            Main.worker.submit(new DownloadAllChildrenTask(ChildRelationBrowser.this.getParentDialog(), (Relation)ChildRelationBrowser.this.model.getRoot()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }
    }

    class EditAction
    extends AbstractAction
    implements TreeSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.putValue("Name", I18n.tr("Edit"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            TreePath[] treePathArray = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(treePathArray != null && treePathArray.length > 0);
        }

        public void run() {
            TreePath[] treePathArray = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                return;
            }
            for (int i = 0; i < Math.min(treePathArray.length, 10); ++i) {
                Relation relation = (Relation)treePathArray[i].getLastPathComponent();
                if (relation.incomplete) continue;
                RelationEditor relationEditor = RelationEditor.getEditor(ChildRelationBrowser.this.getLayer(), relation, null);
                relationEditor.setVisible(true);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.refreshEnabled();
        }
    }
}

