/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationListDialog
extends ToggleDialog
implements Layer.LayerChangeListener,
DataChangeListener {
    private static final Logger logger = Logger.getLogger(RelationListDialog.class.getName());
    private JList displaylist;
    private RelationListModel model = new RelationListModel();
    private EditAction editAction;
    private DeleteAction deleteAction;

    public RelationListDialog() {
        super(I18n.tr("Relations"), "relationlist", I18n.tr("Open a list of all relations."), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations")), 82, 4), 150);
        this.displaylist = new JList(this.model);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer());
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new DoubleClickAdapter());
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        NewAction newAction = new NewAction();
        Layer.listeners.add(newAction);
        jPanel.add((Component)new SideButton(newAction), GBC.std());
        this.editAction = new EditAction();
        this.displaylist.addListSelectionListener(this.editAction);
        jPanel.add((Component)new SideButton(this.editAction), GBC.std());
        DuplicateAction duplicateAction = new DuplicateAction();
        this.displaylist.addListSelectionListener(duplicateAction);
        jPanel.add((Component)new SideButton(duplicateAction), GBC.std());
        this.deleteAction = new DeleteAction();
        this.displaylist.addListSelectionListener(this.deleteAction);
        jPanel.add((Component)new SideButton(this.deleteAction), GBC.eol());
        SelectAction selectAction = new SelectAction();
        this.displaylist.addListSelectionListener(selectAction);
        jPanel.add((Component)new SideButton(selectAction), GBC.eol());
        this.add((Component)jPanel, "South");
        Layer.listeners.add(this);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateList();
        }
    }

    protected int getNumRelations() {
        if (Main.main.getCurrentDataSet() == null) {
            return 0;
        }
        return Main.main.getCurrentDataSet().relations.size();
    }

    protected ArrayList<Relation> getDisplayedRelationsInSortOrder(DataSet dataSet) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>(dataSet.relations.size());
        for (Relation relation : dataSet.relations) {
            if (!relation.isUsable() || !relation.isVisible()) continue;
            arrayList.add(relation);
        }
        Collections.sort(arrayList, new Comparator<Relation>(){
            NameFormatter formatter = DefaultNameFormatter.getInstance();

            @Override
            public int compare(Relation relation, Relation relation2) {
                return relation.getDisplayName(this.formatter).compareTo(relation2.getDisplayName(this.formatter));
            }
        });
        return arrayList;
    }

    public void updateList() {
        if (Main.main.getCurrentDataSet() == null) {
            this.model.setRelations(null);
            return;
        }
        Relation relation = this.getSelected();
        this.model.setRelations(this.getDisplayedRelationsInSortOrder(Main.main.getCurrentDataSet()));
        if (this.model.getSize() > 0) {
            this.setTitle(I18n.tr("Relations: {0}", this.model.getSize()));
        } else {
            this.setTitle(I18n.tr("Relations"));
        }
        this.selectRelation(relation);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateList();
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            ((OsmDataLayer)layer).listenerDataChanged.remove(this);
        }
        this.updateList();
    }

    @Override
    public void layerAdded(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            ((OsmDataLayer)layer).listenerDataChanged.add(this);
        }
    }

    @Override
    public void dataChanged(OsmDataLayer osmDataLayer) {
        this.updateList();
    }

    public Relation getCurrentRelation() {
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.displaylist.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.displaylist.removeListSelectionListener(listSelectionListener);
    }

    private Relation getSelected() {
        if (this.model.getSize() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        if (relation == null) {
            this.displaylist.clearSelection();
            return;
        }
        int n = this.model.getIndexOfRelation(relation);
        if (n == -1) {
            this.displaylist.clearSelection();
        } else {
            this.displaylist.setSelectedIndex(n);
            this.displaylist.scrollRectToVisible(this.displaylist.getCellBounds(n, n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationListModel
    extends AbstractListModel {
        private ArrayList<Relation> relations;

        private RelationListModel() {
        }

        public ArrayList<Relation> getRelations() {
            return this.relations;
        }

        public Relation getRelation(int n) {
            return this.relations.get(n);
        }

        public void setRelations(ArrayList<Relation> arrayList) {
            this.relations = arrayList;
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int n) {
            if (this.relations == null) {
                return null;
            }
            return this.relations.get(n);
        }

        @Override
        public int getSize() {
            if (this.relations == null) {
                return 0;
            }
            return this.relations.size();
        }

        public int getIndexOfRelation(Relation relation) {
            if (relation == null) {
                return -1;
            }
            return this.relations.indexOf(relation);
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("ShortDescription", I18n.tr("Set the current selection to the list of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int[] nArray = RelationListDialog.this.displaylist.getSelectedIndices();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(nArray.length);
            for (int n : nArray) {
                arrayList.add(RelationListDialog.this.model.getRelation(n));
            }
            Main.map.mapView.getEditLayer().data.setSelected(arrayList);
            DataSet.fireSelectionChanged(arrayList);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }
    }

    class DuplicateAction
    extends AbstractAction
    implements ListSelectionListener {
        public DuplicateAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window"));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.updateEnabledState();
        }

        public void launchEditorForDuplicate(Relation relation) {
            Relation relation2 = new Relation(relation.getId());
            relation2.cloneFrom(relation);
            relation2.clearOsmId();
            relation2.setModified(true);
            RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation2, null);
            relationEditor.setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditorForDuplicate(RelationListDialog.this.getSelected());
        }

        protected void updateEnabledState() {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class NewAction
    extends AbstractAction
    implements Layer.LayerChangeListener {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "addrelation"));
            this.setEnabled(false);
        }

        public void run() {
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), null, null).setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.setEnabled(false);
        }

        protected void deleteRelation(Relation relation) {
            if (relation == null) {
                return;
            }
            org.openstreetmap.josm.actions.mapmode.DeleteAction.deleteRelation(Main.main.getEditLayer(), relation);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int[] nArray = RelationListDialog.this.displaylist.getSelectedIndices();
            ArrayList<Relation> arrayList = new ArrayList<Relation>(nArray.length);
            for (int n : nArray) {
                arrayList.add(RelationListDialog.this.model.getRelation(n));
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                Relation relation = (Relation)object.next();
                this.deleteRelation(relation);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Open an editor for the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.setEnabled(false);
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation relation) {
            HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            Collection<OsmPrimitive> collection = Main.map.mapView.getEditLayer().data.getSelected();
            for (RelationMember relationMember : relation.getMembers()) {
                if (!collection.contains(relationMember.getMember())) continue;
                hashSet.add(relationMember);
            }
            return hashSet;
        }

        public void launchEditor(Relation relation) {
            if (relation == null) {
                return;
            }
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, this.getMembersForCurrentSelection(relation)).setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditor(RelationListDialog.this.getSelected());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        protected void setCurrentRelationAsSelection() {
            Main.main.getCurrentDataSet().setSelected((Relation)RelationListDialog.this.displaylist.getSelectedValue());
        }

        protected void editCurrentRelation() {
            new EditAction().launchEditor(RelationListDialog.this.getSelected());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.isControlDown()) {
                    this.editCurrentRelation();
                } else {
                    this.setCurrentRelationAsSelection();
                }
            }
        }
    }
}

