/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.VersionConflictResolveCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListMerger;
import org.openstreetmap.josm.gui.conflict.pair.properties.OperationCancelledException;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMerger;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberMerger;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMerger;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolver
extends JPanel
implements PropertyChangeListener {
    public static final String RESOLVED_COMPLETELY_PROP = ConflictResolver.class.getName() + ".resolvedCompletely";
    public static final String MY_PRIMITIVE_PROP = ConflictResolver.class.getName() + ".myPrimitive";
    public static final String THEIR_PRIMITIVE_PROP = ConflictResolver.class.getName() + ".theirPrimitive";
    private static final Logger logger = Logger.getLogger(ConflictResolver.class.getName());
    private JTabbedPane tabbedPane = null;
    private TagMerger tagMerger;
    private NodeListMerger nodeListMerger;
    private RelationMemberMerger relationMemberMerger;
    private PropertiesMerger propertiesMerger;
    private OsmPrimitive my;
    private OsmPrimitive their;
    private ImageIcon mergeComplete;
    private ImageIcon mergeIncomplete;
    private boolean resolvedCompletely = false;

    protected void loadIcons() {
        this.mergeComplete = ImageProvider.get("dialogs/conflict", "mergecomplete.png");
        this.mergeIncomplete = ImageProvider.get("dialogs/conflict", "mergeincomplete.png");
    }

    protected void build() {
        this.tabbedPane = new JTabbedPane();
        this.propertiesMerger = new PropertiesMerger();
        this.propertiesMerger.setName("panel.propertiesmerger");
        this.propertiesMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Properties"), this.propertiesMerger);
        this.tagMerger = new TagMerger();
        this.tagMerger.setName("panel.tagmerger");
        this.tagMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Tags"), this.tagMerger);
        this.nodeListMerger = new NodeListMerger();
        this.nodeListMerger.setName("panel.nodelistmerger");
        this.nodeListMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Nodes"), this.nodeListMerger);
        this.relationMemberMerger = new RelationMemberMerger();
        this.relationMemberMerger.setName("panel.relationmembermerger");
        this.relationMemberMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Members"), this.relationMemberMerger);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public ConflictResolver() {
        this.build();
        this.loadIcons();
    }

    protected void setMy(OsmPrimitive osmPrimitive) {
        OsmPrimitive osmPrimitive2 = this.my;
        this.my = osmPrimitive;
        if (osmPrimitive2 != this.my) {
            this.firePropertyChange(MY_PRIMITIVE_PROP, osmPrimitive2, this.my);
        }
    }

    protected void setTheir(OsmPrimitive osmPrimitive) {
        OsmPrimitive osmPrimitive2 = this.their;
        this.their = osmPrimitive;
        if (osmPrimitive2 != this.their) {
            this.firePropertyChange(THEIR_PRIMITIVE_PROP, osmPrimitive2, this.their);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(TagMergeModel.PROP_NUM_UNDECIDED_TAGS)) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == 0) {
                this.tabbedPane.setTitleAt(1, I18n.tr("Tags"));
                this.tabbedPane.setToolTipTextAt(1, I18n.tr("No pending tag conflicts to be resolved"));
                this.tabbedPane.setIconAt(1, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(1, I18n.tr("Tags({0} conflicts)", n));
                this.tabbedPane.setToolTipTextAt(1, I18n.tr("{0} pending tag conflicts to be resolved"));
                this.tabbedPane.setIconAt(1, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        } else if (propertyChangeEvent.getPropertyName().equals(ListMergeModel.FROZEN_PROP)) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl && propertyChangeEvent.getSource() == this.nodeListMerger.getModel()) {
                this.tabbedPane.setTitleAt(2, I18n.tr("Nodes(resolved)"));
                this.tabbedPane.setToolTipTextAt(2, I18n.tr("Merged node list frozen. No pending conflicts in the node list of this way"));
                this.tabbedPane.setIconAt(2, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(2, I18n.tr("Nodes(with conflicts)"));
                this.tabbedPane.setToolTipTextAt(2, I18n.tr("Pending conflicts in the node list of this way"));
                this.tabbedPane.setIconAt(2, this.mergeIncomplete);
            }
            if (bl && propertyChangeEvent.getSource() == this.relationMemberMerger.getModel()) {
                this.tabbedPane.setTitleAt(3, I18n.tr("Members(resolved)"));
                this.tabbedPane.setToolTipTextAt(3, I18n.tr("Merged member list frozen. No pending conflicts in the member list of this relation"));
                this.tabbedPane.setIconAt(3, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(3, I18n.tr("Members(with conflicts)"));
                this.tabbedPane.setToolTipTextAt(3, I18n.tr("Pending conflicts in the member list of this relation"));
                this.tabbedPane.setIconAt(3, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        } else if (propertyChangeEvent.getPropertyName().equals(PropertiesMergeModel.RESOLVED_COMPLETELY_PROP)) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.tabbedPane.setTitleAt(0, I18n.tr("Properties"));
                this.tabbedPane.setToolTipTextAt(0, I18n.tr("No pending property conflicts"));
                this.tabbedPane.setIconAt(0, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(0, I18n.tr("Properties(with conflicts)"));
                this.tabbedPane.setToolTipTextAt(0, I18n.tr("Pending property conflicts to be resolved"));
                this.tabbedPane.setIconAt(0, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        }
    }

    public void populate(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.setMy(osmPrimitive);
        this.setTheir(osmPrimitive2);
        this.propertiesMerger.getModel().populate(osmPrimitive, osmPrimitive2);
        if (this.propertiesMerger.getModel().hasVisibleStateConflict()) {
            this.tabbedPane.setEnabledAt(1, false);
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setEnabledAt(3, false);
            return;
        }
        this.tabbedPane.setEnabledAt(0, true);
        this.tagMerger.getModel().populate(osmPrimitive, osmPrimitive2);
        this.tabbedPane.setEnabledAt(1, true);
        if (osmPrimitive instanceof Node) {
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setEnabledAt(3, false);
        } else if (osmPrimitive instanceof Way) {
            this.nodeListMerger.populate((Way)osmPrimitive, (Way)osmPrimitive2);
            this.tabbedPane.setEnabledAt(2, true);
            this.tabbedPane.setEnabledAt(3, false);
            this.tabbedPane.setTitleAt(3, I18n.tr("Members"));
            this.tabbedPane.setIconAt(3, null);
        } else if (osmPrimitive instanceof Relation) {
            this.relationMemberMerger.populate((Relation)osmPrimitive, (Relation)osmPrimitive2);
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setTitleAt(2, I18n.tr("Nodes"));
            this.tabbedPane.setIconAt(2, null);
            this.tabbedPane.setEnabledAt(3, true);
        }
        this.updateResolvedCompletely();
    }

    public Command buildResolveCommand() throws OperationCancelledException {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (this.propertiesMerger.getModel().hasVisibleStateConflict()) {
            if (this.propertiesMerger.getModel().isDecidedVisibleState()) {
                arrayList.addAll(this.propertiesMerger.getModel().buildResolveCommand(this.my, this.their));
            }
        } else {
            if (this.tagMerger.getModel().getNumResolvedConflicts() > 0) {
                arrayList.add(this.tagMerger.getModel().buildResolveCommand(this.my, this.their));
            }
            arrayList.addAll(this.propertiesMerger.getModel().buildResolveCommand(this.my, this.their));
            if (this.my instanceof Way && this.nodeListMerger.getModel().isFrozen()) {
                NodeListMergeModel nodeListMergeModel = (NodeListMergeModel)this.nodeListMerger.getModel();
                arrayList.add(nodeListMergeModel.buildResolveCommand((Way)this.my, (Way)this.their));
            } else if (this.my instanceof Relation && this.relationMemberMerger.getModel().isFrozen()) {
                RelationMemberListMergeModel relationMemberListMergeModel = (RelationMemberListMergeModel)this.relationMemberMerger.getModel();
                arrayList.add(relationMemberListMergeModel.buildResolveCommand((Relation)this.my, (Relation)this.their));
            }
            if (this.isResolvedCompletely()) {
                arrayList.add(new VersionConflictResolveCommand(this.my, this.their));
            }
        }
        return new SequenceCommand(I18n.tr("Conflict Resolution"), arrayList);
    }

    protected void updateResolvedCompletely() {
        boolean bl = this.resolvedCompletely;
        if (this.my instanceof Node) {
            this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely();
        } else if (this.my instanceof Way) {
            this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely() && this.nodeListMerger.getModel().isFrozen();
        } else if (this.my instanceof Relation) {
            boolean bl2 = this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely() && this.relationMemberMerger.getModel().isFrozen();
        }
        if (this.resolvedCompletely != bl) {
            this.firePropertyChange(RESOLVED_COMPLETELY_PROP, bl, this.resolvedCompletely);
        }
    }

    public boolean isResolvedCompletely() {
        return this.resolvedCompletely;
    }
}

