/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class SideButton
extends JButton {
    public SideButton(Action action) {
        super(action);
        this.doStyle();
    }

    public SideButton(Action action, String string) {
        this(action);
        this.setIcon(SideButton.makeIcon(string));
    }

    public static ImageIcon makeIcon(String string) {
        Image image = ImageProvider.get("dialogs", string).getImage();
        return new ImageIcon(image.getScaledInstance(20, 20, 4));
    }

    public SideButton(String string, String string2, String string3, ActionListener actionListener) {
        super(SideButton.makeIcon(string));
        this.doStyle();
        this.setActionCommand(string);
        this.addActionListener(actionListener);
        this.setToolTipText(string3);
    }

    public SideButton(String string, String string2, String string3, String string4, Shortcut shortcut, ActionListener actionListener) {
        super(I18n.tr(string), SideButton.makeIcon(string2));
        if (shortcut != null) {
            shortcut.setMnemonic(this);
            if (string4 != null) {
                string4 = Main.platform.makeTooltip(string4, shortcut);
            }
        }
        this.setup(string, string3, string4, actionListener);
    }

    public SideButton(String string, String string2, String string3, String string4, ActionListener actionListener) {
        super(I18n.tr(string), SideButton.makeIcon(string2));
        this.setup(string, string3, string4, actionListener);
    }

    private void setup(String string, String string2, String string3, ActionListener actionListener) {
        this.doStyle();
        this.setActionCommand(string);
        this.addActionListener(actionListener);
        this.setToolTipText(string3);
        this.putClientProperty("help", "Dialog/" + string2 + "/" + string);
    }

    private void doStyle() {
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setIconTextGap(2);
    }
}

