/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends NavigatableComponent
implements PropertyChangeListener {
    private ArrayList<Layer> layers = new ArrayList();
    public PlayHeadMarker playHeadMarker = null;
    private Layer activeLayer;
    public MouseEvent lastMEvent;
    private LinkedList<MapViewPaintable> temporaryLayers = new LinkedList();
    private BufferedImage offscreenBuffer;
    private boolean virtualNodesEnabled = false;

    public MapView() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapSlider mapSlider = new MapSlider(MapView.this);
                MapView.this.add(mapSlider);
                mapSlider.setBounds(3, 0, 114, 30);
                MapScaler mapScaler = new MapScaler(MapView.this);
                MapView.this.add(mapScaler);
                mapScaler.setLocation(10, 30);
                if (!MapView.this.zoomToEditLayerBoundingBox()) {
                    new AutoScaleAction("data").actionPerformed(null);
                }
                new MapMover(MapView.this, Main.contentPane);
                MoveAction moveAction = new MoveAction(MoveAction.Direction.UP);
                if (moveAction.getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "UP");
                    Main.contentPane.getActionMap().put("UP", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.DOWN)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "DOWN");
                    Main.contentPane.getActionMap().put("DOWN", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.LEFT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "LEFT");
                    Main.contentPane.getActionMap().put("LEFT", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.RIGHT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "RIGHT");
                    Main.contentPane.getActionMap().put("RIGHT", moveAction);
                }
            }
        });
        DataSet.selListeners.add(new SelectionChangedListener(){

            @Override
            public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
                MapView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
    }

    public void addLayer(Layer layer) {
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        if (layer.isBackgroundLayer() || this.layers.isEmpty()) {
            this.layers.add(layer);
        } else {
            this.layers.add(0, layer);
        }
        for (Layer.LayerChangeListener object : Layer.listeners) {
            object.layerAdded(layer);
        }
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            Layer layer2 = this.activeLayer;
            this.setActiveLayer(layer);
            for (Layer.LayerChangeListener layerChangeListener : Layer.listeners) {
                layerChangeListener.activeLayerChange(layer2, layer);
            }
        }
        layer.addPropertyChangeListener(this);
        AudioPlayer.reset();
        this.repaint();
    }

    @Override
    protected DataSet getCurrentDataSet() {
        if (this.activeLayer != null && this.activeLayer instanceof OsmDataLayer) {
            return ((OsmDataLayer)this.activeLayer).data;
        }
        return null;
    }

    public boolean isActiveLayerDrawable() {
        return this.activeLayer != null && this.activeLayer instanceof OsmDataLayer;
    }

    public boolean isActiveLayerVisible() {
        return this.isActiveLayerDrawable() && this.activeLayer.isVisible();
    }

    protected void fireActiveLayerChanged(Layer layer, Layer layer2) {
        for (Layer.LayerChangeListener layerChangeListener : Layer.listeners) {
            layerChangeListener.activeLayerChange(layer, layer2);
        }
    }

    protected Layer determineNextActiveLayer() {
        if (this.layers.isEmpty()) {
            return null;
        }
        List<OsmDataLayer> list = this.getLayersOfType(OsmDataLayer.class);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return this.layers.get(0);
    }

    public void removeLayer(Layer layer) {
        Object object;
        boolean bl = false;
        if (layer == this.activeLayer) {
            this.activeLayer = null;
            bl = true;
            this.fireActiveLayerChanged(layer, null);
        }
        if (this.layers.remove(layer)) {
            object = Layer.listeners.iterator();
            while (object.hasNext()) {
                Layer.LayerChangeListener layerChangeListener = object.next();
                layerChangeListener.layerRemoved(layer);
            }
        }
        layer.removePropertyChangeListener(this);
        layer.destroy();
        AudioPlayer.reset();
        if (bl && (object = this.determineNextActiveLayer()) != null) {
            this.activeLayer = object;
            this.fireActiveLayerChanged(null, (Layer)object);
        }
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int n) {
        int n2 = this.layers.indexOf(layer);
        if (n2 == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list."));
        }
        if (n == n2) {
            return;
        }
        this.layers.remove(n2);
        if (n >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(n, layer);
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public int getLayerPos(Layer layer) {
        int n = this.layers.indexOf(layer);
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list."));
        }
        return n;
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            arrayList.add(layer);
        }
        Collections.sort(arrayList, new Comparator<Layer>(){

            @Override
            public int compare(Layer layer, Layer layer2) {
                if (layer instanceof OsmDataLayer && layer2 instanceof OsmDataLayer) {
                    if (layer == MapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (layer2 == MapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return new Integer(MapView.this.layers.indexOf(layer)).compareTo(MapView.this.layers.indexOf(layer2));
                }
                return new Integer(MapView.this.layers.indexOf(layer)).compareTo(MapView.this.layers.indexOf(layer2));
            }
        });
        Collections.reverse(arrayList);
        return arrayList;
    }

    @Override
    public void paint(Graphics graphics) {
        double d;
        if (this.center == null) {
            return;
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setColor(Main.pref.getColor("background", Color.BLACK));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (Layer mapViewPaintable : this.getVisibleLayersInZOrder()) {
            mapViewPaintable.paint(graphics2D, this);
        }
        for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
            mapViewPaintable.paint(graphics2D, this);
        }
        graphics2D.setColor(Color.WHITE);
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        double d2 = bounds.min.lon();
        Point point = this.getPoint(bounds.min);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(point.x, point.y);
        double d3 = bounds.max.lat();
        for (d = bounds.min.lat(); d <= d3; d += 1.0) {
            point = this.getPoint(new LatLon(d >= d3 ? d3 : d, d2));
            generalPath.lineTo(point.x, point.y);
        }
        d = d3;
        d3 = bounds.max.lon();
        while (d2 <= d3) {
            point = this.getPoint(new LatLon(d, d2 >= d3 ? d3 : d2));
            generalPath.lineTo(point.x, point.y);
            d2 += 1.0;
        }
        d2 = d3;
        d3 = bounds.min.lat();
        while (d >= d3) {
            point = this.getPoint(new LatLon(d <= d3 ? d3 : d, d2));
            generalPath.lineTo(point.x, point.y);
            d -= 1.0;
        }
        d = d3;
        d3 = bounds.min.lon();
        while (d2 >= d3) {
            point = this.getPoint(new LatLon(d, d2 <= d3 ? d3 : d2));
            generalPath.lineTo(point.x, point.y);
            d2 -= 1.0;
        }
        int n = this.offscreenBuffer.getWidth();
        int n2 = this.offscreenBuffer.getHeight();
        Area area = new Area(generalPath);
        Area area2 = new Area(new Rectangle(-1, -1, n + 2, n2 + 2));
        area.intersect(area2);
        graphics2D.draw(area);
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(graphics);
    }

    public void recalculateCenterScale(BoundingXYVisitor boundingXYVisitor) {
        if (boundingXYVisitor == null) {
            boundingXYVisitor = new BoundingXYVisitor();
        }
        if (boundingXYVisitor.getBounds() == null) {
            boundingXYVisitor.visit(this.getProjection().getWorldBoundsLatLon());
        }
        if (!boundingXYVisitor.hasExtend()) {
            boundingXYVisitor.enlargeBoundingBox();
        }
        this.zoomTo(boundingXYVisitor.getBounds());
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public List<Layer> getAllLayersAsList() {
        return Collections.unmodifiableList(this.layers);
    }

    public <T> List<T> getLayersOfType(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Layer layer : this.getAllLayersAsList()) {
            if (!clazz.isInstance(layer)) continue;
            arrayList.add(clazz.cast(layer));
        }
        return arrayList;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    public void setActiveLayer(Layer layer) {
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' must be in list of layers", layer.toString()));
        }
        if (!(layer instanceof OsmDataLayer) && this.getCurrentDataSet() != null) {
            this.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
            DataSet.fireSelectionChanged(this.getCurrentDataSet().getSelected());
        }
        Layer layer2 = this.activeLayer;
        this.activeLayer = layer;
        if (layer2 != layer) {
            for (Layer.LayerChangeListener object : Layer.listeners) {
                object.activeLayerChange(layer2, layer);
            }
        }
        if (layer instanceof OsmDataLayer) {
            this.refreshTitle((OsmDataLayer)layer);
        }
        Enumeration<AbstractButton> enumeration = Main.map.toolGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            abstractButton.setEnabled(((MapMode)abstractButton.getAction()).layerIsSupported(layer));
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public OsmDataLayer getEditLayer() {
        if (this.activeLayer instanceof OsmDataLayer) {
            return (OsmDataLayer)this.activeLayer;
        }
        for (Layer layer : this.layers) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return (OsmDataLayer)layer;
        }
        return null;
    }

    public boolean hasLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    public boolean zoomToEditLayerBoundingBox() {
        OsmDataLayer osmDataLayer = this.getEditLayer();
        if (osmDataLayer == null) {
            return false;
        }
        Collection<DataSource> collection = osmDataLayer.data.dataSources;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : collection) {
            boundingXYVisitor.visit(dataSource.bounds);
            if (!boundingXYVisitor.hasExtend()) continue;
            this.recalculateCenterScale(boundingXYVisitor);
            return true;
        }
        return false;
    }

    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        if (this.temporaryLayers.contains(mapViewPaintable)) {
            return false;
        }
        return this.temporaryLayers.add(mapViewPaintable);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        return this.temporaryLayers.remove(mapViewPaintable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        OsmDataLayer osmDataLayer;
        if (propertyChangeEvent.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if ((propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) && (osmDataLayer = (OsmDataLayer)propertyChangeEvent.getSource()) == this.getEditLayer()) {
            this.refreshTitle(osmDataLayer);
        }
    }

    protected void refreshTitle(OsmDataLayer osmDataLayer) {
        boolean bl;
        boolean bl2 = bl = osmDataLayer.requiresSaveToFile() || osmDataLayer.requiresUploadToServer();
        if (bl) {
            JOptionPane.getFrameForComponent(Main.parent).setTitle("* " + I18n.tr("Java OpenStreetMap Editor"));
        } else {
            JOptionPane.getFrameForComponent(Main.parent).setTitle(I18n.tr("Java OpenStreetMap Editor"));
        }
    }
}

