/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormatter
implements NameFormatter {
    private static DefaultNameFormatter instance;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;

    public static DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected String decorateNameWithId(String string, OsmPrimitive osmPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            return string + I18n.tr(" [id: {0}]", osmPrimitive.getId());
        }
        return string;
    }

    @Override
    public String format(Node node) {
        String string = "";
        if (node.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
            if (string == null) {
                string = node.getId() == 0L ? I18n.tr("node") : "" + node.getId();
            }
            string = string + " (" + node.getCoor().latToString(CoordinateFormat.getDefaultFormat()) + ", " + node.getCoor().lonToString(CoordinateFormat.getDefaultFormat()) + ")";
        }
        string = this.decorateNameWithId(string, node);
        return string;
    }

    @Override
    public String format(Way way) {
        String string = "";
        if (way.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
            if (string == null) {
                string = way.get("ref");
            }
            if (string == null) {
                string = way.get("highway") != null ? I18n.tr("highway") : (way.get("railway") != null ? I18n.tr("railway") : (way.get("waterway") != null ? I18n.tr("waterway") : (way.get("landuse") != null ? I18n.tr("landuse") : "")));
            }
            int n = new HashSet<Node>(way.getNodes()).size();
            String string2 = I18n.trn("{0} node", "{0} nodes", n, n);
            string = string + (string.length() > 0 ? " (" + string2 + ")" : string2);
            if (way.errors != null) {
                string = "*" + string;
            }
        }
        string = this.decorateNameWithId(string, way);
        return string;
    }

    @Override
    public String format(Relation relation) {
        String string;
        if (relation.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = relation.get("type");
            if (string == null) {
                string = I18n.tr("relation");
            }
            string = string + " (";
            String string2 = null;
            HashSet<String> hashSet = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
            for (String string3 : relation.keySet()) {
                if (hashSet.contains(string3.trim()) && (string2 = Main.pref.getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName()) == null) {
                    string2 = relation.get(string3);
                }
                if (string2 == null) continue;
                break;
            }
            string = string2 == null ? string + Long.toString(relation.getId()) + ", " : string + "\"" + string2 + "\", ";
            int n = relation.getMembersCount();
            string = string + I18n.trn("{0} member", "{0} members", n, n) + ")";
            if (relation.errors != null) {
                string = "*" + string;
            }
        }
        string = this.decorateNameWithId(string, relation);
        return string;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    static {
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "note"};
        namingTagsForRelations = null;
    }
}

