/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

class Ellipsoid {
    public static final Ellipsoid clarke = new Ellipsoid(6378249.2, 6356515.0);
    public static final Ellipsoid hayford = new Ellipsoid(6378388.0, 6356911.9461);
    public static final Ellipsoid GRS80 = new Ellipsoid(6378137.0, 6356752.314);
    public final double a;
    public final double b;
    public final double e;
    public final double e2;
    public final double eb2;

    public Ellipsoid(double d, double d2) {
        this.a = d;
        this.b = d2;
        this.e2 = (d * d - d2 * d2) / (d * d);
        this.e = Math.sqrt(this.e2);
        this.eb2 = this.e2 / (1.0 - this.e2);
    }

    public double verticalRadiusOfCurvature(double d) {
        return this.a / Math.sqrt(1.0 - this.e2 * Ellipsoid.sqr(Math.sin(d)));
    }

    private static double sqr(double d) {
        return d * d;
    }

    public double meridionalArc(double d) {
        double d2 = Math.sin(2.0 * d);
        double d3 = Math.sin(4.0 * d);
        double d4 = Math.sin(6.0 * d);
        double d5 = Math.sin(8.0 * d);
        double d6 = 0.0033528106647474805;
        double d7 = d6 / (2.0 - d6);
        double d8 = d7 * d7;
        double d9 = d8 * d7;
        double d10 = d9 * d7;
        double d11 = d10 * d7;
        double d12 = d7 - d8;
        double d13 = d8 - d9;
        double d14 = d9 - d10;
        double d15 = d10 - d11;
        double d16 = this.a * (1.0 - d7 + 1.25 * d13 + 1.265625 * d15);
        double d17 = 1.5 * this.a * (d12 + 0.875 * d14 + 0.859375 * d11);
        double d18 = 0.9375 * this.a * (d13 + 0.75 * d15);
        double d19 = 0.7291666666666666 * this.a * (d14 + 0.6875 * d11);
        double d20 = 0.615234375 * this.a * d15;
        return d16 * d - d17 * d2 + d18 * d3 - d19 * d4 + d20 * d5;
    }

    public double meridionalRadiusOfCurvature(double d) {
        return this.verticalRadiusOfCurvature(d) / (1.0 + this.eb2 * Ellipsoid.sqr(Math.cos(d)));
    }

    public double latitudeIsometric(double d, double d2) {
        double d3 = 1.0 - d2 * Math.sin(d);
        double d4 = 1.0 + d2 * Math.sin(d);
        return Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow(d3 / d4, d2 / 2.0));
    }

    public double latitudeIsometric(double d) {
        double d2 = 1.0 - this.e * Math.sin(d);
        double d3 = 1.0 + this.e * Math.sin(d);
        return Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow(d2 / d3, this.e / 2.0));
    }

    public double latitude(double d, double d2, double d3) {
        double d4;
        double d5 = d4 = 2.0 * Math.atan(Math.exp(d)) - 1.5707963267948966;
        double d6 = 1.0;
        while (Math.abs(d6 - d5) >= d3) {
            d5 = d6;
            double d7 = 1.0 + d2 * Math.sin(d5);
            double d8 = 1.0 - d2 * Math.sin(d5);
            d6 = 2.0 * Math.atan(Math.pow(d7 / d8, d2 / 2.0) * Math.exp(d)) - 1.5707963267948966;
        }
        return d6;
    }
}

