/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeVisitor
extends AbstractVisitor {
    private static Logger logger = Logger.getLogger(MergeVisitor.class.getName());
    private ConflictCollection conflicts;
    private final DataSet myDataSet;
    private final DataSet theirDataSet;
    private final HashMap<Long, Node> nodeshash = new HashMap();
    private final HashMap<Long, Way> wayshash = new HashMap();
    private final HashMap<Long, Relation> relshash = new HashMap();
    private Map<OsmPrimitive, OsmPrimitive> merged;

    public MergeVisitor(DataSet dataSet, DataSet dataSet2) {
        this.myDataSet = dataSet;
        this.theirDataSet = dataSet2;
        for (Node osmPrimitive : dataSet.nodes) {
            if (osmPrimitive.getId() == 0L) continue;
            this.nodeshash.put(osmPrimitive.getId(), osmPrimitive);
        }
        for (Way way : dataSet.ways) {
            if (way.getId() == 0L) continue;
            this.wayshash.put(way.getId(), way);
        }
        for (Relation relation : dataSet.relations) {
            if (relation.getId() == 0L) continue;
            this.relshash.put(relation.getId(), relation);
        }
        this.conflicts = new ConflictCollection();
        this.merged = new HashMap<OsmPrimitive, OsmPrimitive>();
    }

    protected <P extends OsmPrimitive> void mergePrimitive(P p, Collection<P> collection, Collection<P> collection2, HashMap<Long, P> hashMap) {
        if (p.getId() > 0L) {
            if (this.mergeById(collection, hashMap, p)) {
                return;
            }
        } else {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.getId() > 0L || !osmPrimitive.hasEqualSemanticAttributes(p)) continue;
                if (osmPrimitive.isDeleted() != p.isDeleted()) {
                    this.conflicts.add(osmPrimitive, p);
                } else {
                    osmPrimitive.setVisible(p.isVisible());
                    osmPrimitive.user = p.user;
                    osmPrimitive.setTimestamp(p.getTimestamp());
                    osmPrimitive.setModified(p.isModified());
                    this.merged.put(p, osmPrimitive);
                }
                return;
            }
        }
        collection.add(p);
    }

    @Override
    public void visit(Node node) {
        this.mergePrimitive(node, this.myDataSet.nodes, this.theirDataSet.nodes, this.nodeshash);
    }

    @Override
    public void visit(Way way) {
        this.fixWay(way);
        this.mergePrimitive(way, this.myDataSet.ways, this.theirDataSet.ways, this.wayshash);
    }

    @Override
    public void visit(Relation relation) {
        this.fixRelation(relation);
        this.mergePrimitive(relation, this.myDataSet.relations, this.theirDataSet.relations, this.relshash);
    }

    protected void fixIncomplete(Way way) {
        if (!way.incomplete) {
            return;
        }
        if (way.incomplete && way.getNodesCount() == 0) {
            return;
        }
        for (Node node : way.getNodes()) {
            if (!node.incomplete) continue;
            return;
        }
        way.incomplete = false;
    }

    public void fixReferences() {
        for (Way osmPrimitive : this.myDataSet.ways) {
            this.fixWay(osmPrimitive);
            this.fixIncomplete(osmPrimitive);
        }
        for (Relation relation : this.myDataSet.relations) {
            this.fixRelation(relation);
        }
        for (OsmPrimitive osmPrimitive : this.conflicts.getMyConflictParties()) {
            if (osmPrimitive instanceof Way) {
                this.fixWay((Way)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            this.fixRelation((Relation)osmPrimitive);
        }
    }

    private void fixWay(Way way) {
        boolean bl = false;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node : way.getNodes()) {
            Node node2 = (Node)this.merged.get(node);
            if (node2 != null) {
                if (!node2.isDeleted()) {
                    linkedList.add(node2);
                }
                bl = true;
                continue;
            }
            linkedList.add(node);
        }
        if (bl) {
            way.setNodes(linkedList);
        }
    }

    private void fixRelation(Relation relation) {
        boolean bl = false;
        LinkedList<RelationMember> linkedList = new LinkedList<RelationMember>();
        for (RelationMember relationMember : relation.getMembers()) {
            OsmPrimitive osmPrimitive = this.merged.get(relationMember.getMember());
            if (osmPrimitive == null) {
                linkedList.add(relationMember);
                continue;
            }
            if (!osmPrimitive.isDeleted()) {
                RelationMember relationMember2 = new RelationMember(relationMember.getRole(), osmPrimitive);
                linkedList.add(relationMember2);
            }
            bl = true;
        }
        if (bl) {
            relation.setMembers(linkedList);
        }
    }

    private <P extends OsmPrimitive> boolean mergeById(Collection<P> collection, HashMap<Long, P> hashMap, P p) {
        if (hashMap.containsKey(p.getId())) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)hashMap.get(p.getId());
            if (osmPrimitive.getVersion() <= p.getVersion()) {
                if (!osmPrimitive.isVisible() && p.isVisible()) {
                    logger.warning(I18n.tr("My primitive with id {0} and version {1} is visible although their primitive with lower version {2} is not visible. Can't deal with this inconsistency. Keeping my primitive. ", Long.toString(osmPrimitive.getId()), Long.toString(osmPrimitive.getVersion()), Long.toString(p.getVersion())));
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.isVisible() && !p.isVisible()) {
                    this.conflicts.add(osmPrimitive, p);
                } else if (osmPrimitive.incomplete && !p.incomplete) {
                    osmPrimitive.incomplete = false;
                    osmPrimitive.cloneFrom(p);
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.incomplete && p.incomplete) {
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.incomplete && p.incomplete) {
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.isDeleted() && !p.isDeleted() && osmPrimitive.getVersion() == p.getVersion()) {
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.isDeleted() != p.isDeleted()) {
                    this.conflicts.add(osmPrimitive, p);
                } else if (!osmPrimitive.isModified() && p.isModified()) {
                    if (p.isDeleted()) {
                        this.myDataSet.unlinkReferencesToPrimitive(osmPrimitive);
                    }
                    osmPrimitive.cloneFrom(p);
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.isModified() && !p.isModified() && osmPrimitive.getVersion() == p.getVersion()) {
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.isModified() && !p.isModified() && osmPrimitive.getVersion() < p.getVersion()) {
                    osmPrimitive.cloneFrom(p);
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.isModified() && !p.isModified() && osmPrimitive.getVersion() == p.getVersion()) {
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.hasEqualSemanticAttributes(p)) {
                    this.conflicts.add(osmPrimitive, p);
                } else {
                    osmPrimitive.cloneFrom(p);
                    osmPrimitive.setModified(true);
                    this.merged.put(p, osmPrimitive);
                }
            } else {
                this.merged.put(p, osmPrimitive);
            }
            return true;
        }
        return false;
    }

    public void merge() {
        for (OsmPrimitive osmPrimitive : this.theirDataSet.allPrimitives()) {
            osmPrimitive.visit(this);
        }
        this.fixReferences();
    }

    public DataSet getMyDataSet() {
        return this.myDataSet;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

