/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPaintVisitor
extends SimplePaintVisitor {
    protected boolean useRealWidth;
    protected boolean zoomLevelDisplay;
    protected int fillAreas;
    protected boolean drawMultipolygon;
    protected boolean drawRestriction;
    protected boolean leftHandTraffic;
    protected int showNames;
    protected int showIcons;
    protected int useStrokes;
    protected int fillAlpha;
    protected Color untaggedColor;
    protected Color textColor;
    protected float[] currentDashed = new float[0];
    protected Color currentDashedColor;
    protected int currentWidth = 0;
    protected Stroke currentStroke = null;
    protected Font orderFont;
    protected ElemStyles.StyleSet styles;
    protected double circum;
    protected double dist;
    protected Collection<String> regionalNameOrder;
    protected Boolean selectedCall;
    protected Boolean useStyleCache;
    private static int paintid = 0;
    private static int viewid = 0;
    private EastNorth minEN;
    private EastNorth maxEN;

    protected boolean isZoomOk(ElemStyle elemStyle) {
        if (!this.zoomLevelDisplay) {
            return true;
        }
        if (elemStyle == null) {
            return this.circum < 1500.0;
        }
        return !(this.circum >= (double)elemStyle.maxScale) && !(this.circum < (double)elemStyle.minScale);
    }

    public ElemStyle getPrimitiveStyle(OsmPrimitive osmPrimitive) {
        if (!this.useStyleCache.booleanValue()) {
            return this.styles != null ? this.styles.get(osmPrimitive) : null;
        }
        if (osmPrimitive.mappaintStyle == null && this.styles != null) {
            osmPrimitive.mappaintStyle = this.styles.get(osmPrimitive);
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).isMappaintArea = this.styles.isArea(osmPrimitive);
            }
        }
        return osmPrimitive.mappaintStyle;
    }

    public IconElemStyle getPrimitiveNodeStyle(OsmPrimitive osmPrimitive) {
        if (!this.useStyleCache.booleanValue()) {
            return this.styles != null ? this.styles.getIcon(osmPrimitive) : null;
        }
        if (osmPrimitive.mappaintStyle == null && this.styles != null) {
            osmPrimitive.mappaintStyle = this.styles.getIcon(osmPrimitive);
        }
        return (IconElemStyle)osmPrimitive.mappaintStyle;
    }

    public boolean isPrimitiveArea(Way way) {
        if (!this.useStyleCache.booleanValue()) {
            return this.styles.isArea(way);
        }
        if (way.mappaintStyle == null && this.styles != null) {
            way.mappaintStyle = this.styles.get(way);
            way.isMappaintArea = this.styles.isArea(way);
        }
        return way.isMappaintArea;
    }

    @Override
    public void visit(Node node) {
        if (node.getEastNorth().east() > this.maxEN.east() || node.getEastNorth().north() > this.maxEN.north() || node.getEastNorth().east() < this.minEN.east() || node.getEastNorth().north() < this.minEN.north()) {
            node.mappaintVisibleCode = viewid;
            return;
        }
        node.mappaintVisibleCode = 0;
        IconElemStyle iconElemStyle = (IconElemStyle)this.getPrimitiveStyle(node);
        if (iconElemStyle != null && this.isZoomOk(iconElemStyle) && (double)this.showIcons > this.dist) {
            this.drawNode(node, iconElemStyle.icon, iconElemStyle.annotate, node.isSelected());
        } else if (node.highlighted) {
            this.drawNode(node, this.highlightColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (node.isSelected()) {
            this.drawNode(node, this.selectedColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (node.isTagged()) {
            this.drawNode(node, this.nodeColor, this.taggedNodeSize, this.taggedNodeRadius, this.fillUnselectedNode);
        } else if (node.isDisabled()) {
            this.drawNode(node, this.inactiveColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        } else {
            this.drawNode(node, this.nodeColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.getNodesCount() < 2) {
            way.mappaintVisibleCode = viewid;
            return;
        }
        double d = 10000.0;
        double d2 = -10000.0;
        double d3 = 10000.0;
        double d4 = -10000.0;
        for (Node object : way.getNodes()) {
            if (object.getEastNorth().east() > d2) {
                d2 = object.getEastNorth().east();
            }
            if (object.getEastNorth().north() > d4) {
                d4 = object.getEastNorth().north();
            }
            if (object.getEastNorth().east() < d) {
                d = object.getEastNorth().east();
            }
            if (!(object.getEastNorth().north() < d3)) continue;
            d3 = object.getEastNorth().north();
        }
        if (d > this.maxEN.east() || d3 > this.maxEN.north() || d2 < this.minEN.east() || d4 < this.minEN.north()) {
            way.mappaintVisibleCode = viewid;
            return;
        }
        ElemStyle elemStyle = this.getPrimitiveStyle(way);
        if (!this.isZoomOk(elemStyle)) {
            way.mappaintVisibleCode = viewid;
            return;
        }
        way.mappaintVisibleCode = 0;
        if ((double)this.fillAreas > this.dist) {
            way.clearErrors();
        }
        if (elemStyle == null) {
            this.drawWay(way, null, this.untaggedColor, way.isSelected());
        } else if (elemStyle instanceof LineElemStyle) {
            this.drawWay(way, (LineElemStyle)elemStyle, this.untaggedColor, way.isSelected());
        } else if (elemStyle instanceof AreaElemStyle) {
            AreaElemStyle areaElemStyle = (AreaElemStyle)elemStyle;
            if ((double)this.fillAreas > this.dist) {
                this.drawArea(way, way.isSelected() ? this.selectedColor : areaElemStyle.color);
                if (!way.isClosed()) {
                    way.putError(I18n.tr("Area style way is not closed."), true);
                }
            }
            this.drawWay(way, areaElemStyle.line, areaElemStyle.color, way.isSelected());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawWay(Way way, LineElemStyle lineElemStyle, Color color, Boolean bl) {
        Node node;
        boolean bl2 = way.isSelected() || !this.useRealWidth && this.showDirectionArrow && (!this.showRelevantDirectionsOnly || way.hasDirectionKeys());
        boolean bl3 = bl2 && !way.isSelected() && this.showHeadArrowOnly;
        int n = this.defaultSegmentWidth;
        int n2 = 0;
        float[] fArray = new float[]{};
        Color color2 = null;
        if (lineElemStyle != null) {
            if (lineElemStyle.color != null) {
                color = lineElemStyle.color;
            }
            n = lineElemStyle.width;
            n2 = lineElemStyle.realWidth;
            fArray = lineElemStyle.dashed;
            color2 = lineElemStyle.dashedColor;
        }
        if (bl.booleanValue()) {
            color = this.selectedColor;
        }
        if (n2 > 0 && this.useRealWidth && !bl2) {
            void var13_16;
            String object22;
            int n3 = (int)(100.0f / (float)(this.circum / (double)n2));
            if (n3 > n) {
                n = n3;
            }
            if ((object22 = way.get("width")) == null) {
                String n4 = way.get("est_width");
            }
            if (var13_16 != null) {
                try {
                    n = Integer.parseInt((String)var13_16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (way.highlighted) {
            color = this.highlightColor;
        } else if (way.isSelected()) {
            color = this.selectedColor;
        } else if (way.isDisabled()) {
            color = this.inactiveColor;
        }
        if (lineElemStyle != null && lineElemStyle.overlays != null) {
            for (LineElemStyle lineElemStyle2 : lineElemStyle.overlays) {
                if (lineElemStyle2.over) continue;
                node = null;
                for (Node node2 : way.getNodes()) {
                    if (node != null) {
                        this.drawSeg(node, node2, lineElemStyle2.color != null && !way.isSelected() ? lineElemStyle2.color : color, false, lineElemStyle2.getWidth(n), lineElemStyle2.dashed, lineElemStyle2.dashedColor);
                    }
                    node = node2;
                }
            }
        }
        node = null;
        Iterator<Node> iterator = way.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node3 = iterator.next();
            if (node != null) {
                this.drawSeg(node, node3, color, bl3 ? !iterator.hasNext() : bl2, n, fArray, color2);
            }
            node = node3;
        }
        if (lineElemStyle != null && lineElemStyle.overlays != null) {
            for (LineElemStyle lineElemStyle3 : lineElemStyle.overlays) {
                if (!lineElemStyle3.over) continue;
                node = null;
                for (Node node4 : way.getNodes()) {
                    if (node != null) {
                        this.drawSeg(node, node4, lineElemStyle3.color != null && !way.isSelected() ? lineElemStyle3.color : color, false, lineElemStyle3.getWidth(n), lineElemStyle3.dashed, lineElemStyle3.dashedColor);
                    }
                    node = node4;
                }
            }
        }
        if (this.showOrderNumber) {
            boolean bl4 = false;
            node = null;
            for (Node node5 : way.getNodes()) {
                if (node != null) {
                    void var13_24;
                    this.drawOrderNumber(node, node5, (int)(++var13_24));
                }
                node = node5;
            }
        }
        this.displaySegments();
    }

    public Collection<Way> joinWays(Collection<Way> collection, OsmPrimitive osmPrimitive) {
        LinkedList<Way> linkedList = new LinkedList<Way>();
        Object[] objectArray = collection.toArray();
        int n = collection.size();
        while (n != 0) {
            Way way = null;
            Boolean bl = false;
            List<Node> list = null;
            Boolean bl2 = true;
            while (bl2.booleanValue() && n != 0) {
                bl2 = false;
                for (int i = 0; i < objectArray.length && n != 0; ++i) {
                    int n2;
                    if (objectArray[i] == null) continue;
                    Way way2 = (Way)objectArray[i];
                    if (way == null) {
                        way = way2;
                        bl = way.isSelected();
                        objectArray[i] = null;
                        --n;
                        continue;
                    }
                    int n3 = 0;
                    int n4 = way2.getNodesCount() - 1;
                    if (list == null) {
                        n2 = way.getNodesCount() - 1;
                        if (way.getNode(n2) == way2.getNode(0)) {
                            n3 = 21;
                        } else if (way.getNode(n2) == way2.getNode(n4)) {
                            n3 = 22;
                        } else if (way.getNode(0) == way2.getNode(0)) {
                            n3 = 11;
                        } else if (way.getNode(0) == way2.getNode(n4)) {
                            n3 = 12;
                        }
                    } else {
                        n2 = list.size() - 1;
                        if (list.get(n2) == way2.getNode(0)) {
                            n3 = 21;
                        } else if (list.get(0) == way2.getNode(n4)) {
                            n3 = 12;
                        } else if (list.get(0) == way2.getNode(0)) {
                            n3 = 11;
                        } else if (list.get(n2) == way2.getNode(n4)) {
                            n3 = 22;
                        }
                    }
                    if (n3 == 0) continue;
                    objectArray[i] = null;
                    bl2 = true;
                    if (way2.isSelected()) {
                        bl = true;
                    }
                    --n;
                    if (list == null) {
                        list = way.getNodes();
                    }
                    list.remove(n3 == 21 || n3 == 22 ? n2 : 0);
                    if (n3 == 21) {
                        list.addAll(way2.getNodes());
                        continue;
                    }
                    if (n3 == 12) {
                        list.addAll(0, way2.getNodes());
                        continue;
                    }
                    if (n3 == 22) {
                        for (Node node : way2.getNodes()) {
                            list.add(n2, node);
                        }
                        continue;
                    }
                    for (Node node : way2.getNodes()) {
                        list.add(0, node);
                    }
                }
            }
            if (list != null) {
                way = new Way(way);
                way.setNodes(list);
                way.setSelected(bl);
            }
            if (!way.isClosed() && osmPrimitive != null) {
                osmPrimitive.putError(I18n.tr("multipolygon way ''{0}'' is not closed.", way.getDisplayName(DefaultNameFormatter.getInstance())), true);
            }
            linkedList.add(way);
        }
        return linkedList;
    }

    public void drawSelectedMember(OsmPrimitive osmPrimitive, ElemStyle elemStyle, Boolean bl, Boolean bl2) {
        if (osmPrimitive instanceof Way) {
            if (elemStyle instanceof AreaElemStyle) {
                Way way = (Way)osmPrimitive;
                AreaElemStyle areaElemStyle = (AreaElemStyle)elemStyle;
                this.drawWay(way, areaElemStyle.line, this.selectedColor, true);
                if (bl.booleanValue()) {
                    this.drawArea(way, bl2 != false ? this.selectedColor : areaElemStyle.color);
                }
            } else {
                this.drawWay((Way)osmPrimitive, (LineElemStyle)elemStyle, this.selectedColor, true);
            }
        } else if (osmPrimitive instanceof Node) {
            if (elemStyle != null && this.isZoomOk(elemStyle)) {
                this.drawNode((Node)osmPrimitive, ((IconElemStyle)elemStyle).icon, ((IconElemStyle)elemStyle).annotate, true);
            } else {
                this.drawNode((Node)osmPrimitive, this.selectedColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
            }
        }
        osmPrimitive.mappaintDrawnCode = paintid;
    }

    @Override
    public void visit(Relation relation) {
        relation.mappaintVisibleCode = 0;
        if (this.selectedCall.booleanValue()) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isNode() || relationMember.getMember().incomplete || relationMember.getMember().isDeleted() || relationMember.getMember().isFiltered()) continue;
                this.drawSelectedMember(relationMember.getMember(), this.styles != null ? this.getPrimitiveStyle(relationMember.getMember()) : null, true, true);
            }
            return;
        }
        if (this.drawMultipolygon && "multipolygon".equals(relation.get("type"))) {
            if (this.drawMultipolygon(relation).booleanValue()) {
                return;
            }
        } else if (this.drawRestriction && "restriction".equals(relation.get("type"))) {
            this.drawRestriction(relation);
        }
        if (relation.isSelected()) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isWay() || relationMember.getMember().incomplete || relationMember.getMember().isDeleted()) continue;
                this.drawSelectedMember(relationMember.getMember(), this.styles != null ? this.getPrimitiveStyle(relationMember.getMember()) : null, true, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawRestriction(Relation relation) {
        IconElemStyle iconElemStyle;
        void var6_12;
        Object object;
        Object object2;
        Object object3;
        relation.clearErrors();
        OsmPrimitive osmPrimitive = null;
        OsmPrimitive osmPrimitive2 = null;
        Object object5 = null;
        for (RelationMember object42 : relation.getMembers()) {
            if (object42.getMember().isDeleted()) {
                relation.putError(I18n.tr("Deleted member ''{0}'' in relation.", object42.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
                continue;
            }
            if (object42.getMember().incomplete) {
                return;
            }
            if (object42.isWay()) {
                object3 = object42.getWay();
                if (((Way)object3).getNodesCount() < 2) {
                    relation.putError(I18n.tr("Way ''{0}'' with less than two points.", ((Way)object3).getDisplayName(DefaultNameFormatter.getInstance())), true);
                    continue;
                }
                if ("from".equals(object42.getRole())) {
                    if (osmPrimitive != null) {
                        relation.putError(I18n.tr("More than one \"from\" way found."), true);
                        continue;
                    }
                    osmPrimitive = object3;
                    continue;
                }
                if ("to".equals(object42.getRole())) {
                    if (osmPrimitive2 != null) {
                        relation.putError(I18n.tr("More than one \"to\" way found."), true);
                        continue;
                    }
                    osmPrimitive2 = object3;
                    continue;
                }
                if ("via".equals(object42.getRole())) {
                    if (object5 != null) {
                        relation.putError(I18n.tr("More than one \"via\" found."), true);
                        continue;
                    }
                    object5 = object3;
                    continue;
                }
                relation.putError(I18n.tr("Unknown role ''{0}''.", object42.getRole()), true);
                continue;
            }
            if (object42.isNode()) {
                object3 = object42.getNode();
                if ("via".equals(object42.getRole())) {
                    if (object5 != null) {
                        relation.putError(I18n.tr("More than one \"via\" found."), true);
                        continue;
                    }
                    object5 = object3;
                    continue;
                }
                relation.putError(I18n.tr("Unknown role ''{0}''.", object42.getRole()), true);
                continue;
            }
            relation.putError(I18n.tr("Unknown member type for ''{0}''.", object42.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
        }
        if (osmPrimitive == null) {
            relation.putError(I18n.tr("No \"from\" way found."), true);
            return;
        }
        if (osmPrimitive2 == null) {
            relation.putError(I18n.tr("No \"to\" way found."), true);
            return;
        }
        if (object5 == null) {
            relation.putError(I18n.tr("No \"via\" node or way found."), true);
            return;
        }
        if (object5 instanceof Node) {
            object2 = (Node)object5;
            if (!((Way)osmPrimitive).isFirstLastNode((Node)object2)) {
                relation.putError(I18n.tr("The \"from\" way doesn't start or end at a \"via\" node."), true);
                return;
            }
            if (!osmPrimitive2.isFirstLastNode((Node)object2)) {
                relation.putError(I18n.tr("The \"to\" way doesn't start or end at a \"via\" node."), true);
            }
        } else {
            Way way = (Way)object5;
            object3 = way.firstNode();
            object = way.lastNode();
            Boolean bl = false;
            String string = way.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl = true;
                    object = object3 = object;
                } else {
                    bl = OsmUtils.getOsmBoolean(string);
                }
            }
            if (((Way)osmPrimitive).isFirstLastNode((Node)object3)) {
                object2 = object3;
            } else if (!bl.booleanValue() && ((Way)osmPrimitive).isFirstLastNode((Node)object)) {
                object2 = object;
            } else {
                relation.putError(I18n.tr("The \"from\" way doesn't start or end at the \"via\" way."), true);
                return;
            }
            if (!osmPrimitive2.isFirstLastNode((Node)(object2 == object3 ? object : object3))) {
                relation.putError(I18n.tr("The \"to\" way doesn't start or end at the \"via\" way."), true);
            }
        }
        Object var6_9 = null;
        if (((Way)osmPrimitive).firstNode() == object5) {
            Node node = ((Way)osmPrimitive).getNode(1);
        } else {
            Node node = ((Way)osmPrimitive).getNode(((Way)osmPrimitive).getNodesCount() - 2);
        }
        object3 = this.nc.getPoint((Node)var6_12);
        object = this.nc.getPoint((Node)object2);
        double d = 14.0;
        double d2 = ((Point)object3).x >= ((Point)object).x ? (double)(((Point)object3).x - ((Point)object).x) : (double)(((Point)object).x - ((Point)object3).x);
        double d3 = ((Point)object3).y >= ((Point)object).y ? (double)(((Point)object3).y - ((Point)object).y) : (double)(((Point)object).y - ((Point)object3).y);
        double d4 = d2 == 0.0 ? 1.5707963267948966 : Math.atan(d3 / d2);
        double d5 = Math.toDegrees(d4);
        double d6 = d * Math.cos(d4);
        double d7 = d * Math.sin(d4);
        if (((Point)object3).x < ((Point)object).x) {
            d6 = -d6;
        }
        if (((Point)object3).y < ((Point)object).y) {
            d7 = -d7;
        }
        double d8 = 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            }
            d11 = 270.0 + d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            }
            d11 = 90.0 - d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            }
            d11 = 90.0 + d5;
        }
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            }
            d11 = 270.0 - d5;
        }
        if ((iconElemStyle = this.getPrimitiveNodeStyle(relation)) == null) {
            relation.putError(I18n.tr("Style for restriction {0} not found.", relation.get("restriction")), true);
            return;
        }
        ImageIcon imageIcon = ImageProvider.createRotatedImage(null, iconElemStyle.icon, d11);
        ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        int n = imageIcon2.getIconWidth();
        int n2 = imageIcon2.getIconHeight();
        imageIcon2.paintIcon(Main.map.mapView, this.g, (int)((double)((Point)object).x + d6 + d9) - n / 2, (int)((double)((Point)object).y + d7 + d10) - n2 / 2);
        if (relation.isSelected()) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect((int)((double)((Point)object).x + d6 + d9) - n / 2 - 2, (int)((double)((Point)object).y + d7 + d10) - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    public Boolean drawMultipolygon(Relation relation) {
        Comparable<OsmPrimitive> comparable22;
        Object object;
        LinkedList<Comparable<OsmPrimitive>> linkedList = new LinkedList<Comparable<OsmPrimitive>>();
        LinkedList<Comparable<OsmPrimitive>> linkedList2 = new LinkedList<Comparable<OsmPrimitive>>();
        LinkedList<Way> linkedList3 = new LinkedList<Way>();
        LinkedList<Way> linkedList4 = new LinkedList<Way>();
        Boolean bl = false;
        Boolean bl2 = false;
        relation.clearErrors();
        Object object2 = relation.getMembers().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((RelationMember)object).getMember().isDeleted()) {
                relation.putError(I18n.tr("Deleted member ''{0}'' in relation.", ((RelationMember)object).getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
                continue;
            }
            if (((RelationMember)object).getMember().incomplete) {
                bl = true;
                continue;
            }
            if (((RelationMember)object).isWay()) {
                comparable22 = ((RelationMember)object).getWay();
                if (((Way)comparable22).getNodesCount() < 2) {
                    relation.putError(I18n.tr("Way ''{0}'' with less than two points.", ((Way)comparable22).getDisplayName(DefaultNameFormatter.getInstance())), true);
                    continue;
                }
                if ("inner".equals(((RelationMember)object).getRole())) {
                    linkedList.add(comparable22);
                    continue;
                }
                if ("outer".equals(((RelationMember)object).getRole())) {
                    linkedList2.add(comparable22);
                    continue;
                }
                relation.putError(I18n.tr("No useful role ''{0}'' for Way ''{1}''.", ((RelationMember)object).getRole(), ((Way)comparable22).getDisplayName(DefaultNameFormatter.getInstance())), true);
                if (!((RelationMember)object).hasRole()) {
                    linkedList2.add(comparable22);
                    continue;
                }
                if (!relation.isSelected()) continue;
                this.drawSelectedMember(((RelationMember)object).getMember(), this.styles != null ? this.getPrimitiveStyle(((RelationMember)object).getMember()) : null, true, true);
                continue;
            }
            relation.putError(I18n.tr("Non-Way ''{0}'' in multipolygon.", ((RelationMember)object).getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
        }
        Object object3 = object2 = this.styles != null ? this.getPrimitiveStyle(relation) : null;
        if (!(this.styles == null || object2 != null && object2 instanceof AreaElemStyle)) {
            for (Comparable<OsmPrimitive> comparable22 : linkedList2) {
                if (object2 != null) continue;
                object2 = this.styles.getArea((Way)comparable22);
            }
            relation.mappaintStyle = object2;
        }
        if (object2 != null && object2 instanceof AreaElemStyle) {
            object = this.isZoomOk((ElemStyle)object2);
            comparable22 = false;
            LinkedList<Way> linkedList5 = new LinkedList<Way>();
            bl2 = true;
            for (Way object5 : linkedList2) {
                if (object5.isClosed()) {
                    linkedList4.add(object5);
                    continue;
                }
                linkedList5.add(object5);
            }
            if (linkedList5.size() != 0) {
                for (Way way : this.joinWays(linkedList5, bl != false ? null : relation)) {
                    linkedList4.add(way);
                }
            }
            linkedList5.clear();
            for (Way way : linkedList) {
                if (way.isClosed()) {
                    linkedList3.add(way);
                    continue;
                }
                linkedList5.add(way);
            }
            if (linkedList5.size() != 0) {
                for (Way way : this.joinWays(linkedList5, bl != false ? null : relation)) {
                    linkedList3.add(way);
                }
            }
            if (linkedList4.size() == 0) {
                relation.putError(I18n.tr("No outer way for multipolygon ''{0}''.", relation.getDisplayName(DefaultNameFormatter.getInstance())), true);
                comparable22 = true;
            } else if (((Boolean)object).booleanValue()) {
                Object object4;
                Object object5;
                class PolyData {
                    public Polygon poly = new Polygon();
                    public Way way;
                    private Point p = null;
                    private Collection<Polygon> inner = null;

                    PolyData(Way way) {
                        this.way = way;
                        for (Node node : way.getNodes()) {
                            this.p = MapPaintVisitor.this.nc.getPoint(node);
                            this.poly.addPoint(this.p.x, this.p.y);
                        }
                    }

                    public int contains(Polygon polygon) {
                        int n = polygon.npoints;
                        for (int i = 0; i < polygon.npoints; ++i) {
                            if (!this.poly.contains(polygon.xpoints[i], polygon.ypoints[i])) continue;
                            --n;
                        }
                        if (n == 0) {
                            return 1;
                        }
                        if (n == polygon.npoints) {
                            return 0;
                        }
                        return 2;
                    }

                    public void addInner(Polygon polygon) {
                        if (this.inner == null) {
                            this.inner = new ArrayList<Polygon>();
                        }
                        this.inner.add(polygon);
                    }

                    public boolean isClosed() {
                        return this.poly.npoints >= 3 && this.poly.xpoints[0] == this.poly.xpoints[this.poly.npoints - 1] && this.poly.ypoints[0] == this.poly.ypoints[this.poly.npoints - 1];
                    }

                    public Polygon get() {
                        if (this.inner != null) {
                            for (Polygon polygon : this.inner) {
                                for (int i = 0; i < polygon.npoints; ++i) {
                                    this.poly.addPoint(polygon.xpoints[i], polygon.ypoints[i]);
                                }
                                this.poly.addPoint(this.p.x, this.p.y);
                            }
                            this.inner = null;
                        }
                        return this.poly;
                    }
                }
                Iterator<PolyData> iterator = new LinkedList();
                for (Way way : linkedList4) {
                    ((LinkedList)((Object)iterator)).add(new PolyData(way));
                }
                for (Way way : linkedList3) {
                    Object object6;
                    object5 = new Polygon();
                    for (Node node : way.getNodes()) {
                        object6 = this.nc.getPoint(node);
                        ((Polygon)object5).addPoint(((Point)object6).x, ((Point)object6).y);
                    }
                    if (!way.isClosed()) {
                        object4 = this.nc.getPoint(way.getNode(0));
                        ((Polygon)object5).addPoint(((Point)object4).x, ((Point)object4).y);
                    }
                    object4 = null;
                    Iterator iterator2 = ((AbstractSequentialList)((Object)iterator)).iterator();
                    while (iterator2.hasNext()) {
                        object6 = (PolyData)iterator2.next();
                        Integer n = ((PolyData)object6).contains((Polygon)object5);
                        if (n < 1) continue;
                        if (n > 1 && ((PolyData)object6).way.isClosed()) {
                            relation.putError(I18n.tr("Intersection between ways ''{0}'' and ''{1}''.", ((PolyData)object6).way.getDisplayName(DefaultNameFormatter.getInstance()), way.getDisplayName(DefaultNameFormatter.getInstance())), true);
                        }
                        if (object4 != null && ((PolyData)object4).contains(((PolyData)object6).poly) <= 0) continue;
                        object4 = object6;
                    }
                    if (object4 == null) {
                        if (!bl.booleanValue()) {
                            relation.putError(I18n.tr("Inner way ''{0}'' is outside.", way.getDisplayName(DefaultNameFormatter.getInstance())), true);
                        }
                        object4 = (PolyData)((LinkedList)((Object)iterator)).get(0);
                    }
                    ((PolyData)object4).addInner((Polygon)object5);
                }
                AreaElemStyle areaElemStyle = (AreaElemStyle)object2;
                Iterator iterator3 = ((AbstractSequentialList)((Object)iterator)).iterator();
                while (iterator3.hasNext()) {
                    object5 = (PolyData)iterator3.next();
                    object4 = ((PolyData)object5).get();
                    if (!this.isPolygonVisible((Polygon)object4)) continue;
                    this.drawAreaPolygon((Polygon)object4, ((PolyData)object5).way.isSelected() || relation.isSelected() ? this.selectedColor : areaElemStyle.color);
                    comparable22 = true;
                }
            }
            if (!((Boolean)comparable22).booleanValue()) {
                relation.mappaintVisibleCode = viewid;
                for (Way way : linkedList) {
                    way.mappaintVisibleCode = viewid;
                }
                for (Way way : linkedList2) {
                    way.mappaintVisibleCode = viewid;
                }
                return bl2;
            }
            for (Way way : linkedList) {
                ElemStyle elemStyle = this.getPrimitiveStyle(way);
                if (elemStyle == null) {
                    if (((Boolean)object).booleanValue() && (way.mappaintDrawnCode != paintid || linkedList2.size() == 0)) {
                        this.drawWay(way, ((AreaElemStyle)object2).line, ((AreaElemStyle)object2).color, way.isSelected() || relation.isSelected());
                    }
                    way.mappaintDrawnCode = paintid;
                    continue;
                }
                if (relation.isSelected()) {
                    this.drawSelectedMember(way, elemStyle, ((ElemStyle)object2).equals(elemStyle) == false, way.isSelected());
                }
                if (!((ElemStyle)object2).equals(elemStyle).booleanValue()) continue;
                relation.putError(I18n.tr("Style for inner way ''{0}'' equals multipolygon.", way.getDisplayName(DefaultNameFormatter.getInstance())), false);
                if (relation.isSelected()) continue;
                way.mappaintDrawnAreaCode = paintid;
            }
            for (Way way : linkedList2) {
                ElemStyle elemStyle = this.getPrimitiveStyle(way);
                if (elemStyle == null) {
                    if (((Boolean)object).booleanValue()) {
                        this.drawWay(way, ((AreaElemStyle)object2).line, ((AreaElemStyle)object2).color, way.isSelected() || relation.isSelected());
                    }
                    way.mappaintDrawnCode = paintid;
                    continue;
                }
                if (elemStyle instanceof AreaElemStyle && !((ElemStyle)object2).equals(elemStyle).booleanValue()) {
                    relation.putError(I18n.tr("Style for outer way ''{0}'' mismatches.", way.getDisplayName(DefaultNameFormatter.getInstance())), true);
                }
                if (relation.isSelected()) {
                    this.drawSelectedMember(way, elemStyle, false, false);
                    continue;
                }
                if (!(elemStyle instanceof AreaElemStyle)) continue;
                way.mappaintDrawnAreaCode = paintid;
            }
        }
        return bl2;
    }

    protected Polygon getPolygon(Way way) {
        Polygon polygon = new Polygon();
        for (Node node : way.getNodes()) {
            Point point = this.nc.getPoint(node);
            polygon.addPoint(point.x, point.y);
        }
        return polygon;
    }

    protected void drawArea(Way way, Color color) {
        Polygon polygon = this.getPolygon(way);
        this.g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        this.g.fillPolygon(polygon);
    }

    protected void drawAreaPolygon(Polygon polygon, Color color) {
        this.g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        this.g.fillPolygon(polygon);
    }

    protected void drawNode(Node node, ImageIcon imageIcon, boolean bl, Boolean bl2) {
        String string;
        Point point = this.nc.getPoint(node);
        if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
            return;
        }
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        imageIcon.paintIcon(Main.map.mapView, this.g, point.x - n / 2, point.y - n2 / 2);
        if ((double)this.showNames > this.dist && (string = this.getNodeName(node)) != null && bl) {
            this.g.setColor(this.textColor);
            Font font = this.g.getFont();
            this.g.setFont(this.orderFont);
            this.g.drawString(string, point.x + n / 2 + 2, point.y + n2 / 2 + 2);
            this.g.setFont(font);
        }
        if (bl2.booleanValue()) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect(point.x - n / 2 - 2, point.y - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    protected String getNodeName(Node node) {
        String string;
        block1: {
            String string2;
            string = null;
            if (!node.hasKeys()) break block1;
            Iterator<String> iterator = this.regionalNameOrder.iterator();
            while (iterator.hasNext() && (string = node.get(string2 = iterator.next())) == null) {
            }
        }
        return string;
    }

    private void drawSeg(Node node, Node node2, Color color, boolean bl, int n, float[] fArray, Color color2) {
        Point point;
        Point point2;
        if (color != this.currentColor || n != this.currentWidth || !Arrays.equals(fArray, this.currentDashed) || color2 != this.currentDashedColor) {
            this.displaySegments(color, n, fArray, color2);
        }
        if (!this.isSegmentVisible(point2 = this.nc.getPoint(node), point = this.nc.getPoint(node2))) {
            return;
        }
        this.currentPath.moveTo(point2.x, point2.y);
        this.currentPath.lineTo(point.x, point.y);
        if (bl) {
            double d = Math.atan2(point.y - point2.y, point.x - point2.x) + Math.PI;
            this.currentPath.lineTo((int)((double)point.x + 10.0 * Math.cos(d - PHI)), (int)((double)point.y + 10.0 * Math.sin(d - PHI)));
            this.currentPath.moveTo((int)((double)point.x + 10.0 * Math.cos(d + PHI)), (int)((double)point.y + 10.0 * Math.sin(d + PHI)));
            this.currentPath.lineTo(point.x, point.y);
        }
    }

    @Override
    protected void displaySegments() {
        this.displaySegments(null, 0, new float[0], null);
    }

    protected void displaySegments(Color color, int n, float[] fArray, Color color2) {
        if (this.currentPath != null) {
            Graphics2D graphics2D = (Graphics2D)this.g;
            graphics2D.setColor(this.inactive ? this.inactiveColor : this.currentColor);
            if (this.currentStroke == null && (double)this.useStrokes > this.dist) {
                if (this.currentDashed.length > 0) {
                    try {
                        graphics2D.setStroke(new BasicStroke(this.currentWidth, 0, 1, 0.0f, this.currentDashed, 0.0f));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        graphics2D.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                    }
                } else {
                    graphics2D.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                }
            }
            graphics2D.draw(this.currentPath);
            if (this.currentDashedColor != null) {
                graphics2D.setColor(this.currentDashedColor);
                if (this.currentStroke == null && (double)this.useStrokes > this.dist) {
                    if (this.currentDashed.length > 0) {
                        float[] fArray2 = new float[this.currentDashed.length];
                        System.arraycopy(this.currentDashed, 1, fArray2, 0, this.currentDashed.length - 1);
                        fArray2[this.currentDashed.length - 1] = this.currentDashed[0];
                        float f = fArray2[0];
                        try {
                            graphics2D.setStroke(new BasicStroke(this.currentWidth, 0, 1, 0.0f, fArray2, f));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            graphics2D.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                        }
                    } else {
                        graphics2D.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                    }
                }
                graphics2D.draw(this.currentPath);
            }
            if ((double)this.useStrokes > this.dist) {
                graphics2D.setStroke(new BasicStroke(1.0f));
            }
            this.currentPath = new GeneralPath();
            this.currentColor = color;
            this.currentWidth = n;
            this.currentDashed = fArray;
            this.currentDashedColor = color2;
            this.currentStroke = null;
        }
    }

    @Override
    public void drawNode(Node node, Color color, int n, int n2, boolean bl) {
        if (this.isZoomOk(null) && n > 1) {
            String string;
            Point point = this.nc.getPoint(node);
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (bl) {
                this.g.fillRect(point.x - n2, point.y - n2, n, n);
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            } else {
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            }
            if ((double)this.showNames > this.dist && (string = this.getNodeName(node)) != null) {
                this.g.setColor(this.textColor);
                Font font = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(string, point.x + n2 + 2, point.y + n2 + 2);
                this.g.setFont(font);
            }
        }
    }

    @Override
    public void getColors() {
        super.getColors();
        this.untaggedColor = Main.pref.getColor(I18n.marktr("untagged"), Color.GRAY);
        this.textColor = Main.pref.getColor(I18n.marktr("text"), Color.WHITE);
    }

    @Override
    public void visitAll(DataSet dataSet, Boolean bl) {
        this.useStyleCache = Main.pref.getBoolean("mappaint.cache", true);
        this.fillAreas = Main.pref.getInteger("mappaint.fillareas", 10000000);
        this.fillAlpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
        this.showNames = Main.pref.getInteger("mappaint.shownames", 10000000);
        this.showIcons = Main.pref.getInteger("mappaint.showicons", 10000000);
        this.useStrokes = Main.pref.getInteger("mappaint.strokes", 10000000);
        LatLon latLon = this.nc.getLatLon(0, 0);
        LatLon latLon2 = this.nc.getLatLon(100, 0);
        this.dist = latLon.greatCircleDistance(latLon2);
        this.getSettings(bl);
        this.useRealWidth = Main.pref.getBoolean("mappaint.useRealWidth", false);
        this.zoomLevelDisplay = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        this.circum = Main.map.mapView.getDist100Pixel();
        this.styles = MapPaintStyles.getStyles().getStyleSet();
        this.drawMultipolygon = Main.pref.getBoolean("mappaint.multipolygon", true);
        this.drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Helvetica"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        String[] stringArray = new String[]{"name:" + LanguageInfo.getLanguageCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        this.regionalNameOrder = Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(stringArray));
        this.minEN = this.nc.getEastNorth(0, this.nc.getHeight() - 1);
        this.maxEN = this.nc.getEastNorth(this.nc.getWidth() - 1, 0);
        this.selectedCall = false;
        ++paintid;
        viewid = this.nc.getViewID();
        if ((double)this.fillAreas > this.dist && this.styles != null && this.styles.hasAreas()) {
            Iterator<OsmPrimitive> iterator = new LinkedList();
            for (Relation relation : dataSet.relations) {
                if (relation.isDeleted() || relation.isFiltered() || relation.incomplete || relation.mappaintVisibleCode == viewid) continue;
                relation.visit(this);
            }
            for (Way way : dataSet.ways) {
                if (way.incomplete || way.isDeleted() || way.isFiltered() || way.mappaintVisibleCode == viewid || way.mappaintDrawnCode == paintid) continue;
                if (this.isPrimitiveArea(way) && way.mappaintDrawnAreaCode != paintid) {
                    way.visit(this);
                    continue;
                }
                iterator.add(way);
            }
            this.fillAreas = 0;
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Way way = (Way)iterator2.next();
                ((OsmPrimitive)way).visit(this);
            }
        } else {
            for (Way way : dataSet.ways) {
                if (way.incomplete || way.isDeleted() || way.isFiltered() || way.isSelected() || way.mappaintVisibleCode == viewid) continue;
                ((OsmPrimitive)way).visit(this);
            }
        }
        this.selectedCall = true;
        for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
            if (osmPrimitive.incomplete || osmPrimitive.isDeleted() || osmPrimitive instanceof Node || osmPrimitive.mappaintVisibleCode == viewid || osmPrimitive.mappaintDrawnCode == paintid) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (Node node : dataSet.nodes) {
            if (node.incomplete || node.isDeleted() || !node.isSelected() && node.isFiltered() || node.mappaintVisibleCode == viewid || node.mappaintDrawnCode == paintid) continue;
            ((OsmPrimitive)node).visit(this);
        }
        if (this.virtualNodeSize != 0) {
            this.currentColor = this.nodeColor;
            for (Way way : dataSet.ways) {
                if (!way.isUsable() || way.isFiltered() || way.mappaintVisibleCode == viewid) continue;
                this.visitVirtual(way);
            }
            this.displaySegments(null);
        }
    }

    protected void drawOrderNumber(Node node, Node node2, int n) {
        Point point = this.nc.getPoint(node);
        Point point2 = this.nc.getPoint(node2);
        this.drawOrderNumber(point, point2, n);
    }
}

