/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOsmChangeVisitor
extends AbstractVisitor {
    private String currentMode;
    private PrintWriter writer;
    private StringWriter swriter = new StringWriter();
    private OsmWriter osmwriter;
    private OsmApi api;

    public CreateOsmChangeVisitor(Changeset changeset, OsmApi osmApi) {
        this.writer = new PrintWriter(this.swriter);
        this.writer.write("<osmChange version=\"");
        this.writer.write(osmApi.getVersion());
        this.writer.write("\" generator=\"JOSM\">\n");
        this.api = osmApi;
        this.osmwriter = new OsmWriter(this.writer, false, osmApi.getVersion());
        this.osmwriter.setChangeset(changeset);
    }

    @Override
    public void visit(Node node) {
        if (node.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            this.osmwriter.visit(node);
        } else {
            this.switchMode(node.getId() == 0L ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            this.osmwriter.visit(node);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            this.osmwriter.visit(way);
        } else {
            this.switchMode(way.getId() == 0L ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            this.osmwriter.visit(way);
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            this.osmwriter.visit(relation);
        } else {
            this.switchMode(relation.getId() == 0L ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            this.osmwriter.visit(relation);
        }
    }

    private void switchMode(String string) {
        if (string != null && !string.equals(this.currentMode) || string == null && this.currentMode != null) {
            if (this.currentMode != null) {
                this.writer.write("</");
                this.writer.write(this.currentMode);
                this.writer.write(">\n");
            }
            if (string != null) {
                this.writer.write("<");
                this.writer.write(string);
                this.writer.write(" version=\"");
                this.writer.write(this.api.getVersion());
                this.writer.write("\" generator=\"JOSM\">\n");
            }
            this.currentMode = string;
        }
    }

    public String getDocument() {
        this.switchMode(null);
        return this.swriter.toString() + "</osmChange>\n";
    }

    public Map<OsmPrimitive, Long> getNewIdMap() {
        return this.osmwriter.usedNewIds;
    }
}

