/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectBackReferencesVisitor
extends AbstractVisitor {
    private final DataSet ds;
    private final boolean indirectRefs;
    private Collection<OsmPrimitive> data = new HashSet<OsmPrimitive>();
    private Map<OsmPrimitive, Collection<OsmPrimitive>> lookupTable = new HashMap<OsmPrimitive, Collection<OsmPrimitive>>();

    public CollectBackReferencesVisitor(DataSet dataSet) {
        this(dataSet, true);
    }

    public CollectBackReferencesVisitor(DataSet dataSet, boolean bl) {
        this.ds = dataSet;
        this.indirectRefs = bl;
        if (dataSet != null) {
            this.makeLookupTable();
        }
    }

    private void makeLookupTable() {
        for (Way osmPrimitive : this.ds.ways) {
            for (Node node : osmPrimitive.getNodes()) {
                if (!this.lookupTable.containsKey(node)) {
                    this.lookupTable.put(node, new HashSet());
                }
                this.lookupTable.get(node).add(osmPrimitive);
            }
        }
        for (Relation relation : this.ds.relations) {
            for (RelationMember relationMember : relation.getMembers()) {
                OsmPrimitive osmPrimitive = relationMember.getMember();
                if (!this.lookupTable.containsKey(osmPrimitive)) {
                    this.lookupTable.put(osmPrimitive, new HashSet());
                }
                this.lookupTable.get(osmPrimitive).add(relation);
            }
        }
    }

    public Collection<OsmPrimitive> getData() {
        return this.data;
    }

    public void initialize() {
        this.data = new HashSet<OsmPrimitive>();
    }

    public void visit(OsmPrimitive osmPrimitive) {
        if (this.lookupTable.containsKey(osmPrimitive)) {
            Collection<OsmPrimitive> collection = this.lookupTable.get(osmPrimitive);
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(this.data);
            this.data.addAll(collection);
            if (this.indirectRefs) {
                for (OsmPrimitive osmPrimitive2 : collection) {
                    if (hashSet.contains(osmPrimitive2)) continue;
                    this.visit(osmPrimitive2);
                }
            }
        }
    }

    @Override
    public void visit(Node node) {
        this.visit((OsmPrimitive)node);
    }

    @Override
    public void visit(Way way) {
        this.visit((OsmPrimitive)way);
    }

    @Override
    public void visit(Relation relation) {
        this.visit((OsmPrimitive)relation);
    }
}

