/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Relation
extends OsmPrimitive {
    private final List<RelationMember> members = new ArrayList<RelationMember>();

    public List<RelationMember> getMembers() {
        return new CopyList<RelationMember>(this.members.toArray(new RelationMember[this.members.size()]));
    }

    public void setMembers(List<RelationMember> list) {
        this.members.clear();
        if (list != null) {
            this.members.addAll(list);
        }
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public RelationMember getMember(int n) {
        return this.members.get(n);
    }

    public void addMember(RelationMember relationMember) {
        this.members.add(relationMember);
    }

    public void addMember(int n, RelationMember relationMember) {
        this.members.add(n, relationMember);
    }

    public RelationMember setMember(int n, RelationMember relationMember) {
        return this.members.set(n, relationMember);
    }

    public RelationMember removeMember(int n) {
        return this.members.remove(n);
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public Relation() {
        super(0L);
    }

    public Relation(Relation relation) {
        super(relation.getId());
        this.cloneFrom(relation);
    }

    public Relation(long l) throws IllegalArgumentException {
        super(l);
    }

    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.members.clear();
        for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
            this.members.add(new RelationMember(relationMember));
        }
    }

    public String toString() {
        return "{Relation id=" + this.getId() + " version=" + this.getVersion() + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Relation)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Relation relation = (Relation)osmPrimitive;
        return ((Object)this.members).equals(relation.members);
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Relation ? Long.valueOf(this.getId()).compareTo(osmPrimitive.getId()) : -1;
    }

    public boolean isIncomplete() {
        for (RelationMember relationMember : this.members) {
            if (relationMember.getMember() != null) continue;
            return true;
        }
        return false;
    }

    public RelationMember firstMember() {
        if (this.incomplete) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(0);
    }

    public RelationMember lastMember() {
        if (this.incomplete) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(this.members.size() - 1);
    }

    public void removeMembersFor(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return;
        }
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMember relationMember : this.members) {
            if (relationMember.getMember() != osmPrimitive) continue;
            arrayList.add(relationMember);
        }
        this.members.removeAll(arrayList);
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.members) {
            if (relationMember.getMember() == null) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }
}

