/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OsmPrimitiveType {
    NODE("node"),
    WAY("way"),
    RELATION("relation");

    private String apiTypeName;

    private OsmPrimitiveType(String string2) {
        this.apiTypeName = string2;
    }

    public String getAPIName() {
        return this.apiTypeName;
    }

    public static OsmPrimitiveType fromApiTypeName(String string) {
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equals(string)) continue;
            return osmPrimitiveType;
        }
        throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' is not a valid type name. Got ''{1}''.", "typeName", string));
    }

    public static OsmPrimitiveType from(OsmPrimitive osmPrimitive) {
        return OsmPrimitiveType.from(osmPrimitive.getClass());
    }

    public static OsmPrimitiveType from(Class clazz) {
        if (clazz.equals(Node.class)) {
            return NODE;
        }
        if (clazz.equals(Way.class)) {
            return WAY;
        }
        if (clazz.equals(Relation.class)) {
            return RELATION;
        }
        throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' is not an acceptable class. Got ''{1}''.", "cls", clazz.toString()));
    }

    public static OsmPrimitiveType from(String string) {
        if (string == null) {
            return null;
        }
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equalsIgnoreCase(string)) continue;
            return osmPrimitiveType;
        }
        return null;
    }
}

