/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class Filters
extends AbstractTableModel {
    public int disabledCount;
    public int hiddenCount;
    private List<Filter> filters = new LinkedList<Filter>();

    public Filters() {
        this.loadPrefs();
    }

    public void filter() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        LinkedList<OsmPrimitive> linkedList2 = new LinkedList<OsmPrimitive>();
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Main.main.getCurrentDataSet().setFiltered(new OsmPrimitive[0]);
        Main.main.getCurrentDataSet().setDisabled(new OsmPrimitive[0]);
        for (Filter filter : this.filters) {
            if (!filter.enable.booleanValue()) continue;
            SearchAction.getSelection(filter, linkedList, new SearchAction.Function(){

                public Boolean isSomething(OsmPrimitive osmPrimitive) {
                    return osmPrimitive.isDisabled();
                }
            });
            if (!filter.hide.booleanValue()) continue;
            SearchAction.getSelection(filter, linkedList2, new SearchAction.Function(){

                public Boolean isSomething(OsmPrimitive osmPrimitive) {
                    return osmPrimitive.isFiltered();
                }
            });
        }
        this.disabledCount = linkedList.size() - linkedList2.size();
        this.hiddenCount = linkedList2.size();
        Main.main.getCurrentDataSet().setFiltered(linkedList2);
        Main.main.getCurrentDataSet().setDisabled(linkedList);
        Main.map.mapView.repaint();
    }

    private void loadPrefs() {
        Map<String, String> map = Main.pref.getAllPrefix("filters.filter");
        for (String string : map.values()) {
            Filter filter = new Filter(string);
            if (filter == null) continue;
            this.filters.add(filter);
        }
    }

    private void savePrefs() {
        Map<String, String> map = Main.pref.getAllPrefix("filters.filter");
        for (String object : map.keySet()) {
            String[] stringArray = object.split("\\.");
            if (stringArray.length != 3) {
                throw new Error("Incompatible filter preferences");
            }
            Main.pref.put("filters.filter." + stringArray[2], null);
        }
        int n = 0;
        for (Filter filter : this.filters) {
            Main.pref.put("filters.filter." + n++, filter.getPrefString());
        }
    }

    private void savePref(int n) {
        if (n >= this.filters.size()) {
            Main.pref.put("filters.filter." + n, null);
        } else {
            Main.pref.put("filters.filter." + n, this.filters.get(n).getPrefString());
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        this.savePref(this.filters.size() - 1);
        this.filter();
        this.fireTableRowsInserted(this.filters.size() - 1, this.filters.size() - 1);
    }

    public void moveDownFilter(int n) {
        if (n >= this.filters.size() - 1) {
            return;
        }
        this.filters.add(n + 1, this.filters.remove(n));
        this.savePref(n);
        this.savePref(n + 1);
        this.filter();
        this.fireTableRowsUpdated(n, n + 1);
    }

    public void moveUpFilter(int n) {
        if (n == 0) {
            return;
        }
        this.filters.add(n - 1, this.filters.remove(n));
        this.savePref(n);
        this.savePref(n - 1);
        this.filter();
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void removeFilter(int n) {
        this.filters.remove(n);
        this.savePrefs();
        this.filter();
        this.fireTableRowsDeleted(n, n);
    }

    public void setFilter(int n, Filter filter) {
        this.filters.set(n, filter);
        this.savePref(n);
        this.filter();
        this.fireTableRowsUpdated(n, n);
    }

    public Filter getFilter(int n) {
        return this.filters.get(n);
    }

    public int getRowCount() {
        return this.filters.size();
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int n) {
        String[] stringArray = new String[]{I18n.trc("filter", "E"), I18n.tr("H"), I18n.tr("Text"), I18n.tr("C"), I18n.tr("I"), I18n.tr("M")};
        return stringArray[n];
    }

    public Class getColumnClass(int n) {
        Class[] classArray = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, Boolean.class, String.class};
        return classArray[n];
    }

    public boolean isCellEnabled(int n, int n2) {
        return this.filters.get((int)n).enable != false || n2 == 0;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.filters.get((int)n).enable.booleanValue() && n2 != 0) {
            return false;
        }
        return n2 < 5;
    }

    public void setValueAt(Object object, int n, int n2) {
        Filter filter = this.filters.get(n);
        switch (n2) {
            case 0: {
                filter.enable = (Boolean)object;
                this.savePref(n);
                this.filter();
                this.fireTableRowsUpdated(n, n);
                break;
            }
            case 1: {
                filter.hide = (Boolean)object;
                this.savePref(n);
                this.filter();
                break;
            }
            case 2: {
                filter.text = (String)object;
                this.savePref(n);
                break;
            }
            case 3: {
                filter.applyForChildren = (Boolean)object;
                this.savePref(n);
                this.filter();
                break;
            }
            case 4: {
                filter.inverted = (Boolean)object;
                this.savePref(n);
                this.filter();
            }
        }
        if (n2 != 0) {
            this.fireTableCellUpdated(n, n2);
        }
    }

    public Object getValueAt(int n, int n2) {
        Filter filter = this.filters.get(n);
        switch (n2) {
            case 0: {
                return filter.enable;
            }
            case 1: {
                return filter.hide;
            }
            case 2: {
                return filter.text;
            }
            case 3: {
                return filter.applyForChildren;
            }
            case 4: {
                return filter.inverted;
            }
            case 5: {
                switch (filter.mode) {
                    case replace: {
                        return I18n.tr("R");
                    }
                    case add: {
                        return I18n.tr("A");
                    }
                    case remove: {
                        return I18n.tr("D");
                    }
                    case in_selection: {
                        return I18n.tr("F");
                    }
                }
            }
        }
        return null;
    }
}

