/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.data.coor.LatLon;

public class Bounds {
    public LatLon min;
    public LatLon max;

    public Bounds(LatLon latLon, LatLon latLon2) {
        this.min = latLon;
        this.max = latLon2;
    }

    public Bounds(LatLon latLon) {
        this.min = latLon;
        this.max = latLon;
    }

    public String toString() {
        return "Bounds[" + this.min.lat() + "," + this.min.lon() + "," + this.max.lat() + "," + this.max.lon() + "]";
    }

    public LatLon getCenter() {
        return this.min.getCenter(this.max);
    }

    public void extend(LatLon latLon) {
        if (latLon.lat() < this.min.lat() || latLon.lon() < this.min.lon()) {
            this.min = new LatLon(Math.min(latLon.lat(), this.min.lat()), Math.min(latLon.lon(), this.min.lon()));
        }
        if (latLon.lat() > this.max.lat() || latLon.lon() > this.max.lon()) {
            this.max = new LatLon(Math.max(latLon.lat(), this.max.lat()), Math.max(latLon.lon(), this.max.lon()));
        }
    }

    public boolean contains(LatLon latLon) {
        if (latLon.lat() < this.min.lat() || latLon.lon() < this.min.lon()) {
            return false;
        }
        return !(latLon.lat() > this.max.lat()) && !(latLon.lon() > this.max.lon());
    }

    public Rectangle2D.Double asRect() {
        return new Rectangle2D.Double(this.min.lon(), this.min.lat(), this.max.lon() - this.min.lon(), this.max.lat() - this.min.lat());
    }
}

