/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class SearchCompiler {
    private boolean caseSensitive = false;
    private boolean regexSearch = false;
    private String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private PushbackTokenizer tokenizer;
    private static CollectBackReferencesVisitor childBackRefs;

    public SearchCompiler(boolean bl, boolean bl2, PushbackTokenizer pushbackTokenizer) {
        this.caseSensitive = bl;
        this.regexSearch = bl2;
        this.tokenizer = pushbackTokenizer;
        childBackRefs = new CollectBackReferencesVisitor(Main.main.getCurrentDataSet());
    }

    public static Match compile(String string, boolean bl, boolean bl2) throws ParseError {
        return new SearchCompiler(bl, bl2, new PushbackTokenizer(new PushbackReader(new StringReader(string)))).parse();
    }

    public Match parse() throws ParseError {
        Match match = this.parseJuxta();
        if (!this.tokenizer.readIfEqual(null)) {
            throw new ParseError(I18n.tr("Unexpected token: {0}", this.tokenizer.nextToken()));
        }
        return match;
    }

    private Match parseJuxta() throws ParseError {
        Match match;
        Match match2 = new Always();
        while ((match = this.parseOr()) != null) {
            match2 = new And(match, match2);
        }
        return match2;
    }

    private Match parseOr() throws ParseError {
        Match match = this.parseNot();
        if (this.tokenizer.readIfEqual("|")) {
            Match match2 = this.parseNot();
            if (match == null || match2 == null) {
                throw new ParseError(I18n.tr("Missing arguments for or."));
            }
            return new Or(match, match2);
        }
        return match;
    }

    private Match parseNot() throws ParseError {
        if (this.tokenizer.readIfEqual("-")) {
            Match match = this.parseParens();
            if (match == null) {
                throw new ParseError(I18n.tr("Missing argument for not."));
            }
            return new Not(match);
        }
        return this.parseParens();
    }

    private Match parseParens() throws ParseError {
        if (this.tokenizer.readIfEqual("(")) {
            Match match = this.parseJuxta();
            if (!this.tokenizer.readIfEqual(")")) {
                throw new ParseError(I18n.tr("Expected closing parenthesis."));
            }
            return match;
        }
        return this.parsePat();
    }

    private Match parsePat() throws ParseError {
        String string = this.tokenizer.readText();
        if (this.tokenizer.readIfEqual(":")) {
            String string2 = this.tokenizer.readText();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return this.parseKV(string, string2);
        }
        if (this.tokenizer.readIfEqual("=")) {
            String string3 = this.tokenizer.readText();
            if (string == null) {
                string = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            return new ExactKeyValue(this.regexSearch, string, string3);
        }
        if (string == null) {
            return null;
        }
        if (string.equals("modified")) {
            return new Modified();
        }
        if (string.equals("incomplete")) {
            return new Incomplete();
        }
        if (string.equals("untagged")) {
            return new Untagged();
        }
        if (string.equals("selected")) {
            return new Selected();
        }
        if (string.equals("child")) {
            return new Child(this.parseParens());
        }
        if (string.equals("parent")) {
            return new Parent(this.parseParens());
        }
        return new Any(string);
    }

    private Match parseKV(String string, String string2) throws ParseError {
        if (string.equals("type")) {
            return new ExactType(string2);
        }
        if (string.equals("user")) {
            return new UserMatch(string2);
        }
        if (string.equals("nodes")) {
            try {
                String[] stringArray = string2.split("-");
                if (stringArray.length == 1) {
                    return new NodeCount(Integer.parseInt(string2));
                }
                if (stringArray.length == 2) {
                    return new NodeCountRange(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                }
                throw new ParseError(I18n.tr("Wrong number of parameters for nodes operator."));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseError(I18n.tr("Incorrect value of nodes operator: {0}. Nodes operator expects number of nodes or range, for example nodes:10-20", string2));
            }
        }
        if (string.equals("id")) {
            try {
                return new Id(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseError(I18n.tr("Incorrect value of id operator: {0}. Number is expected.", string2));
            }
        }
        return new KeyValue(string, string2);
    }

    private int regexFlags() {
        int n = 0;
        n |= 0x80;
        n |= 0x20;
        if (!this.caseSensitive) {
            n |= 0x42;
        }
        return n;
    }

    public static class ParseError
    extends Exception {
        public ParseError(String string) {
            super(string);
        }
    }

    private static class Child
    extends Match {
        private Match parent;

        public Child(Match match) {
            this.parent = match;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            if (this.parent == null) {
                this.parent = new Always();
            }
            boolean bl = false;
            childBackRefs.initialize();
            osmPrimitive.visit(childBackRefs);
            for (OsmPrimitive osmPrimitive2 : childBackRefs.getData()) {
                bl |= this.parent.match(osmPrimitive2);
            }
            return bl;
        }

        public String toString() {
            return "child(" + this.parent + ")";
        }
    }

    private static class Parent
    extends Match {
        private Match child;

        public Parent(Match match) {
            this.child = match;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            boolean bl;
            block4: {
                block3: {
                    bl = false;
                    if (this.child == null) {
                        this.child = new Always();
                    }
                    if (!(osmPrimitive instanceof Way)) break block3;
                    for (Node node : ((Way)osmPrimitive).getNodes()) {
                        bl |= this.child.match(node);
                    }
                    break block4;
                }
                if (!(osmPrimitive instanceof Relation)) break block4;
                for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                    if (relationMember.getMember() == null) continue;
                    bl |= this.child.match(relationMember.getMember());
                }
            }
            return bl;
        }

        public String toString() {
            return "parent(" + this.child + ")";
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return !osmPrimitive.isTagged();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.incomplete;
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isSelected();
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isModified() || osmPrimitive.getId() == 0L;
        }

        public String toString() {
            return "modified";
        }
    }

    private static class NodeCountRange
    extends Match {
        private int minCount;
        private int maxCount;

        public NodeCountRange(int n, int n2) {
            if (n2 < n) {
                this.minCount = n2;
                this.maxCount = n;
            } else {
                this.minCount = n;
                this.maxCount = n2;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Way)) {
                return false;
            }
            int n = ((Way)osmPrimitive).getNodesCount();
            return n >= this.minCount && n <= this.maxCount;
        }

        public String toString() {
            return "nodes=" + this.minCount + "-" + this.maxCount;
        }
    }

    private static class NodeCount
    extends Match {
        private int count;

        public NodeCount(int n) {
            this.count = n;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive instanceof Way && ((Way)osmPrimitive).getNodesCount() == this.count;
        }

        public String toString() {
            return "nodes=" + this.count;
        }
    }

    private static class UserMatch
    extends Match {
        private User user;

        public UserMatch(String string) {
            List<User> list = User.getByName(string);
            if (!list.isEmpty()) {
                this.user = list.get(0);
            } else {
                string = null;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.user == null && this.user == null) {
                return true;
            }
            if (osmPrimitive.user == null) {
                return false;
            }
            return osmPrimitive.user.equals(this.user);
        }

        public String toString() {
            return "user=" + this.user == null ? "" : this.user.getName();
        }
    }

    private static class ExactType
    extends Match {
        private final Class<?> type;

        public ExactType(String string) throws ParseError {
            if ("node".equals(string)) {
                this.type = Node.class;
            } else if ("way".equals(string)) {
                this.type = Way.class;
            } else if ("relation".equals(string)) {
                this.type = Relation.class;
            } else {
                throw new ParseError(I18n.tr("Unknown primitive type: {0}. Allowed values are node, way or relation", string));
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getClass() == this.type;
        }

        public String toString() {
            return "type=" + this.type;
        }
    }

    private class Any
    extends Match {
        private String s;

        public Any(String string) {
            this.s = string;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            String string;
            if (!osmPrimitive.hasKeys()) {
                return this.s.equals("");
            }
            Pattern pattern = null;
            if (SearchCompiler.this.regexSearch) {
                string = this.s;
                int n = SearchCompiler.this.regexFlags();
                try {
                    pattern = Pattern.compile(string, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
            } else {
                string = SearchCompiler.this.caseSensitive ? this.s : this.s.toLowerCase();
            }
            for (Map.Entry<String, String> entry : osmPrimitive.entrySet()) {
                String string2;
                String string3;
                if (SearchCompiler.this.regexSearch) {
                    string3 = entry.getKey();
                    string2 = entry.getValue();
                    Matcher matcher = pattern.matcher(string3);
                    Matcher matcher2 = pattern.matcher(string2);
                    boolean bl = matcher.find();
                    boolean bl2 = matcher2.find();
                    if (!bl && !bl2) continue;
                    return true;
                }
                string3 = SearchCompiler.this.caseSensitive ? entry.getKey() : entry.getKey().toLowerCase();
                String string4 = string2 = SearchCompiler.this.caseSensitive ? entry.getValue() : entry.getValue().toLowerCase();
                if (string3.indexOf(string) == -1 && string2.indexOf(string) == -1) continue;
                return true;
            }
            if (osmPrimitive.user != null) {
                Object object = osmPrimitive.user.getName();
                if (!SearchCompiler.this.caseSensitive) {
                    object = ((String)object).toLowerCase();
                }
                if (((String)object).indexOf(string) != -1) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.s;
        }
    }

    private static class ExactKeyValue
    extends Match {
        private final String key;
        private final String value;
        private final Pattern keyPattern;
        private final Pattern valuePattern;
        private final Mode mode;

        public ExactKeyValue(boolean bl, String string, String string2) throws ParseError {
            if (string == "") {
                throw new ParseError(I18n.tr("Key cannot be empty when tag operator is used. Sample use: key=value"));
            }
            this.key = string;
            this.value = string2;
            this.mode = "".equals(string2) && "*".equals(string) ? Mode.NONE : ("".equals(string2) ? (bl ? Mode.MISSING_KEY_REGEXP : Mode.MISSING_KEY) : ("*".equals(string) && "*".equals(string2) ? Mode.ANY : ("*".equals(string) ? (bl ? Mode.ANY_KEY_REGEXP : Mode.ANY_KEY) : ("*".equals(string2) ? (bl ? Mode.ANY_VALUE_REGEXP : Mode.ANY_VALUE) : (bl ? Mode.EXACT_REGEXP : Mode.EXACT)))));
            this.keyPattern = bl && string.length() > 0 && !string.equals("*") ? Pattern.compile(string) : null;
            if (bl && string2.length() > 0 && !string2.equals("*")) {
                try {
                    this.valuePattern = Pattern.compile(string2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr("Pattern Syntax Error: Pattern {0} in {1} is illegal!", patternSyntaxException.getPattern(), string2));
                }
            } else {
                this.valuePattern = null;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            if (!osmPrimitive.hasKeys()) {
                return this.mode == Mode.NONE;
            }
            switch (this.mode) {
                case NONE: {
                    return false;
                }
                case MISSING_KEY: {
                    return osmPrimitive.get(this.key) == null;
                }
                case ANY: {
                    return true;
                }
                case ANY_VALUE: {
                    return osmPrimitive.get(this.key) != null;
                }
                case ANY_KEY: {
                    for (String string : osmPrimitive.getKeys().values()) {
                        if (!string.equals(this.value)) continue;
                        return true;
                    }
                    return false;
                }
                case EXACT: {
                    return this.value.equals(osmPrimitive.get(this.key));
                }
                case ANY_KEY_REGEXP: {
                    for (String string : osmPrimitive.getKeys().values()) {
                        if (!this.valuePattern.matcher(string).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case ANY_VALUE_REGEXP: 
                case EXACT_REGEXP: {
                    for (Map.Entry<String, String> entry : osmPrimitive.entrySet()) {
                        if (!this.keyPattern.matcher(entry.getKey()).matches() || this.mode != Mode.ANY_VALUE_REGEXP && !this.valuePattern.matcher(entry.getValue()).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case MISSING_KEY_REGEXP: {
                    for (String string : osmPrimitive.keySet()) {
                        if (!this.keyPattern.matcher(string).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new AssertionError((Object)"Missed state");
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Mode {
            ANY,
            ANY_KEY,
            ANY_VALUE,
            EXACT,
            NONE,
            MISSING_KEY,
            ANY_KEY_REGEXP,
            ANY_VALUE_REGEXP,
            EXACT_REGEXP,
            MISSING_KEY_REGEXP;

        }
    }

    private class KeyValue
    extends Match {
        private String key;
        private String value;

        public KeyValue(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            if (SearchCompiler.this.regexSearch) {
                if (!osmPrimitive.hasKeys()) {
                    return false;
                }
                Pattern pattern = null;
                Pattern pattern2 = null;
                int n = SearchCompiler.this.regexFlags();
                try {
                    pattern = Pattern.compile(this.key, n);
                    pattern2 = Pattern.compile(this.value, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                for (Map.Entry<String, String> entry : osmPrimitive.entrySet()) {
                    Matcher matcher;
                    boolean bl;
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    Matcher matcher2 = pattern.matcher(string);
                    boolean bl2 = matcher2.find();
                    if (!bl2 || !(bl = (matcher = pattern2.matcher(string2)).find())) continue;
                    return true;
                }
            } else {
                String string = null;
                string = this.key.equals("timestamp") ? DateUtils.fromDate(osmPrimitive.getTimestamp()) : osmPrimitive.get(this.key);
                if (string == null) {
                    return false;
                }
                String string3 = SearchCompiler.this.caseSensitive ? string : string.toLowerCase();
                String string4 = SearchCompiler.this.caseSensitive ? this.value : this.value.toLowerCase();
                return string3.indexOf(string4) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Id
    extends Match {
        private long id;

        public Id(long l) {
            this.id = l;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getId() == this.id;
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    private static class Or
    extends Match {
        private Match lhs;
        private Match rhs;

        public Or(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            return this.lhs.match(osmPrimitive) || this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " || " + this.rhs;
        }
    }

    private static class And
    extends Match {
        private Match lhs;
        private Match rhs;

        public And(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            return this.lhs.match(osmPrimitive) && this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " && " + this.rhs;
        }
    }

    private static class Not
    extends Match {
        private final Match match;

        public Not(Match match) {
            this.match = match;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            return !this.match.match(osmPrimitive);
        }

        public String toString() {
            return "!" + this.match;
        }
    }

    private static class Always
    extends Match {
        private Always() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return true;
        }
    }

    public static abstract class Match {
        public abstract boolean match(OsmPrimitive var1) throws ParseError;
    }
}

