/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOsmTask
implements DownloadDialog.DownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadOsmTask.class.getName());
    private static Bounds currentBounds;
    private Future<Task> task = null;
    private DataSet downloadedData;
    private boolean canceled = false;
    private boolean failed = false;
    private JCheckBox checkBox = new JCheckBox(I18n.tr("OpenStreetMap data"), true);

    private void rememberDownloadedData(DataSet dataSet) {
        this.downloadedData = dataSet;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean bl) {
        this.failed = bl;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    public void download(DownloadAction downloadAction, double d, double d2, double d3, double d4, ProgressMonitor progressMonitor) {
        double d5;
        if (d > d3) {
            d5 = d;
            d = d3;
            d3 = d5;
        }
        if (d2 > d4) {
            d5 = d2;
            d2 = d4;
            d4 = d5;
        }
        boolean bl = downloadAction != null && (downloadAction.dialog == null || downloadAction.dialog.newLayer.isSelected());
        Task task = new Task(bl, new BoundingBoxDownloader(d, d2, d3, d4), progressMonitor);
        currentBounds = new Bounds(new LatLon(d, d2), new LatLon(d3, d4));
        this.task = Main.worker.submit(task, task);
    }

    public void loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        Task task = new Task(bl, new OsmServerLocationReader(string), progressMonitor);
        currentBounds = new Bounds(new LatLon(0.0, 0.0), new LatLon(0.0, 0.0));
        this.task = Main.worker.submit(task, task);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getPreferencesSuffix() {
        return "osm";
    }

    public String getErrorMessage() {
        if (this.task == null) {
            return "";
        }
        try {
            Task task = this.task.get();
            return task.getProgressMonitor().getErrorMessage() == null ? "" : task.getProgressMonitor().getErrorMessage();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private class Task
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private DataSet dataSet;
        private boolean newLayer;
        private boolean canceled;
        private Exception lastException;

        public Task(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading data"), progressMonitor, false);
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                this.dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception exception) {
                if (this.canceled) {
                    logger.warning(I18n.tr("Ignoring exception because download has been cancelled. Exception was: {0}" + exception.toString()));
                    return;
                }
                this.lastException = exception instanceof OsmTransferException ? exception : new OsmTransferException(exception);
            }
        }

        protected OsmDataLayer getEditLayer() {
            if (Main.map == null) {
                return null;
            }
            if (Main.map.mapView == null) {
                return null;
            }
            return Main.map.mapView.getEditLayer();
        }

        protected int getNumDataLayers() {
            int n = 0;
            if (Main.map == null) {
                return 0;
            }
            if (Main.map.mapView == null) {
                return 0;
            }
            Collection<Layer> collection = Main.map.mapView.getAllLayers();
            for (Layer layer : collection) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++n;
            }
            return n;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (Main.map == null) {
                return null;
            }
            if (Main.map.mapView == null) {
                return null;
            }
            List<Layer> list = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : list) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                this.getProgressMonitor().setErrorMessage(ExceptionUtil.explainException(this.lastException));
                DownloadOsmTask.this.setFailed(true);
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (currentBounds == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                this.progressMonitor.setErrorMessage(I18n.tr("No data found in this area."));
                this.dataSet.dataSources.add(new DataSource(currentBounds, "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            int n = this.getNumDataLayers();
            if (this.newLayer || n == 0 || n > 1 && this.getEditLayer() == null) {
                OsmDataLayer osmDataLayer = new OsmDataLayer(this.dataSet, OsmDataLayer.createNewName(), null);
                Main.main.addLayer(osmDataLayer);
            } else {
                OsmDataLayer osmDataLayer = this.getEditLayer();
                if (osmDataLayer == null) {
                    osmDataLayer = this.getFirstDataLayer();
                }
                osmDataLayer.mergeFrom(this.dataSet);
            }
        }

        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                this.reader.cancel();
            }
            DownloadOsmTask.this.setCanceled(true);
        }
    }
}

