/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSelectionAction
extends JosmAction {
    protected void handlePrimitiveGoneException(long l, OsmPrimitiveType osmPrimitiveType) {
        MultiFetchServerObjectReader multiFetchServerObjectReader = new MultiFetchServerObjectReader();
        multiFetchServerObjectReader.append(this.getCurrentDataSet(), l, osmPrimitiveType);
        DataSet dataSet = null;
        try {
            dataSet = multiFetchServerObjectReader.parseOsm(NullProgressMonitor.INSTANCE);
        }
        catch (Exception exception) {
            ExceptionDialogUtil.explainException(exception);
        }
        Main.map.mapView.getEditLayer().mergeFrom(dataSet);
    }

    public void updatePrimitives(Collection<OsmPrimitive> collection) {
        UpdatePrimitivesTask updatePrimitivesTask = new UpdatePrimitivesTask(collection);
        Main.worker.submit(updatePrimitivesTask);
    }

    public void updatePrimitive(OsmPrimitiveType osmPrimitiveType, long l) throws IllegalStateException {
        if (this.getEditLayer() == null) {
            throw new IllegalStateException(I18n.tr("No current dataset found"));
        }
        OsmPrimitive osmPrimitive = this.getEditLayer().data.getPrimitiveById(l, osmPrimitiveType);
        if (osmPrimitive == null) {
            throw new IllegalStateException(I18n.tr("Didn't find a primitive with id {0} in the current dataset", l));
        }
        this.updatePrimitives(Collections.singleton(osmPrimitive));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selections"), "updateselection", I18n.tr("Updates the currently selected objects from the server (re-downloads data)"), Shortcut.registerShortcut("file:updateselection", I18n.tr("Update Selection"), 85, 15), true);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        if (collection.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected primitives to update."), I18n.tr("Selection empty"), 1);
            return;
        }
        this.updatePrimitives(collection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpdatePrimitivesTask
    extends PleaseWaitRunnable {
        private DataSet ds;
        private boolean canceled;
        private Exception lastException;
        private Collection<? extends OsmPrimitive> toUpdate;
        private MultiFetchServerObjectReader reader;

        public UpdatePrimitivesTask(Collection<? extends OsmPrimitive> collection) {
            super("Update primitives", false);
            this.canceled = false;
            this.toUpdate = collection;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.ds != null) {
                Main.map.mapView.getEditLayer().mergeFrom(this.ds);
            }
        }

        protected void initMultiFetchReaderWithNodes(MultiFetchServerObjectReader multiFetchServerObjectReader) {
            for (OsmPrimitive osmPrimitive : this.toUpdate) {
                if (osmPrimitive instanceof Node && osmPrimitive.getId() > 0L) {
                    multiFetchServerObjectReader.append((Node)osmPrimitive);
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                Way way = (Way)osmPrimitive;
                for (Node node : way.getNodes()) {
                    if (node.getId() <= 0L) continue;
                    multiFetchServerObjectReader.append(node);
                }
            }
        }

        protected void initMultiFetchReaderWithWays(MultiFetchServerObjectReader multiFetchServerObjectReader) {
            for (OsmPrimitive osmPrimitive : this.toUpdate) {
                if (!(osmPrimitive instanceof Way) || osmPrimitive.getId() <= 0L) continue;
                multiFetchServerObjectReader.append((Way)osmPrimitive);
            }
        }

        protected void initMultiFetchReaderWithRelations(MultiFetchServerObjectReader multiFetchServerObjectReader) {
            for (OsmPrimitive osmPrimitive : this.toUpdate) {
                if (!(osmPrimitive instanceof Relation) || osmPrimitive.getId() <= 0L) continue;
                multiFetchServerObjectReader.append((Relation)osmPrimitive);
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            this.progressMonitor.indeterminateSubTask("");
            this.ds = new DataSet();
            try {
                this.reader = new MultiFetchServerObjectReader();
                this.initMultiFetchReaderWithNodes(this.reader);
                this.initMultiFetchReaderWithWays(this.reader);
                this.initMultiFetchReaderWithRelations(this.reader);
                DataSet dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                MergeVisitor mergeVisitor = new MergeVisitor(this.ds, dataSet);
                mergeVisitor.merge();
            }
            catch (Exception exception) {
                if (this.canceled) {
                    return;
                }
                this.lastException = exception;
            }
        }
    }
}

