/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnGlueAction
extends JosmAction {
    private Node selectedNode;
    private Way selectedWay;
    private ArrayList<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways"), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways."), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tool: {0}", I18n.tr("UnGlue Ways")), 71, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        String string = null;
        if (this.checkSelection(collection)) {
            int n = 0;
            for (Way way : this.getCurrentDataSet().ways) {
                if (!way.isUsable() || way.getNodesCount() < 1 || !way.containsNode(this.selectedNode)) continue;
                ++n;
            }
            if (n < 2) {
                if (this.checkForUnglueNode(collection)) {
                    this.unglueNode(actionEvent);
                } else {
                    string = I18n.tr("This node is not glued to anything else.");
                }
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelection2(collection)) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : this.selectedNodes) {
                int n = 0;
                for (Way way : this.getCurrentDataSet().ways) {
                    if (way.isDeleted() || way.incomplete || way.getNodesCount() < 1 || !way.containsNode(node)) continue;
                    ++n;
                }
                if (n < 2) continue;
                arrayList.add(node);
            }
            if (arrayList.size() < 1) {
                string = collection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.") : I18n.tr("None of this way's nodes are glued to anything else.");
            } else {
                this.selectedNodes = arrayList;
                this.unglueWays2();
            }
        } else {
            string = I18n.tr("The current selection cannot be used for unglueing.") + "\n" + "\n" + I18n.tr("Select either:") + "\n" + I18n.tr("* One tagged node, or") + "\n" + I18n.tr("* One node that is used by more than one way, or") + "\n" + I18n.tr("* One node that is used by more than one way and one of those ways, or") + "\n" + I18n.tr("* One way that has one or more nodes that are used by more than one way, or") + "\n" + I18n.tr("* One way and one or more of its nodes that are used by more than one way.") + "\n" + "\n" + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.");
        }
        if (string != null) {
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Error"), 0);
        }
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    private void unglueNode(ActionEvent actionEvent) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Node node = new Node(this.selectedNode);
        node.removeAll();
        node.setSelected(false);
        linkedList.add(new ChangeCommand(this.selectedNode, node));
        Node node2 = new Node(this.selectedNode);
        node2.clearOsmId();
        if (actionEvent.getSource() instanceof JPanel) {
            MapView mapView = Main.map.mapView;
            node2.setCoor(mapView.getLatLon(mapView.lastMEvent.getX(), mapView.lastMEvent.getY()));
        }
        linkedList.add(new AddCommand(node2));
        this.fixRelations(this.selectedNode, linkedList, Collections.singletonList(node2));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Unglued Node"), linkedList));
        this.getCurrentDataSet().setSelected(node2);
        Main.map.mapView.repaint();
    }

    private boolean checkForUnglueNode(Collection<? extends OsmPrimitive> collection) {
        if (collection.size() != 1) {
            return false;
        }
        OsmPrimitive osmPrimitive = (OsmPrimitive)collection.toArray()[0];
        if (!(osmPrimitive instanceof Node)) {
            return false;
        }
        boolean bl = false;
        for (Way way : this.getCurrentDataSet().ways) {
            if (!way.containsNode((Node)osmPrimitive)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        this.selectedNode = (Node)osmPrimitive;
        return this.selectedNode.isTagged();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> collection) {
        int n = collection.size();
        if (n < 1 || n > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (n != 1 && this.selectedWay == null) continue;
                return n == 1 || this.selectedWay.containsNode(this.selectedNode);
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (n != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelection2(Collection<? extends OsmPrimitive> collection) {
        if (collection.size() < 1) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new ArrayList();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node node = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(node)) {
                return false;
            }
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.size() < 1) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private Way modifyWay(Node node, Way way, List<Command> list, List<Node> list2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node2 : way.getNodes()) {
            if (node == node2) {
                node2 = new Node(node2);
                node2.clearOsmId();
                list2.add(node2);
                list.add(new AddCommand(node2));
            }
            arrayList.add(node2);
        }
        Way way2 = new Way(way);
        way2.setNodes(arrayList);
        return way2;
    }

    private void fixRelations(Node node, List<Command> list, List<Node> list2) {
        Relation relation = null;
        HashSet<String> hashSet = null;
        for (Relation relation2 : this.getCurrentDataSet().relations) {
            if (relation2.isDeleted() || relation2.incomplete) continue;
            relation = null;
            hashSet = null;
            for (RelationMember relationMember : relation2.getMembers()) {
                if (!relationMember.isNode() || relationMember.getMember() != node) continue;
                if (relation == null) {
                    relation = new Relation(relation2);
                    relation.setMembers(null);
                    hashSet = new HashSet<String>();
                }
                hashSet.add(relationMember.getRole());
            }
            if (relation == null) continue;
            for (RelationMember relationMember : relation2.getMembers()) {
                relation.addMember(relationMember);
            }
            for (Node node2 : list2) {
                for (String string : hashSet) {
                    relation.addMember(new RelationMember(string, node2));
                }
            }
            list.add(new ChangeCommand(relation2, relation));
        }
    }

    private void unglueWays() {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        if (this.selectedWay == null) {
            boolean bl = true;
            for (Way way : this.getCurrentDataSet().ways) {
                if (way.isDeleted() || way.incomplete || way.getNodesCount() < 1 || !way.containsNode(this.selectedNode)) continue;
                if (!bl) {
                    linkedList.add(new ChangeCommand(way, this.modifyWay(this.selectedNode, way, linkedList, linkedList2)));
                }
                bl = false;
            }
        } else {
            linkedList.add(new ChangeCommand(this.selectedWay, this.modifyWay(this.selectedNode, this.selectedWay, linkedList, linkedList2)));
        }
        this.fixRelations(this.selectedNode, linkedList, linkedList2);
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Dupe into {0} nodes", linkedList2.size() + 1), linkedList));
        if (this.selectedWay == null) {
            linkedList2.add(this.selectedNode);
        }
        this.getCurrentDataSet().setSelected(linkedList2);
    }

    private void unglueWays2() {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        Way way = this.selectedWay;
        for (Node node : this.selectedNodes) {
            LinkedList<Node> linkedList3 = new LinkedList<Node>();
            way = this.modifyWay(node, way, linkedList, linkedList3);
            this.fixRelations(node, linkedList, linkedList3);
            linkedList2.addAll(linkedList3);
        }
        linkedList.add(new ChangeCommand(this.selectedWay, way));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size() + linkedList2.size()), linkedList));
        this.getCurrentDataSet().setSelected(linkedList2);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }
}

