/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OpenLocationAction
extends JosmAction {
    public OpenLocationAction() {
        super(I18n.tr("Open Location..."), "openlocation", I18n.tr("Open an URL."), Shortcut.registerShortcut("system:open_location", I18n.tr("File: {0}", I18n.tr("Open Location...")), 76, 2), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Separate Layer"));
        jCheckBox.setSelected(Main.pref.getBoolean("download.newlayer"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Enter URL to download:")), GBC.eol());
        JTextField jTextField = new JTextField(40);
        jPanel.add((Component)jTextField, GBC.eol());
        jPanel.add((Component)jCheckBox, GBC.eol());
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Download Location"), new String[]{I18n.tr("Download URL"), I18n.tr("Cancel")});
        extendedDialog.setContent(jPanel);
        extendedDialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        this.openUrl(jCheckBox.isSelected(), jTextField.getText());
    }

    public void openUrl(boolean bl, String string) {
        new DownloadOsmTask().loadUrl(bl, string, null);
    }
}

