/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxExporter;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.NMEAImporter;
import org.openstreetmap.josm.io.OsmBzip2Exporter;
import org.openstreetmap.josm.io.OsmBzip2Importer;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmGzipExporter;
import org.openstreetmap.josm.io.OsmGzipImporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFileFilter
extends FileFilter {
    public static ArrayList<FileImporter> importers = new ArrayList<FileImporter>(Arrays.asList(new OsmImporter(), new OsmGzipImporter(), new OsmBzip2Importer(), new GpxImporter(), new NMEAImporter(), new AllFormatsImporter()));
    public static ArrayList<FileExporter> exporters = new ArrayList<FileExporter>(Arrays.asList(new GpxExporter(), new OsmExporter(), new OsmGzipExporter(), new OsmBzip2Exporter()));
    private final String extensions;
    private final String description;
    @Deprecated
    public final String defaultExtension;

    protected static void sort(List<ExtensionFileFilter> list) {
        Collections.sort(list, new Comparator<ExtensionFileFilter>(){
            private AllFormatsImporter all = new AllFormatsImporter();

            @Override
            public int compare(ExtensionFileFilter extensionFileFilter, ExtensionFileFilter extensionFileFilter2) {
                if (extensionFileFilter.getDescription().equals(this.all.filter.getDescription())) {
                    return 1;
                }
                if (extensionFileFilter2.getDescription().equals(this.all.filter.getDescription())) {
                    return -1;
                }
                return extensionFileFilter.getDescription().compareTo(extensionFileFilter2.getDescription());
            }
        });
    }

    public static List<ExtensionFileFilter> getImportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> linkedList = new LinkedList<ExtensionFileFilter>();
        for (FileImporter fileImporter : importers) {
            if (linkedList.contains(fileImporter.filter)) continue;
            linkedList.add(fileImporter.filter);
        }
        ExtensionFileFilter.sort(linkedList);
        return linkedList;
    }

    public static List<ExtensionFileFilter> getExportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> linkedList = new LinkedList<ExtensionFileFilter>();
        for (FileExporter fileExporter : exporters) {
            if (linkedList.contains(fileExporter.filter)) continue;
            linkedList.add(fileExporter.filter);
        }
        ExtensionFileFilter.sort(linkedList);
        return linkedList;
    }

    public static ExtensionFileFilter getDefaultImportExtensionFileFilter(String string) {
        if (string == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileImporter fileImporter : importers) {
            if (!string.equals(fileImporter.filter.getDefaultExtension())) continue;
            return fileImporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static ExtensionFileFilter getDefaultExportExtensionFileFilter(String string) {
        if (string == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileExporter fileExporter : exporters) {
            if (!string.equals(fileExporter.filter.getDefaultExtension())) continue;
            return fileExporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static void applyChoosableImportFileFilters(JFileChooser jFileChooser, String string) {
        for (ExtensionFileFilter extensionFileFilter : ExtensionFileFilter.getImportExtensionFileFilters()) {
            jFileChooser.addChoosableFileFilter(extensionFileFilter);
        }
        jFileChooser.setFileFilter(ExtensionFileFilter.getDefaultImportExtensionFileFilter(string));
    }

    public static void applyChoosableExportFileFilters(JFileChooser jFileChooser, String string) {
        for (ExtensionFileFilter extensionFileFilter : ExtensionFileFilter.getExportExtensionFileFilters()) {
            jFileChooser.addChoosableFileFilter(extensionFileFilter);
        }
        jFileChooser.setFileFilter(ExtensionFileFilter.getDefaultExportExtensionFileFilter(string));
    }

    public ExtensionFileFilter(String string, String string2, String string3) {
        this.extensions = string;
        this.defaultExtension = string2;
        this.description = string3;
    }

    public boolean acceptName(String string) {
        String string2 = string.toLowerCase();
        for (String string3 : this.extensions.split(",")) {
            if (!string2.endsWith("." + string3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.acceptName(file.getName());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.defaultExtension == null ? 0 : this.defaultExtension.hashCode());
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.extensions == null ? 0 : this.extensions.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)object;
        if (this.defaultExtension == null ? extensionFileFilter.defaultExtension != null : !this.defaultExtension.equals(extensionFileFilter.defaultExtension)) {
            return false;
        }
        if (this.description == null ? extensionFileFilter.description != null : !this.description.equals(extensionFileFilter.description)) {
            return false;
        }
        return !(this.extensions == null ? extensionFileFilter.extensions != null : !this.extensions.equals(extensionFileFilter.extensions));
    }

    public static class AllFormatsImporter
    extends FileImporter {
        public AllFormatsImporter() {
            super(new ExtensionFileFilter("osm,xml,osm.gz,osm.bz2,osm.bz,gpx,gpx.gz,nmea,nme,nma,txt,wms", "", I18n.tr("All Formats") + " (*.gpx *.osm *.nmea ...)"));
        }

        public boolean acceptFile(File file) {
            return false;
        }
    }
}

