/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadReferrersAction
extends JosmAction {
    public DownloadReferrersAction() {
        super(I18n.tr("Download parent ways/relations..."), "downloadreferrers", I18n.tr("Download primitives referring to one of the selected primitives"), Shortcut.registerShortcut("file:downloadreferrers", I18n.tr("File: {0}", I18n.tr("Download parent ways/relations...")), 68, 15), true);
    }

    public void downloadReferrers(Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(collection));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        OsmDataLayer osmDataLayer = Main.map.mapView.getEditLayer();
        Collection<OsmPrimitive> collection = osmDataLayer.data.getSelected();
        this.downloadReferrers(collection);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadReferrersTask
    extends PleaseWaitRunnable {
        private DataSet ds;
        private boolean cancelled;
        Exception lastException;
        private Collection<OsmPrimitive> primitives;
        private DataSet parents;

        public DownloadReferrersTask(Collection<OsmPrimitive> collection) {
            super("Download referrers", false);
            this.cancelled = false;
            this.primitives = collection;
            this.parents = new DataSet();
        }

        protected void showLastException() {
            String string = this.lastException.getMessage();
            if (string == null) {
                string = this.lastException.toString();
            }
            JOptionPane.showMessageDialog(Main.map, string, I18n.tr("Error"), 0);
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
            OsmApi.getOsmApi().cancel();
        }

        @Override
        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                this.showLastException();
                return;
            }
            MergeVisitor mergeVisitor = new MergeVisitor(Main.map.mapView.getEditLayer().data, this.parents);
            mergeVisitor.merge();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.map.mapView.getEditLayer().fireDataChange();
                    Main.map.mapView.repaint();
                }
            });
            if (mergeVisitor.getConflicts().isEmpty()) {
                return;
            }
            Main.map.mapView.getEditLayer().getConflicts().add(mergeVisitor.getConflicts());
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", mergeVisitor.getConflicts().size()), I18n.tr("Conflicts during download"), 2);
        }

        protected void downloadParents(OsmPrimitive osmPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
            OsmServerBackreferenceReader osmServerBackreferenceReader = new OsmServerBackreferenceReader(osmPrimitive);
            DataSet dataSet = osmServerBackreferenceReader.parseOsm(progressMonitor);
            MergeVisitor mergeVisitor = new MergeVisitor(this.parents, dataSet);
            mergeVisitor.merge();
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.progressMonitor.setTicksCount(this.primitives.size());
                int n = 1;
                for (OsmPrimitive osmPrimitive : this.primitives) {
                    if (this.cancelled) {
                        return;
                    }
                    this.progressMonitor.subTask(I18n.tr("({0}/{1}) Loading parents of primitive {2}", n + 1, this.primitives.size(), osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
                    this.downloadParents(osmPrimitive, this.progressMonitor.createSubTaskMonitor(1, false));
                    ++n;
                }
            }
            catch (Exception exception) {
                if (this.cancelled) {
                    return;
                }
                this.lastException = exception;
            }
        }
    }
}

