/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombineWayAction
extends JosmAction {
    public CombineWayAction() {
        super(I18n.tr("Combine Way"), "combineway", I18n.tr("Combine several ways into one."), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way")), 67, 3), true);
    }

    protected boolean confirmChangeDirectionOfWays() {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change directions?"), new String[]{I18n.tr("Reverse and Combine"), I18n.tr("Cancel")});
        extendedDialog.setButtonIcons(new String[]{"wayflip.png", "cancel.png"});
        extendedDialog.setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?"));
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    protected void warnCombiningImpossible() {
        String string = I18n.tr("Could not combine ways (They could not be merged into a single string of nodes)");
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Information"), 1);
    }

    protected Way getTargetWay(Collection<Way> collection) {
        Way way = collection.iterator().next();
        Iterator<Way> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Way way2;
            way = way2 = iterator.next();
            if (way2.getId() == 0L) continue;
            break;
        }
        return way;
    }

    public void combineWays(Collection<Way> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        collection.remove(null);
        collection = new HashSet<Way>(collection);
        WayReferringRelations wayReferringRelations = new WayReferringRelations(collection);
        wayReferringRelations.build(this.getCurrentDataSet());
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        NodeGraph nodeGraph = NodeGraph.createDirectedGraphFromWays(collection);
        List<Node> list = nodeGraph.buildSpanningPath();
        if (list == null) {
            nodeGraph = NodeGraph.createUndirectedGraphFromNodeWays(collection);
            list = nodeGraph.buildSpanningPath();
            if (list != null) {
                if (!this.confirmChangeDirectionOfWays()) {
                    return;
                }
            } else {
                this.warnCombiningImpossible();
                return;
            }
        }
        Way way = this.getTargetWay(collection);
        Way way2 = new Way(way);
        way2.setNodes(list);
        TagCollection tagCollection2 = new TagCollection(tagCollection);
        TagConflictResolutionUtil.combineTigerTags(tagCollection2);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(tagCollection2, collection);
        TagCollection tagCollection3 = new TagCollection(tagCollection2);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagCollection3);
        CombinePrimitiveResolverDialog combinePrimitiveResolverDialog = CombinePrimitiveResolverDialog.getInstance();
        combinePrimitiveResolverDialog.getTagConflictResolverModel().populate(tagCollection3, tagCollection2.getKeysWithMultipleValues());
        combinePrimitiveResolverDialog.setTargetPrimitive(way);
        combinePrimitiveResolverDialog.getRelationMemberConflictResolverModel().populate(wayReferringRelations.getRelations(), wayReferringRelations.getWays());
        combinePrimitiveResolverDialog.prepareDefaultDecisions();
        if (!tagCollection2.isApplicableToPrimitive() || !wayReferringRelations.getRelations().isEmpty()) {
            combinePrimitiveResolverDialog.setVisible(true);
            if (combinePrimitiveResolverDialog.isCancelled()) {
                return;
            }
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Way> linkedList2 = new LinkedList<Way>(collection);
        linkedList2.remove(way);
        linkedList.add(new DeleteCommand(linkedList2));
        linkedList.add(new ChangeCommand(way, way2));
        linkedList.addAll(combinePrimitiveResolverDialog.buildResolutionCommands());
        final SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Combine {0} ways", collection.size()), linkedList);
        final Way way3 = way;
        Runnable runnable = new Runnable(){

            public void run() {
                Main.main.undoRedo.add(sequenceCommand);
                CombineWayAction.this.getCurrentDataSet().setSelected(way3);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        Set<Way> set = OsmPrimitive.getFilteredSet(collection, Way.class);
        if (set.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two ways to combine."), I18n.tr("Information"), 1);
            return;
        }
        this.combineWays(set);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        this.setEnabled(n >= 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeGraph {
        private Set<NodePair> edges = new HashSet<NodePair>();
        private int numUndirectedEges = 0;
        private HashMap<Node, List<NodePair>> successors;
        private HashMap<Node, List<NodePair>> predecessors;

        public static List<NodePair> buildNodePairs(Way way, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                arrayList.add(new NodePair(pair));
                if (bl) continue;
                arrayList.add(new NodePair(pair).swap());
            }
            return arrayList;
        }

        public static List<NodePair> buildNodePairs(List<Way> list, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Way way : list) {
                arrayList.addAll(NodeGraph.buildNodePairs(way, bl));
            }
            return arrayList;
        }

        public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> list) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (NodePair nodePair : list) {
                if (arrayList.contains(nodePair) || arrayList.contains(nodePair.swap())) continue;
                arrayList.add(nodePair);
            }
            return arrayList;
        }

        public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
            }
            return nodeGraph;
        }

        public static NodeGraph createDirectedGraphFromWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, true));
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
                nodeGraph.add(nodePair.swap());
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, false));
            }
            return nodeGraph;
        }

        protected void rememberSuccessor(NodePair nodePair) {
            if (this.successors.containsKey(nodePair.getA())) {
                if (!this.successors.get(nodePair.getA()).contains(nodePair)) {
                    this.successors.get(nodePair.getA()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.successors.put(nodePair.getA(), arrayList);
            }
        }

        protected void rememberPredecessors(NodePair nodePair) {
            if (this.predecessors.containsKey(nodePair.getB())) {
                if (!this.predecessors.get(nodePair.getB()).contains(nodePair)) {
                    this.predecessors.get(nodePair.getB()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.predecessors.put(nodePair.getB(), arrayList);
            }
        }

        protected boolean isTerminalNode(Node node) {
            if (this.successors.get(node) == null) {
                return false;
            }
            if (this.successors.get(node).size() != 1) {
                return false;
            }
            if (this.predecessors.get(node) == null) {
                return true;
            }
            if (this.predecessors.get(node).size() == 1) {
                NodePair nodePair = this.successors.get(node).iterator().next();
                NodePair nodePair2 = this.predecessors.get(node).iterator().next();
                return nodePair.equals(nodePair2.swap());
            }
            return false;
        }

        protected void prepare() {
            HashSet<NodePair> hashSet = new HashSet<NodePair>();
            this.successors = new HashMap();
            this.predecessors = new HashMap();
            for (NodePair nodePair : this.edges) {
                if (!hashSet.contains(nodePair) && !hashSet.contains(nodePair.swap())) {
                    hashSet.add(nodePair);
                }
                this.rememberSuccessor(nodePair);
                this.rememberPredecessors(nodePair);
            }
            this.numUndirectedEges = hashSet.size();
        }

        public void add(NodePair nodePair) {
            if (!this.edges.contains(nodePair)) {
                this.edges.add(nodePair);
            }
        }

        public void add(List<NodePair> list) {
            for (NodePair nodePair : list) {
                this.add(nodePair);
            }
        }

        protected Node getStartNode() {
            Set<Node> set = this.getNodes();
            for (Node node : set) {
                if (this.successors.get(node) == null || this.successors.get(node).size() != 1) continue;
                return node;
            }
            return null;
        }

        protected Set<Node> getTerminalNodes() {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Node node : this.getNodes()) {
                if (!this.isTerminalNode(node)) continue;
                hashSet.add(node);
            }
            return hashSet;
        }

        protected Set<Node> getNodes(Stack<NodePair> stack) {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (NodePair nodePair : stack) {
                hashSet.add(nodePair.getA());
                hashSet.add(nodePair.getB());
            }
            return hashSet;
        }

        protected List<NodePair> getOutboundPairs(NodePair nodePair) {
            return this.getOutboundPairs(nodePair.getB());
        }

        protected List<NodePair> getOutboundPairs(Node node) {
            List<NodePair> list = this.successors.get(node);
            return list == null ? Collections.EMPTY_LIST : list;
        }

        protected Set<Node> getNodes() {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (NodePair nodePair : this.edges) {
                hashSet.add(nodePair.getA());
                hashSet.add(nodePair.getB());
            }
            return hashSet;
        }

        protected boolean isSpanningWay(Stack<NodePair> stack) {
            return this.numUndirectedEges == stack.size();
        }

        protected List<Node> buildPathFromNodePairs(Stack<NodePair> stack) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (NodePair nodePair : stack) {
                linkedList.add(nodePair.getA());
            }
            linkedList.add(stack.peek().getB());
            return linkedList;
        }

        protected List<Node> buildSpanningPath(Node node) {
            if (node == null) {
                return null;
            }
            Stack<NodePair> stack = new Stack<NodePair>();
            Stack<NodePair> stack2 = new Stack<NodePair>();
            stack2.addAll(this.getOutboundPairs(node));
            while (!stack2.isEmpty()) {
                NodePair nodePair = (NodePair)stack2.pop();
                if (stack.contains(nodePair) || stack.contains(nodePair.swap())) continue;
                while (!stack.isEmpty() && !((NodePair)stack.peek()).isPredecessorOf(nodePair)) {
                    stack.pop();
                }
                stack.push(nodePair);
                if (this.isSpanningWay(stack)) {
                    return this.buildPathFromNodePairs(stack);
                }
                stack2.addAll(this.getOutboundPairs(stack.peek()));
            }
            return null;
        }

        public List<Node> buildSpanningPath() {
            this.prepare();
            Set<Node> set = this.getTerminalNodes();
            set = set.isEmpty() ? this.getNodes() : set;
            for (Node node : set) {
                List<Node> list = this.buildSpanningPath(node);
                if (list == null) continue;
                return list;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodePair {
        private Node a;
        private Node b;

        public NodePair(Node node, Node node2) {
            this.a = node;
            this.b = node2;
        }

        public NodePair(Pair<Node, Node> pair) {
            this.a = (Node)pair.a;
            this.b = (Node)pair.b;
        }

        public NodePair(NodePair nodePair) {
            this.a = nodePair.a;
            this.b = nodePair.b;
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public boolean isAdjacentToA(NodePair nodePair) {
            return nodePair.getA() == this.a || nodePair.getB() == this.a;
        }

        public boolean isAdjacentToB(NodePair nodePair) {
            return nodePair.getA() == this.b || nodePair.getB() == this.b;
        }

        public boolean isSuccessorOf(NodePair nodePair) {
            return nodePair.getB() == this.a;
        }

        public boolean isPredecessorOf(NodePair nodePair) {
            return this.b == nodePair.getA();
        }

        public NodePair swap() {
            return new NodePair(this.b, this.a);
        }

        public String toString() {
            return "[" + this.a.getId() + "," + this.b.getId() + "]";
        }

        public boolean contains(Node node) {
            return this.a == node || this.b == node;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.a == null ? 0 : this.a.hashCode());
            n = 31 * n + (this.b == null ? 0 : this.b.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NodePair nodePair = (NodePair)object;
            if (this.a == null ? nodePair.a != null : !this.a.equals(nodePair.a)) {
                return false;
            }
            return !(this.b == null ? nodePair.b != null : !this.b.equals(nodePair.b));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WayReferringRelations {
        private Map<Way, Set<Relation>> wayRelationMap = new HashMap<Way, Set<Relation>>();

        public WayReferringRelations(Collection<Way> collection) {
            if (collection == null) {
                return;
            }
            collection.remove(null);
            for (Way way : collection) {
                if (this.wayRelationMap.containsKey(way)) continue;
                this.wayRelationMap.put(way, new HashSet());
            }
        }

        public void build(DataSet dataSet) {
            for (Relation relation : dataSet.relations) {
                if (!relation.isUsable()) continue;
                Set<Way> set = OsmPrimitive.getFilteredSet(relation.getMemberPrimitives(), Way.class);
                for (Way way : this.wayRelationMap.keySet()) {
                    if (!set.contains(way)) continue;
                    this.wayRelationMap.get(way).add(relation);
                }
            }
        }

        public Set<Way> getWays() {
            return this.wayRelationMap.keySet();
        }

        public Set<Relation> getRelations() {
            HashSet<Relation> hashSet = new HashSet<Relation>();
            for (Way way : this.wayRelationMap.keySet()) {
                hashSet.addAll((Collection<Relation>)this.wayRelationMap.get(way));
            }
            return hashSet;
        }

        public Set<Relation> getRelations(Way way) {
            return this.wayRelationMap.get(way);
        }

        protected Command buildRelationUpdateCommand(Relation relation, Collection<Way> collection, Way way) {
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMember relationMember : relation.getMembers()) {
                if (collection.contains(relationMember.getMember())) {
                    RelationMember relationMember2 = new RelationMember(relationMember.getRole(), way);
                    arrayList.add(relationMember2);
                    continue;
                }
                arrayList.add(relationMember);
            }
            Relation relation2 = new Relation(relation);
            relation2.setMembers(arrayList);
            return new ChangeCommand(relation, relation2);
        }

        public List<Command> buildRelationUpdateCommands(Way way) {
            Set<Way> set = this.getWays();
            set.remove(way);
            ArrayList<Command> arrayList = new ArrayList<Command>();
            for (Relation relation : this.getRelations()) {
                Command command = this.buildRelationUpdateCommand(relation, set, way);
                arrayList.add(command);
            }
            return arrayList;
        }
    }
}

