/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    public static final String[] modes = new String[]{I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download")};
    private final String mode;

    private static int getModeShortcut(String string) {
        int n = -1;
        if (string.equals("data")) {
            n = 49;
        }
        if (string.equals("layer")) {
            n = 50;
        }
        if (string.equals("selection")) {
            n = 51;
        }
        if (string.equals("conflict")) {
            n = 52;
        }
        if (string.equals("download")) {
            n = 53;
        }
        return n;
    }

    public AutoScaleAction(String string) {
        super(I18n.tr("Zoom to {0}", I18n.tr(string)), "dialogs/autoscale/" + string, I18n.tr("Zoom the view to {0}.", I18n.tr(string)), Shortcut.registerShortcut("view:zoom" + string, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(string))), AutoScaleAction.getModeShortcut(string), 3), true);
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.putValue("help", "Action/AutoScale/" + string2);
        this.mode = string;
    }

    public void autoScale() {
        BoundingXYVisitor boundingXYVisitor;
        if (Main.map != null && (boundingXYVisitor = this.getBoundingBox()) != null && boundingXYVisitor.getBounds() != null) {
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }
        this.putValue("active", true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.autoScale();
    }

    protected Layer getActiveLayer() {
        try {
            return Main.map.mapView.getActiveLayer();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected Layer getFirstSelectedLayer() {
        if (LayerListDialog.getInstance() == null) {
            return null;
        }
        List<Layer> list = LayerListDialog.getInstance().getModel().getSelectedLayers();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor boundingXYVisitor;
        block11: {
            block13: {
                block12: {
                    block10: {
                        boundingXYVisitor = new BoundingXYVisitor();
                        if (!this.mode.equals("data")) break block10;
                        for (Layer layer : Main.map.mapView.getAllLayers()) {
                            layer.visitBoundingBox(boundingXYVisitor);
                        }
                        break block11;
                    }
                    if (!this.mode.equals("layer")) break block12;
                    if (this.getActiveLayer() == null) {
                        return null;
                    }
                    Layer layer = this.getFirstSelectedLayer();
                    if (layer == null) {
                        return null;
                    }
                    layer.visitBoundingBox(boundingXYVisitor);
                    break block11;
                }
                if (!this.mode.equals("selection") && !this.mode.equals("conflict")) break block13;
                Collection<Object> collection = new HashSet();
                if (this.mode.equals("selection")) {
                    collection = this.getCurrentDataSet().getSelected();
                } else if (this.mode.equals("conflict") && Main.map.conflictDialog.getConflicts() != null) {
                    collection = Main.map.conflictDialog.getConflicts().getMyConflictParties();
                }
                if (collection.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, this.mode.equals("selection") ? I18n.tr("Nothing selected to zoom to.") : I18n.tr("No conflicts to zoom to"), I18n.tr("Information"), 1);
                    return null;
                }
                for (OsmPrimitive osmPrimitive : collection) {
                    osmPrimitive.visit(boundingXYVisitor);
                }
                boundingXYVisitor.enlargeBoundingBox();
                break block11;
            }
            if (!this.mode.equals("download") || !Main.pref.hasKey("osm-download.bounds")) break block11;
            try {
                String[] stringArray = Main.pref.get("osm-download.bounds").split(";");
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                double d3 = Double.parseDouble(stringArray[2]);
                double d4 = Double.parseDouble(stringArray[3]);
                boundingXYVisitor.visit(Main.proj.latlon2eastNorth(new LatLon(d, d2)));
                boundingXYVisitor.visit(Main.proj.latlon2eastNorth(new LatLon(d3, d4)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return boundingXYVisitor;
    }

    protected void updateEnabledState() {
        if ("selection".equals(this.mode)) {
            this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
        } else if ("layer".equals(this.mode)) {
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getAllLayersAsList().isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.hasLayers());
        }
    }
}

