/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction() {
    }

    public AbstractInfoAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2, string3, shortcut, bl);
    }

    public static String getBaseBrowseUrl() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String string2 = pattern.matcher(string).replaceAll("/browse");
        if (string2.equals(string)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to info or history page for OSM primitive will probably fail. API base URL is: ''{0}''", string));
        }
        if (string2.startsWith("http://api.openstreetmap.org/")) {
            string2 = string2.substring("http://api.openstreetmap.org/".length());
            string2 = "http://www.openstreetmap.org/" + string2;
        }
        return string2;
    }

    public static String getBaseUserUrl() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String string2 = pattern.matcher(string).replaceAll("/user");
        if (string2.equals(string)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to user page for OSM user will probably fail. API base URL is: ''{0}''", string));
        }
        if (string2.startsWith("http://api.openstreetmap.org/")) {
            string2 = string2.substring("http://api.openstreetmap.org/".length());
            string2 = "http://www.openstreetmap.org/" + string2;
        }
        return string2;
    }

    protected void launchBrowser(URL uRL) {
        OpenBrowser.displayUrl(uRL.toString());
    }

    protected void launchBrowser(String string) {
        OpenBrowser.displayUrl(string);
    }

    protected boolean confirmLaunchMultiple(int n) {
        String string = I18n.tr("You''re about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", n);
        string = "<html>" + string + "</html>";
        Object[] objectArray = new String[]{I18n.tr("Continue"), I18n.tr("Cancel")};
        int n2 = JOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Warning"), 0, 2, null, objectArray, objectArray[0]);
        return n2 == 0;
    }

    protected void launchInfoBrowsersForSelectedPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(this.getCurrentDataSet().getSelected());
        Iterator<OsmPrimitive> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getId() != 0L) continue;
            iterator.remove();
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation."), I18n.tr("Warning"), 2);
            return;
        }
        int n = Math.min(10, arrayList.size());
        if (arrayList.size() > n && !this.confirmLaunchMultiple(arrayList.size())) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.launchBrowser(this.createInfoUrl(arrayList.get(i)));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.launchInfoBrowsersForSelectedPrimitives();
    }

    protected abstract String createInfoUrl(Object var1);

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }
}

