/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;

public class AboutAction
extends JosmAction {
    private static final String version;
    private static final JTextArea revision;
    private static String time;

    public static String getVersionString() {
        return version;
    }

    public static String getTextBlock() {
        return revision.getText();
    }

    public static void setUserAgent() {
        Properties properties = System.getProperties();
        properties.put("http.agent", "JOSM/1.5 (" + (version.equals(I18n.tr("UNKNOWN")) ? "UNKNOWN" : version) + " " + LanguageInfo.getLanguageCode() + ")");
        System.setProperties(properties);
    }

    public static int getVersionNumber() {
        int n = Integer.MAX_VALUE;
        try {
            n = Integer.parseInt(version.split(" ")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static boolean isDevelopmentVersion() {
        return version.endsWith(" SVN") || version.equals(I18n.tr("UNKNOWN"));
    }

    public AboutAction() {
        super(I18n.tr("About"), "about", I18n.tr("Display the about screen."), Shortcut.registerShortcut("system:about", I18n.tr("About"), 112, 5, 1), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTextArea jTextArea = AboutAction.loadFile(Main.class.getResource("/README"), false);
        JTextArea jTextArea2 = AboutAction.loadFile(Main.class.getResource("/CONTRIBUTION"), false);
        JTextArea jTextArea3 = AboutAction.loadFile(Main.class.getResource("/LICENSE"), false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        jLabel.setFont(new Font("Helvetica", 1, 20));
        jPanel.add((Component)jLabel, GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 10), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Version {0}", version)), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Last change at {0}", time)), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Java Version {0}", System.getProperty("java.version"))), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 10), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Homepage")), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de"), GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Bug Reports")), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eol().fill(2));
        jTabbedPane.addTab(I18n.tr("Info"), jPanel);
        jTabbedPane.addTab(I18n.tr("Readme"), this.createScrollPane(jTextArea));
        jTabbedPane.addTab(I18n.tr("Revision"), this.createScrollPane(revision));
        jTabbedPane.addTab(I18n.tr("Contribution"), this.createScrollPane(jTextArea2));
        jTabbedPane.addTab(I18n.tr("License"), this.createScrollPane(jTextArea3));
        jTabbedPane.addTab(I18n.tr("Plugins"), new JScrollPane(PluginHandler.getInfoPanel()));
        jTabbedPane.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(Main.parent, jTabbedPane, I18n.tr("About JOSM..."), 1, ImageProvider.get("logo"));
    }

    private JScrollPane createScrollPane(JTextArea jTextArea) {
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        return jScrollPane;
    }

    public static String checkLatestVersion() {
        String string;
        try {
            InputStream inputStream = new URL("http://josm.openstreetmap.de/current").openStream();
            string = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return I18n.tr("UNKNOWN");
        }
        return string;
    }

    private static JTextArea loadFile(URL uRL, boolean bl) {
        JTextArea jTextArea = new JTextArea(I18n.tr("File could not be found."));
        jTextArea.setEditable(false);
        Font font = Font.getFont("monospaced");
        if (font != null) {
            jTextArea.setFont(font);
        }
        if (uRL == null) {
            return jTextArea;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = "";
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2 + "\n";
                string2 = bufferedReader.readLine();
            }
            if (bl) {
                string = Pattern.compile("\n ", 32).matcher(string).replaceAll("");
                string = Pattern.compile("^(SHA1-Digest|Name): .*?$", 40).matcher(string).replaceAll("");
                string = Pattern.compile("\n+$", 32).matcher(string).replaceAll("");
            }
            jTextArea.setText(string);
            jTextArea.setCaretPosition(0);
        }
        catch (IOException iOException) {
            System.err.println("Cannot load resource " + uRL + ": " + iOException.getMessage());
        }
        return jTextArea;
    }

    static {
        boolean bl = false;
        URL uRL = Main.class.getResource("/REVISION");
        if (uRL == null) {
            try {
                bl = true;
                uRL = new URL("jar:" + Main.class.getProtectionDomain().getCodeSource().getLocation().toString() + "!/META-INF/MANIFEST.MF");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        revision = AboutAction.loadFile(uRL, bl);
        System.out.println("Revision: " + revision.getText());
        Pattern pattern = Pattern.compile(".*?(?:Revision|Main-Version): ([0-9]*(?: SVN)?).*", 34);
        Matcher matcher = pattern.matcher(revision.getText());
        version = matcher.matches() ? matcher.group(1) : I18n.tr("UNKNOWN");
        Pattern pattern2 = Pattern.compile(".*?(?:Last Changed Date|Main-Date): ([^\n]*).*", 34);
        matcher = pattern2.matcher(revision.getText());
        time = matcher.matches() ? matcher.group(1) : I18n.tr("UNKNOWN");
    }
}

