/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Main {
    public static Component parent;
    public static Main main;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static DataSet pasteBuffer;
    public static Layer pasteSource;
    public static Projection proj;
    public static MapFrame map;
    public static boolean applet;
    public static ToolbarPreferences toolbar;
    public UndoRedoHandler undoRedo = new UndoRedoHandler();
    public final MainMenu menu;
    private GettingStarted gettingStarted = new GettingStarted();
    public static int debug_level;
    public static PlatformHook platform;
    public static final JPanel contentPane;
    public static JPanel panel;
    protected static Rectangle bounds;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        public void commandChanged(int n, int n2) {
            Main.this.menu.undo.setEnabled(n > 0);
            Main.this.menu.redo.setEnabled(n2 > 0);
        }
    };

    public static final void debug(String string) {
        if (debug_level <= 0) {
            return;
        }
        System.out.println(string);
    }

    public final void setMapFrame(MapFrame mapFrame) {
        MapFrame mapFrame2 = map;
        map = mapFrame;
        panel.setVisible(false);
        panel.removeAll();
        if (mapFrame != null) {
            mapFrame.fillPanel(panel);
        } else {
            mapFrame2.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        PluginHandler.setMapFrame(mapFrame2, mapFrame);
    }

    public final void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public Main() {
        this(null);
    }

    public Main(SplashScreen splashScreen) {
        main = this;
        platform.startupHook();
        contentPane.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        if (splashScreen != null) {
            splashScreen.setStatus(I18n.tr("Creating main GUI"));
        }
        this.menu = new MainMenu();
        this.undoRedo.listenerCommands.add(this.redoUndoListener);
        contentPane.add((Component)Main.toolbar.control, "North");
        contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:help", I18n.tr("Help"), 112, 5).getKeyStroke(), "Help");
        contentPane.getActionMap().put("Help", this.menu.help);
        TaggingPresetPreference.initialize();
        MapPaintPreference.initialize();
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPane.updateUI();
    }

    public final void addLayer(Layer layer) {
        if (map == null) {
            MapFrame mapFrame = new MapFrame();
            this.setMapFrame(mapFrame);
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction());
            mapFrame.setVisible(true);
            mapFrame.initializeDialogsPane();
            layer.addPropertyChangeListener(LayerListDialog.getInstance().getModel());
        }
        Main.map.mapView.addLayer(layer);
    }

    public boolean hasEditLayer() {
        if (map == null) {
            return false;
        }
        if (Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getEditLayer() != null;
    }

    public OsmDataLayer getEditLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getEditLayer();
    }

    public DataSet getCurrentDataSet() {
        if (!this.hasEditLayer()) {
            return null;
        }
        return this.getEditLayer().data;
    }

    public static void setProjection(String string) {
        Bounds bounds = map != null && Main.map.mapView != null ? Main.map.mapView.getRealBounds() : null;
        Projection projection = proj;
        try {
            proj = (Projection)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(parent, I18n.tr("The projection {0} could not be activated. Using Mercator", string), I18n.tr("Error"), 0);
            proj = new Mercator();
        }
        if (!proj.equals(projection) && bounds != null) {
            Main.map.mapView.zoomTo(bounds);
        }
    }

    public static void preConstructorInit(Map<String, Collection<String>> map) {
        Object object;
        Main.setProjection(pref.get("projection", Mercator.class.getName()));
        try {
            try {
                object = pref.get("laf");
                if (object != null && ((String)object).length() > 0) {
                    UIManager.setLookAndFeel((String)object);
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.out.println("Look and Feel not supported: " + pref.get("laf"));
            }
            toolbar = new ToolbarPreferences();
            contentPane.updateUI();
            panel.updateUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
        object = Toolkit.getDefaultToolkit().getScreenSize();
        String string = pref.get("gui.geometry");
        if (map.containsKey("geometry")) {
            string = map.get("geometry").iterator().next();
        }
        if (string.length() != 0) {
            Matcher matcher = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(string);
            if (matcher.matches()) {
                int n = Integer.valueOf(matcher.group(1));
                int n2 = Integer.valueOf(matcher.group(2));
                int n3 = 0;
                int n4 = 0;
                if (matcher.group(3) != null) {
                    n3 = Integer.valueOf(matcher.group(5));
                    n4 = Integer.valueOf(matcher.group(7));
                    if (matcher.group(4).equals("-")) {
                        n3 = ((Dimension)object).width - n3 - n;
                    }
                    if (matcher.group(6).equals("-")) {
                        n4 = ((Dimension)object).height - n4 - n2;
                    }
                }
                bounds = new Rectangle(n3, n4, n, n2);
                if (!pref.get("gui.geometry").equals(string)) {
                    pref.put("gui.geometry", string);
                }
            } else {
                System.out.println("Ignoring malformed geometry: " + string);
            }
        }
        if (bounds == null) {
            bounds = !map.containsKey("no-maximize") ? new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height) : new Rectangle(1000, 740);
        }
    }

    public void postConstructorProcessCmdLine(Map<String, Collection<String>> map) {
        if (map.containsKey("download")) {
            for (String string : map.get("download")) {
                Main.downloadFromParamString(false, string);
            }
        }
        if (map.containsKey("downloadgps")) {
            for (String string : map.get("downloadgps")) {
                Main.downloadFromParamString(true, string);
            }
        }
        if (map.containsKey("selection")) {
            for (String string : map.get("selection")) {
                SearchAction.search(string, SearchAction.SearchMode.add, false, false);
            }
        }
    }

    public static boolean saveUnsavedModifications() {
        if (map == null) {
            return true;
        }
        SaveLayersDialog saveLayersDialog = new SaveLayersDialog(parent);
        ArrayList<OsmDataLayer> arrayList = new ArrayList<OsmDataLayer>();
        for (OsmDataLayer osmDataLayer : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
            if (!osmDataLayer.requiresSaveToFile() && !osmDataLayer.requiresUploadToServer()) continue;
            arrayList.add(osmDataLayer);
        }
        saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeExit();
        if (!arrayList.isEmpty()) {
            saveLayersDialog.getModel().populate(arrayList);
            saveLayersDialog.setVisible(true);
            switch (saveLayersDialog.getUserAction()) {
                case CANCEL: {
                    return false;
                }
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static void downloadFromParamString(boolean bl, String string) {
        if (string.startsWith("http:")) {
            Bounds bounds = OsmUrlToBounds.parse(string);
            if (bounds == null) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string), I18n.tr("Warning"), 2);
            } else {
                DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
                downloadOsmTask.download(Main.main.menu.download, bounds.min.lat(), bounds.min.lon(), bounds.max.lat(), bounds.max.lon(), null);
            }
            return;
        }
        if (string.startsWith("file:")) {
            File file = null;
            try {
                file = new File(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string), I18n.tr("Warning"), 2);
            }
            try {
                if (file != null) {
                    OpenFileAction.openFile(file);
                }
            }
            catch (IllegalDataException illegalDataException) {
                illegalDataException.printStackTrace();
                JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", file.getName(), illegalDataException.getMessage()), I18n.tr("Error"), 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", file.getName(), iOException.getMessage()), I18n.tr("Error"), 0);
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 4) {
            try {
                DownloadDialog.DownloadTask downloadTask = bl ? new DownloadGpsTask() : new DownloadOsmTask();
                downloadTask.download(Main.main.menu.download, Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), null);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        File file = new File(string);
        try {
            OpenFileAction.openFile(file);
        }
        catch (IllegalDataException illegalDataException) {
            illegalDataException.printStackTrace();
            JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", file.getName(), illegalDataException.getMessage()), I18n.tr("Error"), 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", file.getName(), iOException.getMessage()), I18n.tr("Error"), 0);
        }
    }

    public static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            System.err.println("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if (string.equals("Linux") || string.equals("Solaris") || string.equals("SunOS") || string.equals("AIX") || string.equals("FreeBSD") || string.equals("NetBSD") || string.equals("OpenBSD")) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            System.err.println("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static void saveGuiGeometry() {
        String string = "";
        String string2 = null;
        try {
            if (((JFrame)parent).getExtendedState() == 0) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle rectangle = parent.getBounds();
                int n = (int)rectangle.getWidth();
                int n2 = (int)rectangle.getHeight();
                int n3 = (int)rectangle.getX();
                int n4 = (int)rectangle.getY();
                if (n > dimension.width) {
                    n = dimension.width;
                }
                if (n2 > dimension.height) {
                    n = dimension.height;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                string = n + "x" + n2 + "+" + n3 + "+" + n4;
            }
            if (map != null && (string2 = Integer.toString(map.getToggleDlgWidth())).equals(Integer.toString(Main.map.DEF_TOGGLE_DLG_WIDTH))) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to save GUI geometry: " + exception);
            exception.printStackTrace();
        }
        pref.put("gui.geometry", string);
        if (string2 != null) {
            pref.put("toggleDialogs.width", string2);
        }
    }

    static {
        worker = Executors.newSingleThreadExecutor();
        pref = new Preferences();
        pasteBuffer = new DataSet();
        applet = false;
        debug_level = 1;
        contentPane = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
    }
}

