/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSquare;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 0;
    protected List<MapMarker> mapMarkerList;
    protected List<MapSquare> mapSquareList;
    protected boolean mapMarkersVisible;
    protected boolean mapSquaresVisible;
    protected boolean tileGridVisible;
    protected TileController tileController;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;

    public JMapViewer() {
        this(new MemoryTileCache(), 4);
        new DefaultMapController(this);
    }

    public JMapViewer(TileCache tileCache, int n) {
        this.tileController = new TileController(new OsmTileSource.Mapnik(), tileCache, this);
        this.mapMarkerList = new LinkedList<MapMarker>();
        this.mapSquareList = new LinkedList<MapSquare>();
        this.mapMarkersVisible = true;
        this.mapSquaresVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(256, 256));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPositionByLatLon(50.0, 9.0, 3);
    }

    protected void initializeZoomSlider() {
        ImageIcon imageIcon;
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.add(this.zoomSlider);
        int n = 18;
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("images/plus.png"));
            this.zoomInButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, n, n);
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomIn();
            }
        });
        this.add(this.zoomInButton);
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("images/minus.png"));
            this.zoomOutButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + n, 155, n, n);
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomOut();
            }
        });
        this.add(this.zoomOutButton);
    }

    public void setDisplayPositionByLatLon(double d, double d2, int n) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), d, d2, n);
    }

    public void setDisplayPositionByLatLon(Point point, double d, double d2, int n) {
        int n2 = OsmMercator.LonToX(d2, n);
        int n3 = OsmMercator.LatToY(d, n);
        this.setDisplayPosition(point, n2, n3, n);
    }

    public void setDisplayPosition(int n, int n2, int n3) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point point, int n, int n2, int n3) {
        if (n3 > this.tileController.getTileSource().getMaxZoom() || n3 < 0) {
            return;
        }
        Point point2 = new Point();
        point2.x = n - point.x + this.getWidth() / 2;
        point2.y = n2 - point.y + this.getHeight() / 2;
        this.center = point2;
        this.setIgnoreRepaint(true);
        try {
            int n4 = this.zoom;
            this.zoom = n3;
            if (n4 != n3) {
                this.zoomChanged(n4);
            }
            if (this.zoomSlider.getValue() != n3) {
                this.zoomSlider.setValue(n3);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    public void setDisplayToFitMapMarkers() {
        int n;
        int n2;
        int n3;
        if (this.mapMarkerList == null || this.mapMarkerList.size() == 0) {
            return;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = this.tileController.getTileSource().getMaxZoom();
        for (MapMarker mapMarker : this.mapMarkerList) {
            n3 = OsmMercator.LonToX(mapMarker.getLon(), n8);
            n2 = OsmMercator.LatToY(mapMarker.getLat(), n8);
            n6 = Math.max(n6, n3);
            n7 = Math.max(n7, n2);
            n4 = Math.min(n4, n3);
            n5 = Math.min(n5, n2);
        }
        int n9 = Math.max(0, this.getHeight());
        int n10 = Math.max(0, this.getWidth());
        n3 = n8;
        n2 = n6 - n4;
        for (n = n7 - n5; n2 > n10 || n > n9; n2 >>= 1, n >>= 1) {
            --n3;
        }
        n2 = n4 + (n6 - n4) / 2;
        n = n5 + (n7 - n5) / 2;
        int n11 = 1 << n8 - n3;
        this.setDisplayPosition(n2 /= n11, n /= n11, n3);
    }

    public void setDisplayToFitMapSquares() {
        int n;
        if (this.mapSquareList == null || this.mapSquareList.size() == 0) {
            return;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = this.tileController.getTileSource().getMaxZoom();
        for (MapSquare mapSquare : this.mapSquareList) {
            n4 = Math.max(n4, OsmMercator.LonToX(mapSquare.getBottomRight().getLon(), n6));
            n5 = Math.max(n5, OsmMercator.LatToY(mapSquare.getTopLeft().getLat(), n6));
            n2 = Math.min(n2, OsmMercator.LonToX(mapSquare.getTopLeft().getLon(), n6));
            n3 = Math.min(n3, OsmMercator.LatToY(mapSquare.getBottomRight().getLat(), n6));
        }
        int n7 = Math.max(0, this.getHeight());
        int n8 = Math.max(0, this.getWidth());
        int n9 = n6;
        int n10 = n4 - n2;
        for (n = n5 - n3; n10 > n8 || n > n7; n10 >>= 1, n >>= 1) {
            --n9;
        }
        n10 = n2 + (n4 - n2) / 2;
        n = n3 + (n5 - n3) / 2;
        int n11 = 1 << n6 - n9;
        this.setDisplayPosition(n10 /= n11, n /= n11, n9);
    }

    public Coordinate getPosition() {
        double d = OsmMercator.XToLon(this.center.x, this.zoom);
        double d2 = OsmMercator.YToLat(this.center.y, this.zoom);
        return new Coordinate(d2, d);
    }

    public Coordinate getPosition(Point point) {
        int n = this.center.x + point.x - this.getWidth() / 2;
        int n2 = this.center.y + point.y - this.getHeight() / 2;
        double d = OsmMercator.XToLon(n, this.zoom);
        double d2 = OsmMercator.YToLat(n2, this.zoom);
        return new Coordinate(d2, d);
    }

    public Coordinate getPosition(int n, int n2) {
        int n3 = this.center.x + n - this.getWidth() / 2;
        int n4 = this.center.y + n2 - this.getHeight() / 2;
        double d = OsmMercator.XToLon(n3, this.zoom);
        double d2 = OsmMercator.YToLat(n4, this.zoom);
        return new Coordinate(d2, d);
    }

    public Point getMapPosition(double d, double d2, boolean bl) {
        int n = OsmMercator.LonToX(d2, this.zoom);
        int n2 = OsmMercator.LatToY(d, this.zoom);
        if (bl && ((n -= this.center.x - this.getWidth() / 2) < 0 || (n2 -= this.center.y - this.getHeight() / 2) < 0 || n > this.getWidth() || n2 > this.getHeight())) {
            return null;
        }
        return new Point(n, n2);
    }

    public Point getMapPosition(double d, double d2) {
        return this.getMapPosition(d, d2, true);
    }

    public Point getMapPosition(Coordinate coordinate) {
        if (coordinate != null) {
            return this.getMapPosition(coordinate.getLat(), coordinate.getLon());
        }
        return null;
    }

    public Point getMapPosition(Coordinate coordinate, boolean bl) {
        if (coordinate != null) {
            return this.getMapPosition(coordinate.getLat(), coordinate.getLon(), bl);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Serializable serializable;
        int n;
        boolean bl;
        super.paintComponent(graphics);
        int n2 = 0;
        int n3 = this.center.x / 256;
        int n4 = this.center.y / 256;
        int n5 = this.center.x % 256;
        int n6 = this.center.y % 256;
        int n7 = this.getWidth() / 2;
        int n8 = this.getHeight() / 2;
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        int n11 = n5;
        int n12 = 256 - n5;
        int n13 = n6;
        int n14 = 256 - n6;
        boolean bl2 = n11 < n12;
        boolean bl3 = bl = n13 < n14;
        n2 = bl ? (bl2 ? 2 : 3) : (bl2 ? 1 : 0);
        int n15 = -256;
        int n16 = -256;
        int n17 = this.getWidth();
        int n18 = this.getHeight();
        boolean bl4 = true;
        int n19 = 0;
        while (bl4) {
            bl4 = false;
            for (n = 0; n < 4; ++n) {
                if (n % 2 == 0) {
                    ++n19;
                }
                for (int i = 0; i < n19; ++i) {
                    Tile tile;
                    if (n15 <= n9 && n9 <= n17 && n16 <= n10 && n10 <= n18 && (tile = this.tileController.getTile(n3, n4, this.zoom)) != null) {
                        bl4 = true;
                        tile.paint(graphics, n9, n10);
                        if (this.tileGridVisible) {
                            graphics.drawRect(n9, n10, 256, 256);
                        }
                    }
                    Point object = move[n2];
                    n9 += object.x * 256;
                    n10 += object.y * 256;
                    n3 += object.x;
                    n4 += object.y;
                }
                n2 = (n2 + 1) % move.length;
            }
        }
        n = 256 << this.zoom;
        graphics.drawRect(n7 - this.center.x, n8 - this.center.y, n, n);
        if (this.mapSquaresVisible && this.mapSquareList != null) {
            for (MapSquare mapSquare : this.mapSquareList) {
                serializable = mapSquare.getTopLeft();
                Coordinate coordinate = mapSquare.getBottomRight();
                if (serializable == null || coordinate == null) continue;
                Point point = this.getMapPosition(((Coordinate)serializable).getLat(), ((Coordinate)serializable).getLon(), false);
                Point point2 = this.getMapPosition(coordinate.getLat(), coordinate.getLon(), false);
                if (point == null || point2 == null) continue;
                mapSquare.paint(graphics, point, point2);
            }
        }
        if (this.mapMarkersVisible && this.mapMarkerList != null) {
            for (MapMarker mapMarker : this.mapMarkerList) {
                serializable = this.getMapPosition(mapMarker.getLat(), mapMarker.getLon());
                if (serializable == null) continue;
                mapMarker.paint(graphics, (Point)serializable);
            }
        }
    }

    public void moveMap(int n, int n2) {
        this.center.x += n;
        this.center.y += n2;
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point point) {
        this.setZoom(this.zoom + 1, point);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point point) {
        this.setZoom(this.zoom - 1, point);
    }

    public void setZoom(int n, Point point) {
        if (n > this.tileController.getTileSource().getMaxZoom() || n < this.tileController.getTileSource().getMinZoom() || n == this.zoom) {
            return;
        }
        Coordinate coordinate = this.getPosition(point);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPositionByLatLon(point, coordinate.getLat(), coordinate.getLon(), n);
    }

    public void setZoom(int n) {
        this.setZoom(n, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected void zoomChanged(int n) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.tileController.getTileSource().getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.tileController.getTileSource().getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean bl) {
        this.tileGridVisible = bl;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean bl) {
        this.mapMarkersVisible = bl;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> list) {
        this.mapMarkerList = list;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void setMapSquareList(List<MapSquare> list) {
        this.mapSquareList = list;
        this.repaint();
    }

    public List<MapSquare> getMapSquareList() {
        return this.mapSquareList;
    }

    public void addMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.add(mapMarker);
        this.repaint();
    }

    public void addMapSquare(MapSquare mapSquare) {
        this.mapSquareList.add(mapSquare);
        this.repaint();
    }

    public void removeMapSquare(MapSquare mapSquare) {
        this.mapSquareList.remove(mapSquare);
        this.repaint();
    }

    public void setZoomContolsVisible(boolean bl) {
        this.zoomSlider.setVisible(bl);
        this.zoomInButton.setVisible(bl);
        this.zoomOutButton.setVisible(bl);
    }

    public boolean getZoomContolsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minumim zoom level too low");
        }
        this.tileController.setTileSource(tileSource);
        this.zoomSlider.setMinimum(tileSource.getMinZoom());
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean bl) {
        this.repaint();
    }

    public boolean isMapSquaresVisible() {
        return this.mapSquaresVisible;
    }

    public void setMapSquaresVisible(boolean bl) {
        this.mapSquaresVisible = bl;
        this.repaint();
    }

    @Override
    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileController.setTileLoader(tileLoader);
    }
}

