/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class PluginSelection {
    private Map<String, Boolean> pluginMap;
    private Map<String, PluginInformation> availablePlugins;
    private Map<String, PluginInformation> localPlugins;

    public void updateDescription(JPanel jPanel) {
        int n = PluginDownloader.downloadDescription();
        if (n > 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("Downloaded plugin information from {0} site", "Downloaded plugin information from {0} sites", n, n));
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No plugin information found."));
        }
        this.drawPanel(jPanel);
    }

    public void update(JPanel jPanel) {
        int n = PluginDownloader.downloadDescription();
        Boolean bl = false;
        this.drawPanel(jPanel);
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : Main.pref.getCollection("plugins", Collections.<String>emptySet())) {
            PluginInformation pluginInformation = this.localPlugins.get(string);
            PluginInformation pluginInformation2 = this.availablePlugins.get(pluginInformation.name);
            if (pluginInformation2.version == null || pluginInformation2.version.equals(pluginInformation.version)) continue;
            hashSet.add(pluginInformation2);
            stringBuilder.append(pluginInformation2.name + "\n");
        }
        if (hashSet.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("All installed plugins are up to date."));
            bl = true;
        } else {
            int n2 = new ExtendedDialog(Main.parent, I18n.tr("Update"), I18n.tr("Update the following plugins:\n\n{0}", stringBuilder.toString()), new String[]{I18n.tr("Update Plugins"), I18n.tr("Cancel")}, new String[]{"dialogs/refresh.png", "cancel.png"}).getValue();
            if (n2 == 1) {
                PluginDownloader.update(hashSet);
                bl = true;
            }
        }
        if (bl.booleanValue() && n >= 1) {
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        this.drawPanel(jPanel);
    }

    public boolean finish() {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        Collection<String> collection = Main.pref.getCollection("plugins", Collections.<String>emptySet());
        String string = "";
        for (Map.Entry<String, Boolean> object2 : this.pluginMap.entrySet()) {
            if (!object2.getValue().booleanValue() || collection.contains(object2.getKey())) continue;
            String string2 = object2.getKey();
            PluginInformation pluginInformation = this.availablePlugins.get(string2);
            PluginInformation pluginInformation2 = this.localPlugins.get(string2);
            if (pluginInformation2 != null && (pluginInformation2.version != null || pluginInformation.version == null) && (pluginInformation2.version == null || pluginInformation2.version.equals(pluginInformation.version))) continue;
            linkedList.add(pluginInformation);
            string = string + string2 + "\n";
        }
        if (!linkedList.isEmpty()) {
            int n = new ExtendedDialog(Main.parent, I18n.tr("Download missing plugins"), I18n.tr("Download the following plugins?\n\n{0}", string), new String[]{I18n.tr("Download Plugins"), I18n.tr("Cancel")}, new String[]{"download.png", "cancel.png"}).getValue();
            LinkedList<PluginInformation> linkedList2 = n != 1 ? linkedList : new PluginDownloader().download(linkedList);
            for (PluginInformation pluginInformation : linkedList2) {
                this.pluginMap.put(pluginInformation.name, false);
            }
        }
        LinkedList linkedList2 = new LinkedList();
        for (Map.Entry<String, Boolean> entry : this.pluginMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            linkedList2.add(entry.getKey());
        }
        Collections.sort(linkedList2);
        return Main.pref.putCollection("plugins", linkedList2);
    }

    public void drawPanel(JPanel jPanel) {
        Cloneable cloneable;
        this.loadPlugins();
        Collection<String> collection = Main.pref.getCollection("plugins", null);
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<String, Boolean>();
        } else {
            cloneable = new HashSet();
            for (String object : this.pluginMap.keySet()) {
                if (this.availablePlugins.get(object) != null) continue;
                cloneable.add(object);
            }
            Iterator<String> iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.pluginMap.remove(string);
            }
        }
        jPanel.removeAll();
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 18;
        int n = 0;
        for (final PluginInformation pluginInformation : this.availablePlugins.values()) {
            String string;
            boolean bl;
            boolean bl2 = bl = collection != null && collection.contains(pluginInformation.name);
            if (this.pluginMap.get(pluginInformation.name) == null) {
                this.pluginMap.put(pluginInformation.name, bl);
            }
            if ((string = pluginInformation.version) == null || string.equals("")) {
                string = I18n.tr("unknown");
            } else if (pluginInformation.oldmode) {
                string = string + "*";
            }
            String string2 = "";
            PluginInformation pluginInformation2 = this.localPlugins.get(pluginInformation.name);
            if (pluginInformation2 != null) {
                string2 = pluginInformation2.version != null && !pluginInformation2.version.equals("") ? pluginInformation2.version : I18n.tr("unknown");
                string2 = " (" + string2 + ")";
            }
            final JCheckBox jCheckBox = new JCheckBox(I18n.tr("{0}: Version {1}{2}", pluginInformation.name, string, string2), (boolean)this.pluginMap.get(pluginInformation.name));
            ((GridBagConstraints)cloneable).gridy = n++;
            ((GridBagConstraints)cloneable).insets = new Insets(5, 5, 0, 5);
            ((GridBagConstraints)cloneable).weighty = 0.1;
            ((GridBagConstraints)cloneable).fill = 0;
            jPanel.add((Component)jCheckBox, cloneable);
            jCheckBox.setToolTipText(pluginInformation.downloadlink != null ? "" + pluginInformation.downloadlink : I18n.tr("Plugin bundled with JOSM"));
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            jEditorPane.setText("<html><body bgcolor=\"#" + Integer.toHexString(UIManager.getColor("Panel.background").getRGB() & 0xFFFFFF) + "\"><i>" + pluginInformation.getLinkDescription() + "</i></body></html>");
            jEditorPane.setBorder(BorderFactory.createEmptyBorder());
            jEditorPane.setBackground(UIManager.getColor("Panel.background"));
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                    }
                }
            });
            ((GridBagConstraints)cloneable).gridy = n++;
            ((GridBagConstraints)cloneable).insets = new Insets(3, 25, 5, 5);
            ((GridBagConstraints)cloneable).weighty = 0.9;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            ((GridBagConstraints)cloneable).anchor = 17;
            ((GridBagConstraints)cloneable).fill = 2;
            jPanel.add((Component)jEditorPane, cloneable);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PluginSelection.this.pluginMap.put(pluginInformation.name, jCheckBox.isSelected());
                }
            });
        }
        jPanel.updateUI();
    }

    private void loadPlugins() {
        this.availablePlugins = new TreeMap<String, PluginInformation>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        this.localPlugins = new TreeMap<String, PluginInformation>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        for (String object : PluginInformation.getPluginLocations()) {
            Object[] objectArray = new File(object).listFiles();
            if (objectArray == null) continue;
            Arrays.sort(objectArray);
            for (Object object2 : objectArray) {
                if (!((File)object2).isFile()) continue;
                String string = ((File)object2).getName();
                if (string.endsWith(".jar")) {
                    try {
                        PluginInformation pluginInformation = new PluginInformation((File)object2, string.substring(0, string.length() - 4));
                        if (!this.availablePlugins.containsKey(pluginInformation.name)) {
                            this.availablePlugins.put(pluginInformation.name, pluginInformation);
                        }
                        if (this.localPlugins.containsKey(pluginInformation.name)) continue;
                        this.localPlugins.put(pluginInformation.name, pluginInformation);
                    }
                    catch (PluginException pluginException) {}
                    continue;
                }
                if (string.endsWith(".jar.new")) {
                    try {
                        PluginInformation n = new PluginInformation((File)object2, string.substring(0, string.length() - 8));
                        this.availablePlugins.put(n.name, n);
                        this.localPlugins.put(n.name, n);
                    }
                    catch (PluginException pluginException) {}
                    continue;
                }
                if (!string.matches("^[0-9]+-site.*\\.txt$")) continue;
                int n = 0;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object2), "utf-8"));
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    Object object3 = bufferedReader.readLine();
                    while (object3 != null) {
                        if (((String)object3).startsWith("\t")) {
                            if (((String)(object3 = ((String)object3).substring(1))).length() > 70) {
                                string4 = string4 + ((String)object3).substring(0, 70) + "\n";
                                object3 = " " + ((String)object3).substring(70);
                            }
                            string4 = string4 + (String)object3 + "\n";
                        } else {
                            Object object4;
                            if (string2 != null) {
                                try {
                                    object4 = new PluginInformation(new ByteArrayInputStream(string4.getBytes("utf-8")), string2.substring(0, string2.length() - 4), string3);
                                    if (!this.availablePlugins.containsKey(object4.name)) {
                                        this.availablePlugins.put(object4.name, (PluginInformation)object4);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    ++n;
                                }
                            }
                            object4 = ((String)object3).split(";");
                            string2 = object4[0];
                            string3 = object4[1];
                            string4 = null;
                        }
                        object3 = bufferedReader.readLine();
                    }
                    if (string2 != null) {
                        object3 = new PluginInformation(new ByteArrayInputStream(string4.getBytes("utf-8")), string2.substring(0, string2.length() - 4), string3);
                        if (!this.availablePlugins.containsKey(((PluginInformation)object3).name)) {
                            this.availablePlugins.put(((PluginInformation)object3).name, (PluginInformation)object3);
                        }
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ++n;
                }
                if (n <= 0) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error reading plugin information file: {0}", ((File)object2).getName()));
            }
        }
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            if (!this.availablePlugins.containsKey(pluginProxy.info.name)) {
                this.availablePlugins.put(pluginProxy.info.name, pluginProxy.info);
            }
            if (this.localPlugins.containsKey(pluginProxy.info.name)) continue;
            this.localPlugins.put(pluginProxy.info.name, pluginProxy.info);
        }
    }
}

