/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AddVisitor;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmReader {
    private DataSet ds = new DataSet();
    private String parseNotes = new String();
    private int parseNotesCount = 0;
    private Set<Long> skippedWayIds = new HashSet<Long>();
    private AddVisitor adder = new AddVisitor(this.ds);
    private Map<Long, Node> nodes = new HashMap<Long, Node>();
    private Map<OsmPrimitiveData, Collection<Long>> ways = new HashMap<OsmPrimitiveData, Collection<Long>>();
    private Map<OsmPrimitiveData, Collection<RelationMemberData>> relations = new HashMap<OsmPrimitiveData, Collection<RelationMemberData>>();

    public DataSet getDs() {
        return this.ds;
    }

    public String getParseNotes() {
        return this.parseNotes;
    }

    private OsmReader() {
    }

    void readCommon(Attributes attributes, OsmPrimitiveData osmPrimitiveData) throws SAXException {
        String string;
        String string2;
        String string3;
        osmPrimitiveData.id = this.getLong(attributes, "id");
        if (osmPrimitiveData.id == 0L) {
            throw new SAXException(I18n.tr("Illegal object with id=0"));
        }
        String string4 = attributes.getValue("timestamp");
        if (string4 != null && string4.length() != 0) {
            osmPrimitiveData.timestamp = DateUtils.fromString(string4);
        }
        if ((string3 = attributes.getValue("user")) != null) {
            osmPrimitiveData.user = User.get(string3);
        }
        if ((string2 = attributes.getValue("uid")) != null && osmPrimitiveData.user != null) {
            osmPrimitiveData.user.uid = string2;
        }
        if ((string = attributes.getValue("visible")) != null) {
            osmPrimitiveData.visible = Boolean.parseBoolean(string);
        }
        String string5 = attributes.getValue("version");
        osmPrimitiveData.version = 0;
        if (string5 != null) {
            try {
                osmPrimitiveData.version = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException(I18n.tr("Illegal value for attribute \"version\" on OSM primitive with id {0}, got {1}", Long.toString(osmPrimitiveData.id), string5));
            }
        } else if (osmPrimitiveData.id > 0L && this.ds.version != null && this.ds.version.equals("0.6")) {
            throw new SAXException(I18n.tr("Missing attribute \"version\" on OSM primitive with id {0}", Long.toString(osmPrimitiveData.id)));
        }
        String string6 = attributes.getValue("action");
        if (string6 == null) {
            return;
        }
        if (string6.equals("delete")) {
            osmPrimitiveData.deleted = true;
        } else if (string6.startsWith("modify")) {
            osmPrimitiveData.modified = true;
        }
    }

    private long getLong(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new SAXException(I18n.tr("Missing required attribute \"{0}\".", string));
        }
        return Long.parseLong(string2);
    }

    private Node findNode(long l) {
        Node node = this.nodes.get(l);
        if (node != null) {
            return node;
        }
        return null;
    }

    protected void createWays() {
        for (Map.Entry<OsmPrimitiveData, Collection<Long>> entry : this.ways.entrySet()) {
            Way way = new Way();
            boolean bl = false;
            for (long l : entry.getValue()) {
                Node node = this.findNode(l);
                if (node == null) {
                    if (this.parseNotesCount++ < 6) {
                        this.parseNotes = this.parseNotes + I18n.tr("Skipping a way because it includes a node that doesn''t exist: {0}\n", l);
                    } else if (this.parseNotesCount == 6) {
                        this.parseNotes = this.parseNotes + "...\n";
                    }
                    bl = true;
                    break;
                }
                way.nodes.add(node);
            }
            if (bl) {
                this.skippedWayIds.add(entry.getKey().id);
                continue;
            }
            entry.getKey().copyTo(way);
            this.adder.visit(way);
        }
    }

    private Way findWay(long l) {
        for (Way way : this.ds.ways) {
            if (way.id != l) continue;
            return way;
        }
        return null;
    }

    private Relation findRelation(long l) {
        for (Relation relation : this.ds.relations) {
            if (relation.id != l) continue;
            return relation;
        }
        return null;
    }

    private void createRelations() {
        for (Map.Entry<OsmPrimitiveData, Collection<RelationMemberData>> iterator : this.relations.entrySet()) {
            Relation relation = new Relation();
            iterator.getKey().copyTo(relation);
            this.adder.visit(relation);
        }
        Object object = new HashMap(10000);
        for (Way way : this.ds.ways) {
            ((HashMap)object).put(way.id, way);
        }
        for (Map.Entry<OsmPrimitiveData, Collection<RelationMemberData>> entry : this.relations.entrySet()) {
            Relation relation = this.findRelation(entry.getKey().id);
            if (relation == null) {
                throw new Error("Failed to create relation " + entry.getKey().id);
            }
            for (RelationMemberData relationMemberData : entry.getValue()) {
                RelationMember relationMember = relationMemberData.relationMember;
                if (relationMemberData.type.equals("node")) {
                    relationMember.member = this.findNode(relationMemberData.id);
                    if (relationMember.member == null) {
                        relationMember.member = new Node(relationMemberData.id);
                        this.adder.visit((Node)relationMember.member);
                    }
                } else if (relationMemberData.type.equals("way")) {
                    relationMember.member = (OsmPrimitive)((HashMap)object).get(relationMemberData.id);
                    if (relationMember.member == null) {
                        relationMember.member = this.findWay(relationMemberData.id);
                    }
                    if (relationMember.member == null) {
                        relationMember.member = new Way(relationMemberData.id);
                        this.adder.visit((Way)relationMember.member);
                    }
                } else if (relationMemberData.type.equals("relation")) {
                    relationMember.member = this.findRelation(relationMemberData.id);
                    if (relationMember.member == null) {
                        relationMember.member = new Relation(relationMemberData.id);
                        this.adder.visit((Relation)relationMember.member);
                    }
                }
                relation.members.add(relationMember);
            }
        }
        object = null;
    }

    public static DataSet parseDataSet(InputStream inputStream, PleaseWaitDialog pleaseWaitDialog) throws SAXException, IOException {
        return OsmReader.parseDataSetOsm((InputStream)inputStream, (PleaseWaitDialog)pleaseWaitDialog).ds;
    }

    public static OsmReader parseDataSetOsm(InputStream inputStream, PleaseWaitDialog pleaseWaitDialog) throws SAXException, IOException {
        OsmReader osmReader = new OsmReader();
        InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmReader osmReader2 = osmReader;
            osmReader2.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmReader2.new Parser());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Prepare OSM data..."));
        Main.pleaseWaitDlg.setIndeterminate(true);
        for (Node osmPrimitive : osmReader.nodes.values()) {
            osmReader.adder.visit(osmPrimitive);
        }
        try {
            osmReader.createWays();
            osmReader.createRelations();
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new SAXException(I18n.tr("Ill-formed node id"));
        }
        for (OsmPrimitive osmPrimitive : osmReader.ds.allPrimitives()) {
            if (osmPrimitive.id >= 0L) continue;
            osmPrimitive.id = 0L;
        }
        Main.pleaseWaitDlg.setIndeterminate(false);
        Main.pleaseWaitDlg.progress.setValue(0);
        return osmReader;
    }

    public Set<Long> getSkippedWayIds() {
        return this.skippedWayIds;
    }

    private class Parser
    extends DefaultHandler {
        private OsmPrimitiveData current;
        private String generator;

        private Parser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block25: {
                try {
                    if (string3.equals("osm")) {
                        if (attributes == null) {
                            throw new SAXException(I18n.tr("Unknown version"));
                        }
                        String string4 = attributes.getValue("version");
                        if (string4 == null) {
                            throw new SAXException(I18n.tr("Version number missing from OSM data"));
                        }
                        if (!string4.equals("0.5") && !string4.equals("0.6")) {
                            throw new SAXException(I18n.tr("Unknown version: {0}", string4));
                        }
                        this.generator = attributes.getValue("generator");
                        ((OsmReader)OsmReader.this).ds.version = string4;
                        break block25;
                    }
                    if (string3.equals("bounds")) {
                        String string5 = attributes.getValue("minlon");
                        String string6 = attributes.getValue("minlat");
                        String string7 = attributes.getValue("maxlon");
                        String string8 = attributes.getValue("maxlat");
                        String string9 = attributes.getValue("origin");
                        if (string5 != null && string7 != null && string6 != null && string8 != null) {
                            if (string9 == null) {
                                string9 = this.generator;
                            }
                            Bounds bounds = new Bounds(new LatLon(Double.parseDouble(string6), Double.parseDouble(string5)), new LatLon(Double.parseDouble(string8), Double.parseDouble(string7)));
                            DataSource dataSource = new DataSource(bounds, string9);
                            ((OsmReader)OsmReader.this).ds.dataSources.add(dataSource);
                        }
                        break block25;
                    }
                    if (string3.equals("node")) {
                        this.current = new OsmPrimitiveData();
                        this.current.latlon = new LatLon(this.getDouble(attributes, "lat"), this.getDouble(attributes, "lon"));
                        OsmReader.this.readCommon(attributes, this.current);
                        break block25;
                    }
                    if (string3.equals("way")) {
                        this.current = new OsmPrimitiveData();
                        OsmReader.this.readCommon(attributes, this.current);
                        OsmReader.this.ways.put(this.current, new ArrayList());
                        break block25;
                    }
                    if (string3.equals("nd")) {
                        Collection collection = (Collection)OsmReader.this.ways.get(this.current);
                        if (collection == null) {
                            throw new SAXException(I18n.tr("Found <nd> element in non-way."));
                        }
                        long l = OsmReader.this.getLong(attributes, "ref");
                        if (l == 0L) {
                            throw new SAXException(I18n.tr("<nd> has zero ref"));
                        }
                        collection.add(l);
                        break block25;
                    }
                    if (string3.equals("relation")) {
                        this.current = new OsmPrimitiveData();
                        OsmReader.this.readCommon(attributes, this.current);
                        OsmReader.this.relations.put(this.current, new LinkedList());
                        break block25;
                    }
                    if (string3.equals("member")) {
                        Collection collection = (Collection)OsmReader.this.relations.get(this.current);
                        if (collection == null) {
                            throw new SAXException(I18n.tr("Found <member> element in non-relation."));
                        }
                        RelationMemberData relationMemberData = new RelationMemberData();
                        relationMemberData.relationMember = new RelationMember();
                        String string10 = attributes.getValue("ref");
                        if (string10 == null) {
                            throw new SAXException(I18n.tr("Missing attribute \"ref\" on member in relation {0}", this.current.id));
                        }
                        try {
                            relationMemberData.id = Long.parseLong(string10);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SAXException(I18n.tr("Illegal value for attribute \"ref\" on member in relation {0}, got {1}", Long.toString(this.current.id), string10));
                        }
                        string10 = attributes.getValue("type");
                        if (string10 == null) {
                            throw new SAXException(I18n.tr("Missing attribute \"type\" on member {0} in relation {1}", Long.toString(relationMemberData.id), Long.toString(this.current.id)));
                        }
                        if (!(string10.equals("way") || string10.equals("node") || string10.equals("relation"))) {
                            throw new SAXException(I18n.tr("Unexpected \"type\" on member {0} in relation {1}, got {2}.", Long.toString(relationMemberData.id), Long.toString(this.current.id), string10));
                        }
                        relationMemberData.type = string10;
                        relationMemberData.relationMember.role = string10 = attributes.getValue("role");
                        if (relationMemberData.id == 0L) {
                            throw new SAXException(I18n.tr("Incomplete <member> specification with ref=0"));
                        }
                        collection.add(relationMemberData);
                        break block25;
                    }
                    if (string3.equals("tag")) {
                        String string11 = attributes.getValue("k");
                        String string12 = attributes.getValue("v");
                        this.current.keys.put(string11, string12);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new SAXException(numberFormatException.getMessage(), numberFormatException);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                    throw new SAXException(I18n.tr("NullPointerException, possibly some missing tags."), nullPointerException);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("node")) {
                OsmReader.this.nodes.put(this.current.id, this.current.createNode());
            }
        }

        private double getDouble(Attributes attributes, String string) {
            return Double.parseDouble(attributes.getValue(string));
        }
    }

    private static class RelationMemberData {
        public String type;
        public long id;
        public RelationMember relationMember;

        private RelationMemberData() {
        }
    }

    private static class OsmPrimitiveData {
        public long id = 0L;
        public Map<String, String> keys = new HashMap<String, String>();
        public boolean modified = false;
        public boolean selected = false;
        public boolean deleted = false;
        public Date timestamp = new Date();
        public User user = null;
        public boolean visible = true;
        public int version = -1;
        public LatLon latlon = new LatLon(0.0, 0.0);

        private OsmPrimitiveData() {
        }

        public void copyTo(OsmPrimitive osmPrimitive) {
            osmPrimitive.id = this.id;
            osmPrimitive.keys = this.keys;
            osmPrimitive.modified = this.modified;
            osmPrimitive.selected = this.selected;
            osmPrimitive.deleted = this.deleted;
            osmPrimitive.setTimestamp(this.timestamp);
            osmPrimitive.user = this.user;
            osmPrimitive.visible = this.visible;
            osmPrimitive.version = this.version;
            osmPrimitive.mappaintStyle = null;
        }

        public Node createNode() {
            Node node = new Node(this.latlon);
            this.copyTo(node);
            return node;
        }

        public Way createWay() {
            Way way = new Way(this.id);
            this.copyTo(way);
            return way;
        }

        public Relation createRelation() {
            Relation relation = new Relation(this.id);
            this.copyTo(relation);
            return relation;
        }
    }
}

