/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmApiException
extends OsmTransferException {
    private int responseCode;
    private String errorHeader;
    private String errorBody;

    public OsmApiException() {
    }

    public OsmApiException(int n, String string, String string2) {
        this.responseCode = n;
        this.errorHeader = string;
        this.errorBody = string2;
    }

    public OsmApiException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public OsmApiException(String string) {
        super(string);
    }

    public OsmApiException(Throwable throwable) {
        super(throwable);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public String getErrorHeader() {
        return this.errorHeader;
    }

    public void setErrorHeader(String string) {
        this.errorHeader = string;
    }

    public String getErrorBody() {
        return this.errorBody;
    }

    public void setErrorBody(String string) {
        this.errorBody = string;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ResponseCode=").append(this.responseCode);
        if (this.errorHeader != null) {
            stringBuilder.append(", Error Header=<").append(this.errorHeader).append(">");
        }
        if (this.errorBody != null) {
            this.errorBody = this.errorBody.trim();
            if (!this.errorBody.equals(this.errorHeader)) {
                stringBuilder.append(", Error Body=<").append(this.errorBody).append(">");
            }
        }
        return stringBuilder.toString();
    }

    public String getDisplayMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorHeader != null) {
            stringBuilder.append(I18n.tr(this.errorHeader));
            stringBuilder.append(I18n.tr("(Code={0})", this.responseCode));
        } else if (this.errorBody != null) {
            this.errorBody = this.errorBody.trim();
            stringBuilder.append(I18n.tr(this.errorBody));
            stringBuilder.append(I18n.tr("(Code={0})", this.responseCode));
        } else {
            stringBuilder.append(I18n.tr("The server replied an error with code {0}", this.responseCode));
        }
        return stringBuilder.toString();
    }
}

