/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFetchServerObjectReader
extends OsmServerReader {
    private static Logger logger = Logger.getLogger(MultiFetchServerObjectReader.class.getName());
    private static int MAX_IDS_PER_REQUEST = 200;
    private HashSet<Long> nodes = new HashSet();
    private HashSet<Long> ways = new HashSet();
    private HashSet<Long> relations = new HashSet();
    private HashSet<Long> missingPrimitives;
    private HashSet<Long> skippedWayIds;
    private DataSet outputDataSet = new DataSet();

    public MultiFetchServerObjectReader() {
        this.missingPrimitives = new HashSet();
    }

    protected void remember(long l, OsmPrimitiveType osmPrimitiveType) {
        if (l <= 0L) {
            return;
        }
        if (osmPrimitiveType.equals((Object)OsmPrimitiveType.NODE)) {
            this.nodes.add(l);
        } else if (osmPrimitiveType.equals((Object)OsmPrimitiveType.WAY)) {
            this.ways.add(l);
        }
        if (osmPrimitiveType.equals((Object)OsmPrimitiveType.RELATION)) {
            this.relations.add(l);
        }
    }

    protected void remember(DataSet dataSet, long l) throws IllegalArgumentException, NoSuchElementException {
        if (dataSet == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "ds"));
        }
        if (l <= 0L) {
            return;
        }
        OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(l);
        if (osmPrimitive == null) {
            throw new NoSuchElementException(I18n.tr("no primitive with id {0} in local dataset. Can't infer primitive type", l));
        }
        this.remember(l, OsmPrimitiveType.from(osmPrimitive));
    }

    public MultiFetchServerObjectReader append(DataSet dataSet, long ... lArray) {
        if (lArray == null) {
            return this;
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.remember(dataSet, lArray[i]);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(DataSet dataSet, Collection<Long> collection) {
        if (collection == null) {
            return null;
        }
        for (long l : collection) {
            this.append(dataSet, l);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Node node) {
        if (node == null) {
            return this;
        }
        if (node.id == 0L) {
            return this;
        }
        this.remember(node.id, OsmPrimitiveType.NODE);
        return this;
    }

    public MultiFetchServerObjectReader append(Way way) {
        if (way == null) {
            return this;
        }
        if (way.id == 0L) {
            return this;
        }
        for (Node node : way.nodes) {
            if (node.id <= 0L) continue;
            this.remember(node.id, OsmPrimitiveType.NODE);
        }
        this.remember(way.id, OsmPrimitiveType.WAY);
        return this;
    }

    public MultiFetchServerObjectReader append(Relation relation) {
        if (relation == null) {
            return this;
        }
        if (relation.id == 0L) {
            return this;
        }
        this.remember(relation.id, OsmPrimitiveType.RELATION);
        for (RelationMember relationMember : relation.members) {
            this.appendGeneric(relationMember.member);
        }
        return this;
    }

    protected MultiFetchServerObjectReader appendGeneric(OsmPrimitive osmPrimitive) {
        if (OsmPrimitiveType.from(osmPrimitive).equals((Object)OsmPrimitiveType.NODE)) {
            return this.append((Node)osmPrimitive);
        }
        if (OsmPrimitiveType.from(osmPrimitive).equals((Object)OsmPrimitiveType.WAY)) {
            return this.append((Way)osmPrimitive);
        }
        if (OsmPrimitiveType.from(osmPrimitive).equals((Object)OsmPrimitiveType.RELATION)) {
            return this.append((Relation)osmPrimitive);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Collection<OsmPrimitive> collection) {
        if (collection == null) {
            return this;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            this.appendGeneric(osmPrimitive);
        }
        return this;
    }

    protected Set<Long> extractIdPackage(Set<Long> set) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (set.isEmpty()) {
            return hashSet;
        }
        if (set.size() > MAX_IDS_PER_REQUEST) {
            Iterator<Long> iterator = set.iterator();
            for (int i = 0; i < MAX_IDS_PER_REQUEST; ++i) {
                hashSet.add(iterator.next());
            }
            set.removeAll(hashSet);
        } else {
            hashSet.addAll(set);
            set.clear();
        }
        return hashSet;
    }

    protected String buildRequestString(OsmPrimitiveType osmPrimitiveType, Set<Long> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(osmPrimitiveType.getAPIName()).append("s?").append(osmPrimitiveType.getAPIName()).append("s=");
        Iterator<Long> iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            stringBuilder.append(iterator.next());
            if (i >= set.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    protected String buildRequestString(OsmPrimitiveType osmPrimitiveType, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(osmPrimitiveType.getAPIName()).append("s?").append(osmPrimitiveType.getAPIName()).append("s=").append(l);
        return stringBuilder.toString();
    }

    protected void multiGetIdPackage(OsmPrimitiveType osmPrimitiveType, Set<Long> set) throws OsmTransferException {
        String string = this.buildRequestString(osmPrimitiveType, set);
        InputStream inputStream = this.getInputStream(string, Main.pleaseWaitDlg);
        if (inputStream == null) {
            return;
        }
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading OSM data..."));
        try {
            OsmReader osmReader = OsmReader.parseDataSetOsm(inputStream, Main.pleaseWaitDlg);
            this.skippedWayIds.addAll(osmReader.getSkippedWayIds());
            this.merge(osmReader.getDs());
        }
        catch (IOException iOException) {
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
    }

    protected void singleGetId(OsmPrimitiveType osmPrimitiveType, long l) throws OsmTransferException {
        String string = this.buildRequestString(osmPrimitiveType, l);
        InputStream inputStream = this.getInputStream(string, Main.pleaseWaitDlg);
        if (inputStream == null) {
            return;
        }
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading OSM data..."));
        try {
            OsmReader osmReader = OsmReader.parseDataSetOsm(inputStream, Main.pleaseWaitDlg);
            this.skippedWayIds.addAll(osmReader.getSkippedWayIds());
            this.merge(osmReader.getDs());
        }
        catch (IOException iOException) {
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
    }

    protected void singleGetIdPackage(OsmPrimitiveType osmPrimitiveType, Set<Long> set) throws OsmTransferException {
        for (long l : set) {
            try {
                this.singleGetId(osmPrimitiveType, l);
            }
            catch (OsmApiException osmApiException) {
                if (osmApiException.getResponseCode() == 404) {
                    logger.warning(I18n.tr("Server replied with response code 404 for id {0}. Skipping.", Long.toString(l)));
                    this.missingPrimitives.add(l);
                    continue;
                }
                throw osmApiException;
            }
        }
    }

    protected void merge(DataSet dataSet) {
        MergeVisitor mergeVisitor = new MergeVisitor(this.outputDataSet, dataSet);
        mergeVisitor.merge();
    }

    protected void fetchPrimitives(Set<Long> set, OsmPrimitiveType osmPrimitiveType) throws OsmTransferException {
        HashSet<Long> hashSet = new HashSet<Long>(set);
        hashSet.addAll(set);
        while (!hashSet.isEmpty()) {
            Set<Long> set2 = this.extractIdPackage(hashSet);
            try {
                this.multiGetIdPackage(osmPrimitiveType, set2);
            }
            catch (OsmApiException osmApiException) {
                if (osmApiException.getResponseCode() == 404) {
                    logger.warning(I18n.tr("Server replied with response code 404, retrying with an individual request for each primitive"));
                    this.singleGetIdPackage(osmPrimitiveType, set2);
                    continue;
                }
                throw osmApiException;
            }
        }
    }

    @Override
    public DataSet parseOsm() throws OsmTransferException {
        this.skippedWayIds = new HashSet();
        this.missingPrimitives = new HashSet();
        this.fetchPrimitives(this.nodes, OsmPrimitiveType.NODE);
        this.fetchPrimitives(this.ways, OsmPrimitiveType.WAY);
        this.fetchPrimitives(this.relations, OsmPrimitiveType.RELATION);
        return this.outputDataSet;
    }

    public Set<Long> getSkippedWays() {
        return this.skippedWayIds;
    }

    public Set<Long> getMissingPrimitives() {
        return this.missingPrimitives;
    }
}

